(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    237619,       4614]
NotebookOptionsPosition[    230012,       4372]
NotebookOutlinePosition[    231739,       4415]
CellTagsIndexPosition[    231652,       4410]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"JPEG\"" :> Documentation`HelpLookup["paclet:ref/format/JPEG"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"JPEG\\\"\"\>", 
       3->"\<\"\\\"PNG\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], "Image Processing" :> 
          Documentation`HelpLookup["paclet:guide/ImageProcessing"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Print Formats" :> 
          Documentation`HelpLookup["paclet:guide/PrintFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Importing & Exporting\"\>", 
       2->"\<\"Image Processing\"\>", 3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 5->"\<\"Print Formats\"\>", 
       6->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "TIFF ",
 StyleBox["(.tiff, .tif)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->19281],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["image/tiff", "InlineCode"],
 "\nTIFF raster image format.\nCommonly used in image manipulation \
applications, page layout applications, scanners and other imaging devices, \
and for the archiving of images.\nSuitable for high-color-depth images. \n\
TIFF is an acronym for Tagged Image File Format.\nBinary format.\nSupports \
multiple color resolutions, color encodings, and compression methods.\n\
Supports arbitrary bit depths of up to 16 bits per channel, and also 32 bits \
per channel.\nCan store multiple images.\nSupports alpha channels.\n\
Introduced in the 1980s by Aldus as a standard format for desktop scanners."
}], "FormatUsage",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the TIFF 6.0 specification."
}], "FormatNotes",
 CellID->9152]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", "]"}]], "InlineFormula"],
 " imports a TIFF file, returning a single image or a list of images."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as an image to a ",
 "TIFF",
 " file."
}], "FormatNotes",
 CellID->8194],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["g", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " exports a list of graphics as a multi-image TIFF file."
}], "FormatNotes",
 CellID->9876],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}]}]], "InlineFormula"],
 "], where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of color indices. "
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a ",
 "TIFF",
 " image with the same image size as the displayed form of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->7572],

Cell["\<\
Because TIFF is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->6249],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " reduces 32-bit images to a 16-bit representation."
}], "FormatNotes",
 CellID->925313720],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "TIFF",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<TIFF\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<TIFF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "TIFF",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tiff\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "TIFF",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Insert \[FilledRightTriangle] Picture", "MenuName"],
 " and the ",
 StyleBox["Open", "MenuName"],
 " menu allow import of a ",
 "TIFF",
 " file into a cell. "
}], "FormatNotes",
 CellID->2609],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a ",
 "TIFF",
 " file."
}], "FormatNotes",
 CellID->11064]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->9166],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->16893],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16074],

Cell["Data representation elements:", "FormatNotes",
 CellID->30300],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Animation\>\"", Cell[
    "multi-image TIFF represented as an animation object", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[
    "the first image in the file, given as graphics", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsList\>\"", Cell[
    "all images as a list of graphics", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->19695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " for simple TIFF files and ",
 Cell[BoxData["\"\<GraphicsList\>\""], "InlineFormula"],
 " for multi-image TIFF files."
}], "FormatNotes",
 CellID->9573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " of a multi-image TIFF with element ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " gives the first image."
}], "FormatNotes",
 CellID->15589],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default generates a multi-image TIFF if the expression supplied is a \
list of ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " objects."
}], "FormatNotes",
 CellID->13161],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " with element ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " always generates a single-image TIFF."
}], "FormatNotes",
 CellID->31172],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->19426],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Background\>\"", Cell[
    "background color shown in transparent image regions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "bits used to represent each color channel in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageCount\>\"", Cell[
    "number of images in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageEncoding\>\"", Cell[
    "how images are compressed in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->28510],

Cell["Data representation elements:", "FormatNotes",
 CellID->980792937],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorMap\>\"", Cell[
    "color-reduction palette", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values, represented as integers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "overall image size", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RawData\>\"", Cell[
    "array of color map indices", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->102417787],

Cell["\<\
For multi-image TIFFs, the above data representation elements are taken to be \
lists of the respective expressions.\
\>", "FormatNotes",
 CellID->1201344862],

Cell["Metadata elements:", "FormatNotes",
 CellID->361846540],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Author\>\"", Cell[
    "person who created the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CameraTopOrientation\>\"", Cell[
    "orientation of the camera when the picture was taken", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Comments\>\"", Cell[
    "user comments", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CopyrightNotice\>\"", Cell[
    "copyright information as a string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Device\>\"", Cell[
    "model specification of the camera or input device", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DeviceManufacturer\>\"", Cell[
    "maker of the camera or input device", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageCreationDate\>\"", Cell[
    TextData[{
     "date and time the original picture was taken, given as a ",
     Cell[BoxData[
      ButtonBox["DateList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
     " specification"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->29975]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->10422],

Cell["General options:", "FormatNotes",
 CellID->30774],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "background color shown in transparent image regions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    RowBox[{"-", "1"}], Cell["ordering of bytes in the file ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageResolution",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageResolution"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "resolution used for rendering the graphics", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->8779],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->454840903],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ImageTopOrientation\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell[
    "orientation of the image as stored in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1616757048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula",
  ShowStringCharacters->False],
 " options:"
}], "FormatNotes",
 CellID->5764],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "color encoding to be used in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CompressionLevel\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "compression level, given as a number between 0 and 1", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageEncoding\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how images are compressed in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DifferencingPredictor\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to use horizontal differencing when using LZW or ZIP compression\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorSeparation\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to store color channels in separate planes", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->874],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " to TIFF supports ",
 Cell[BoxData[
  ButtonBox["CMYKColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CMYKColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " color spaces."
}], "FormatNotes",
 CellID->24084],

Cell[TextData[{
 "The following settings for ",
 Cell[BoxData["\"\<ImageEncoding\>\""], "InlineFormula"],
 " are supported:"
}], "FormatNotes",
 CellID->1729922196],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no compression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<JPEG\>\"", Cell[
    "lossy JPEG compression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LZW\>\"", Cell[
    "lossless LZW compression", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PackBits\>\"", Cell[
    "PackBits run-length encoding method", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ZIP\>\"", Cell[
    "lossless ZIP image data compression", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->1599644427]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->26122],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25605],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JPEG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JPEG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21251439]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->176385089],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Image Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImageProcessing"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Print Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrintFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->32379179],

Cell[TextData[{
 "This imports a TIFF example file, rendering it as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->439993043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/spikey.tiff\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7950],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsvQV8FOfaNr5xw6VIaQt1O5VTb0/1tKelFIcipVAcirsGCRJoIAQLgQRN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   "], {{0, 0}, {232, 240}}, {0, 255},
   ColorFunction->RGBColor],
  ImageMargins->0.,
  ImageSize->{232, 240},
  PlotRange->{{0, 232}, {0, 240}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->690649871]
}, Open  ]],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in this file:"
}], "ExampleText",
 CellID->621926074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/spikey.tiff\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1465113566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Animation\"\>", ",", "\<\"Author\"\>", ",", "\<\"BitDepth\"\>",
    ",", "\<\"CameraTopOrientation\"\>", ",", "\<\"ColorMap\"\>", 
   ",", "\<\"ColorSpace\"\>", ",", "\<\"Comments\"\>", 
   ",", "\<\"CopyrightNotice\"\>", ",", "\<\"Data\"\>", 
   ",", "\<\"DataType\"\>", ",", "\<\"Device\"\>", 
   ",", "\<\"DeviceManufacturer\"\>", ",", "\<\"Frames\"\>", 
   ",", "\<\"Graphics\"\>", ",", "\<\"GrayLevels\"\>", 
   ",", "\<\"ImageCreationDate\"\>", ",", "\<\"ImageEncoding\"\>", 
   ",", "\<\"ImageResolution\"\>", ",", "\<\"ImageSize\"\>", 
   ",", "\<\"RawData\"\>", ",", "\<\"RGBColorArray\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1116207260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1176877080],

Cell[TextData[{
 "Create a raster image using ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " and export it to TIFF:"
}], "ExampleText",
 CellID->1448694690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Mean", "/@", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"110", ",", " ", 
        RowBox[{"{", 
         RowBox[{"2", ",", " ", "1"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", " ", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", "1", "}"}], "}"}], ",", "0"}], "}"}], ",", "100"}], 
     "]"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", " ", "\"\<DarkBands\>\""}], ",", 
   RowBox[{"Frame", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42065144],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzsnWd0ldXW7zmAICJCRAEVkKJ0BJQmIlNAQKoocBAE6YqKQZoFJDRBEOk1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   "], {{0, 0}, {201, 101}}, {0, 1}],
  Frame->False,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[1]=",
 CellID->772847416]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<image.tiff\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2146804571],

Cell[BoxData["\<\"image.tiff\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1756223705]
}, Open  ]],

Cell["\<\
Import this file as a raster of gray-level values, and render it as raster \
graphics after reversing the order of the rows:\
\>", "ExampleText",
 CellID->1787706288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Raster", "[", " ", 
   RowBox[{"Reverse", "@", " ", 
    RowBox[{"Import", "[", 
     RowBox[{"\"\<image.tiff\>\"", ",", "\"\<GrayLevels\>\""}], "]"}]}], " ", 
   "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->532852930],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztvQu0X2V57htExbJREAGpQKBaSwAxaIEdNLsLKXILpYBsbsZDhKI0bIqU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   "]]]], "Output",
 CellLabel->"Out[3]=",
 CellID->4067335]
}, Open  ]],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " of the gray-level values shows the \"negative\" image:"
}], "ExampleText",
 CellID->1576954929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Import", "[", 
   RowBox[{"\"\<image.tiff\>\"", ",", "\"\<GrayLevels\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->535877239],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnQu0X2V55gOOgHIZCgVTiSCVqVwGpCNYlCEHphCoFyyEEqSQTrlXAUER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   "], {{0, 0}, {360, 188}}, {0, 0.9999999999999999}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[4]=",
 CellID->2089824002]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TIFF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 23.2797942}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: image/tiff TIFF raster image format. Commonly used \
in image manipulation applications, page layout applications, scanners and \
other imaging devices, and for the archiving of images. Suitable for \
high-color-depth images. TIFF is an acronym for Tagged Image File Format. \
Binary format. Supports multiple color resolutions, color encodings, and \
compression methods. Supports arbitrary bit depths of up to 16 bits per \
channel, and also 32 bits per channel. Can store multiple images. Supports \
alpha channels. Introduced in the 1980s by Aldus as a standard format for \
desktop scanners.", "synonyms" -> {}, "title" -> "TIFF", "type" -> "Format", 
    "uri" -> "ref/format/TIFF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[29095, 964, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 231518, 4403}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2928, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3551, 93, 110, 4, 70, "ObjectNameAlt",
 CellID->19281],
Cell[3664, 99, 714, 12, 70, "FormatUsage",
 CellID->7085],
Cell[4381, 113, 335, 12, 70, "FormatNotes",
 CellID->9152]
}, Open  ]],
Cell[CellGroupData[{
Cell[4753, 130, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4820, 133, 314, 9, 70, "FormatNotes",
 CellID->28652],
Cell[5137, 144, 373, 13, 70, "FormatNotes",
 CellID->8194],
Cell[5513, 159, 567, 19, 70, "FormatNotes",
 CellID->9876],
Cell[6083, 180, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[6125, 183, 747, 26, 70, "FormatNotes",
 CellID->28396],
Cell[6875, 211, 465, 17, 70, "FormatNotes",
 CellID->7572],
Cell[7343, 230, 120, 3, 70, "FormatNotes",
 CellID->6249],
Cell[7466, 235, 223, 7, 70, "FormatNotes",
 CellID->925313720],
Cell[7692, 244, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[7734, 247, 353, 13, 70, "FormatNotes",
 CellID->29174],
Cell[8090, 262, 575, 20, 70, "FormatNotes",
 CellID->18819],
Cell[8668, 284, 581, 21, 70, "FormatNotes",
 CellID->943],
Cell[9252, 307, 705, 25, 70, "FormatNotes",
 CellID->32611],
Cell[9960, 334, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[10001, 337, 531, 20, 70, "FormatNotes",
 CellID->20289],
Cell[10535, 359, 1076, 40, 70, "FormatNotes",
 CellID->8419],
Cell[11614, 401, 662, 22, 70, "FormatNotes",
 CellID->5565],
Cell[12279, 425, 816, 28, 70, "FormatNotes",
 CellID->3805],
Cell[13098, 455, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[13139, 458, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[13503, 474, 353, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[13893, 493, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[13965, 496, 251, 9, 70, "FormatNotes",
 CellID->2609],
Cell[14219, 507, 164, 6, 70, "FormatNotes",
 CellID->11064]
}, Closed]],
Cell[CellGroupData[{
Cell[14420, 518, 50, 1, 70, "ElementsSection",
 CellID->9166],
Cell[14473, 521, 192, 8, 70, "FormatNotes",
 CellID->16893],
Cell[14668, 531, 707, 14, 70, "2ColumnTableMod",
 CellID->16074],
Cell[15378, 547, 68, 1, 70, "FormatNotes",
 CellID->30300],
Cell[15449, 550, 795, 15, 70, "2ColumnTableMod",
 CellID->19695],
Cell[16247, 567, 360, 11, 70, "FormatNotes",
 CellID->9573],
Cell[16610, 580, 286, 9, 70, "FormatNotes",
 CellID->15589],
Cell[16899, 591, 385, 13, 70, "FormatNotes",
 CellID->13161],
Cell[17287, 606, 279, 9, 70, "FormatNotes",
 CellID->31172],
Cell[17569, 617, 193, 8, 70, "FormatNotes",
 CellID->19426],
Cell[17765, 627, 916, 17, 70, "2ColumnTableMod",
 CellID->28510],
Cell[18684, 646, 72, 1, 70, "FormatNotes",
 CellID->980792937],
Cell[18759, 649, 1016, 23, 70, "2ColumnTableMod",
 CellID->102417787],
Cell[19778, 674, 168, 4, 70, "FormatNotes",
 CellID->1201344862],
Cell[19949, 680, 61, 1, 70, "FormatNotes",
 CellID->361846540],
Cell[20013, 683, 1401, 30, 70, "2ColumnTableMod",
 CellID->29975]
}, Open  ]],
Cell[CellGroupData[{
Cell[21451, 718, 49, 1, 70, "OptionsSection",
 CellID->10422],
Cell[21503, 721, 55, 1, 70, "FormatNotes",
 CellID->30774],
Cell[21561, 724, 1381, 36, 70, "3ColumnTableMod",
 CellID->8779],
Cell[22945, 762, 306, 12, 70, "FormatNotes",
 CellID->454840903],
Cell[23254, 776, 475, 12, 70, "3ColumnTableMod",
 CellID->1616757048],
Cell[23732, 790, 208, 8, 70, "FormatNotes",
 CellID->5764],
Cell[23943, 800, 1447, 33, 70, "3ColumnTableMod",
 CellID->874],
Cell[25393, 835, 584, 22, 70, "FormatNotes",
 CellID->24084],
Cell[25980, 859, 164, 5, 70, "FormatNotes",
 CellID->1729922196],
Cell[26147, 866, 899, 19, 70, "2ColumnTableMod",
 CellID->1599644427]
}, Closed]],
Cell[CellGroupData[{
Cell[27083, 890, 53, 1, 70, "TutorialsSection",
 CellID->26122],
Cell[27139, 893, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[27307, 898, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[27514, 906, 50, 1, 70, "SeeAlsoSection",
 CellID->25605],
Cell[27567, 909, 590, 20, 70, "SeeAlso",
 CellID->21251439]
}, Open  ]],
Cell[CellGroupData[{
Cell[28194, 934, 58, 1, 70, "MoreAboutSection",
 CellID->176385089],
Cell[28255, 937, 151, 2, 70, "MoreAbout"],
Cell[28409, 941, 123, 2, 70, "MoreAbout"],
Cell[28535, 945, 134, 2, 70, "MoreAbout"],
Cell[28672, 949, 133, 2, 70, "MoreAbout"],
Cell[28808, 953, 117, 2, 70, "MoreAbout"],
Cell[28928, 957, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29095, 964, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[29211, 970, 59, 1, 70, "ExampleSection",
 CellID->32379179],
Cell[29273, 973, 233, 8, 70, "ExampleText",
 CellID->439993043],
Cell[CellGroupData[{
Cell[29531, 985, 127, 3, 70, "Input",
 CellID->7950],
Cell[29661, 990, 96285, 1583, 70, "Output",
 CellID->690649871]
}, Open  ]],
Cell[125961, 2576, 220, 8, 70, "ExampleText",
 CellID->621926074],
Cell[CellGroupData[{
Cell[126206, 2588, 174, 5, 70, "Input",
 CellID->1465113566],
Cell[126383, 2595, 708, 13, 70, "Output",
 CellID->1116207260]
}, Open  ]],
Cell[127106, 2611, 126, 3, 70, "ExampleDelimiter",
 CellID->1176877080],
Cell[127235, 2616, 236, 8, 70, "ExampleText",
 CellID->1448694690],
Cell[CellGroupData[{
Cell[127496, 2628, 680, 20, 70, "Input",
 CellID->42065144],
Cell[128179, 2650, 38018, 627, 70, "Output",
 CellID->772847416]
}, Open  ]],
Cell[CellGroupData[{
Cell[166234, 3282, 143, 4, 70, "Input",
 CellID->2146804571],
Cell[166380, 3288, 89, 2, 70, "Output",
 CellID->1756223705]
}, Open  ]],
Cell[166484, 3293, 176, 4, 70, "ExampleText",
 CellID->1787706288],
Cell[CellGroupData[{
Cell[166685, 3301, 281, 8, 70, "Input",
 CellID->532852930],
Cell[166969, 3311, 31064, 512, 70, "Output",
 CellID->4067335]
}, Open  ]],
Cell[198048, 3826, 243, 8, 70, "ExampleText",
 CellID->1576954929],
Cell[CellGroupData[{
Cell[198316, 3838, 199, 6, 70, "Input",
 CellID->535877239],
Cell[198518, 3846, 31428, 519, 70, "Output",
 CellID->2089824002]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[229985, 4370, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

