(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49380,       1685]
NotebookOptionsPosition[     41166,       1420]
NotebookOutlinePosition[     42496,       1458]
CellTagsIndexPosition[     42410,       1453]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Basic Formats" :> 
         Documentation`HelpLookup["paclet:guide/BasicFormats"], "Date & Time" :> 
         Documentation`HelpLookup["paclet:guide/DateAndTime"], 
         "Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "List Manipulation" :> 
         Documentation`HelpLookup["paclet:guide/ListManipulation"], 
         "Numerical Data" :> 
         Documentation`HelpLookup["paclet:guide/NumericalData"], 
         "String Manipulation" :> 
         Documentation`HelpLookup["paclet:guide/StringManipulation"], 
         "Tabular & Spreadsheet Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/TabularAndSpreadsheetFormats"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Basic Formats\"\>", 2->"\<\"Date & Time\"\>", 
      3->"\<\"Importing & Exporting\"\>", 4->"\<\"Listing of All Formats\"\>",
       5->"\<\"List Manipulation\"\>", 6->"\<\"Numerical Data\"\>", 
      7->"\<\"String Manipulation\"\>", 
      8->"\<\"Tabular & Spreadsheet Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Table ",
 StyleBox["(.dat)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Generic tabular data.
Stores numerical and textual information, formatted as a table.
Supports user-defined field and record separators, field delimiters, currency \
tokens, and number formats.
Plain text format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the Table format and provide various data conversion and \
formatting options. "
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes common number formats, including C and Fortran \
notations."
}], "FormatNotes",
 CellID->56646289],

Cell["Numbers without decimal points are imported as integers.", "FormatNotes",
 CellID->718923602]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", "]"}]], "InlineFormula"],
 " imports a Table file, returning a list of lists."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a two-dimensional array or a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " to a Table file."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->325446851],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a two-dimensional array of strings and numbers, representing the \
rows and columns stored in the file."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
     StyleBox["array", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "formats ",
 Cell[BoxData[
  StyleBox["array", "TI"]], "InlineFormula"],
 " as rows and columns using the ",
 Cell[BoxData[
  ButtonBox["CForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CForm"]], "InlineFormula"],
 " of each element."
}], "FormatNotes",
 CellID->7572],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically transforms arbitrary expressions to a list of lists when \
exporting to the Table format."
}], "FormatNotes",
 CellID->1052031979],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a Table file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<Table\>\""}], "]"}], " "}]],
   "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Table\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a Table file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).dat\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the Table format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->2075609843],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a Table file."
}], "FormatNotes",
 CellID->1050269433]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "two-dimensional array, representing the rows and columns", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Grid\>\"", Cell[TextData[{
     "table data as a ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " object"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how data is aligned within table columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<UTF8\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->275885706],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1175867229],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->431454156],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<ASCII\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1545207620],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->363422294],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<TextDelimiters\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "string or list of strings used to delimit non-numeric fields", 
     "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->595003190],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " delimits text fields containing the field separator with double-quote \
characters."
}], "FormatNotes",
 CellID->751587654],

Cell[TextData[{
 "With an explicit setting of ",
 Cell[BoxData["\"\<TextDelimiters\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " always uses the specified string tokens to delimit text fields, \
effectively cycling through the list of delimiters."
}], "FormatNotes",
 CellID->1294656327],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<TextDelimiters\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<<\>\"", ",", "\"\<>\>\""}], "}"}]}]], "InlineFormula"],
 " , ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " wraps text fields in angular brackets."
}], "FormatNotes",
 CellID->984576485],

Cell["\<\
Double-quote characters delimiting text fields are not imported by default.\
\>", "FormatNotes",
 CellID->689403646],

Cell["", "WeakDivider",
 CellID->1791006941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->175377388],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CurrencyTokens\>\"", 
    RowBox[{
     StyleBox["{", "MR"], 
     RowBox[{
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "$", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Sterling]",
          TraditionalForm], "\"\<\>"}], ",", 
        StyleBox[" ", "TR"], 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Yen]",
          TraditionalForm], 
         StyleBox["\"\<\>", "MR"]}], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Euro]",
          TraditionalForm], "\"\<\>"}]}], "}"}], ",", 
      StyleBox[" ", "TR"], 
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "c", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Cent]",
          TraditionalForm], "\"\<\>"}], ",", 
        StyleBox[" ", "TR"], 
        StyleBox[
         RowBox[{"\"\<\>", "p", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        StyleBox[
         RowBox[{"\"\<\>", "F", "\"\<\>"}], "MR"]}], 
       StyleBox["}", "MR"]}]}], 
     StyleBox["}", "MR"]}], Cell[
    "currency units to be skipped when importing numerical values", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DateStringFormat\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "date format, given as a ",
     Cell[BoxData[
      ButtonBox["DateString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
     " specification"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FieldSeparators\>\"", 
    RowBox[{"{", 
     RowBox[{"\"\< \>\"", ",", "\"\<\[Backslash]t\>\""}], "}"}], Cell[
    "string tokens taken to separate columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IgnoreEmptyLines\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to ignore empty lines", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineSeparators\>\"", 
    RowBox[{"{", 
     RowBox[{
     "\"\<\[Backslash]r\\n\>\"", ",", "\"\<\[Backslash]n\>\"", ",", 
      "\"\<\\r\>\""}], "}"}], Cell[
    "string tokens taken to separate rows", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Numeric\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to import data fields as numbers if possible  ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NumberPoint\>\"", "\"\<.\>\"", Cell[
    "decimal point string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NumberSigns\>\"", 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<+\>\""}], "}"}], Cell[
    "strings to use for signs of negative and positive numbers", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RepeatedSeparators\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to parse a sequence of field separators as a single separator\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeaderLines\>\"", "0", Cell[
    "number of lines to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1220196432],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " converts table entries formatted as specified by the ",
 Cell[BoxData["\"\<DateStringFormat\>\""], "InlineFormula"],
 " option to a ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " representation of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->1885747166],

Cell[TextData[{
 "Empty lines and lines containing only whitespace characters are converted \
to an empty list by default.",
 " ",
 "With ",
 Cell[BoxData["\"\<IgnoreEmptyLines\>\""], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " will skip empty lines."
}], "FormatNotes",
 CellID->1986350738],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<Numeric\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", numbers will be imported as strings in the form they appear in the file."
}], "FormatNotes",
 CellID->2005072920],

Cell[TextData[{
 "With the default setting for ",
 Cell[BoxData["\"\<LineSeparators\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes all common conventions for the encoding of \
line-separator characters."
}], "FormatNotes",
 CellID->1534753898],

Cell["", "WeakDivider",
 CellID->1520087421],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1643820035],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FieldSeparators\>\"", "\"\< \>\"", 
    Cell["string token used to separate columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TableHeadings\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "headings for table columns and rows", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->306209590],

Cell[TextData[{
 Cell[BoxData["\"\<TableHeadings\>\""], "InlineFormula"],
 " can be set to the following values: "
}], "FormatNotes",
 CellID->5556],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "gives successive integer labels for columns and rows", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"col\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"col\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "list of column labels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox[
      RowBox[{"rhead", ",", "chead"}], "TI"], "}"}], Cell[
    "specifies separate labels for the rows and columns", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " encodes line separator characters using the convention of the computer \
system on which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is being run."
}], "FormatNotes",
 CellID->1182679569]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->62284587],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tabular & Spreadsheet Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TabularAndSpreadsheetFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->800424256],

Cell["Export an array of random numbers as a table:", "ExampleText",
 CellID->1318310677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3"}], "}"}]}], "]"}], ",", "\"\<Table\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1258762240],

Cell[BoxData["\<\"8.122316298634278\\t0.03122778016745187\\t3.556006622483043\
\\n8.010416391697873\\t3.297007625920738\\t0.9574074955837553\\n5.\
371876260812609\\t4.199329442699661\\t2.9926393007913337\\n2.647760055953807\\\
t5.618302570979129\\t4.231926963883545\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1820502160]
}, Open  ]],

Cell[TextData[{
 "Export a table formatted as ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->227180302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<grid.dat\>\"", ",", 
   TagBox[GridBox[{
      {"1", 
       TagBox[
        FormBox[
         RowBox[{"x", "-", "1"}],
         TraditionalForm],
        TraditionalForm,
        Editable->True], "2"},
      {"2", 
       TagBox[
        FormBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}]}],
         TraditionalForm],
        TraditionalForm,
        Editable->True], "3"},
      {"3", 
       TagBox[
        FormBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ")"}]}],
         TraditionalForm],
        TraditionalForm,
        Editable->True], "4"},
      {"4", 
       TagBox[
        FormBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", "1"}], ")"}]}],
         TraditionalForm],
        TraditionalForm,
        Editable->True], "4"},
      {"5", 
       TagBox[
        FormBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "4"], "+", 
            SuperscriptBox["x", "3"], "+", 
            SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ")"}]}],
         TraditionalForm],
        TraditionalForm,
        Editable->True], "4"},
      {"6", 
       TagBox[
        FormBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"x", "+", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "-", "x", "+", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ")"}]}],
         TraditionalForm],
        TraditionalForm,
        Editable->True], "6"},
      {"7", 
       TagBox[
        FormBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["x", "6"], "+", 
            SuperscriptBox["x", "5"], "+", 
            SuperscriptBox["x", "4"], "+", 
            SuperscriptBox["x", "3"], "+", 
            SuperscriptBox["x", "2"], "+", "x", "+", "1"}], ")"}]}],
         TraditionalForm],
        TraditionalForm,
        Editable->True], "4"}
     },
     GridBoxBackground->{"Columns" -> {
         GrayLevel[1], None, 
         GrayLevel[1]}, "Rows" -> {{
          GrayLevel[0.85], 
          RGBColor[0.88, 1, 0.88]}}},
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
    "Grid"]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->933818265],

Cell[BoxData["\<\"grid.dat\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->873087579]
}, Open  ]],

Cell["Import the generated file:", "ExampleText",
 CellID->933675480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "\<\"+\"\>", ",", "\<\"x\"\>", ",", "2"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2", ",", "\<\"(-1\"\>", ",", "\<\"+\"\>", ",", "\<\"x)*(1\"\>", 
     ",", "\<\"+\"\>", ",", "\<\"x)\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "3", ",", "\<\"(-1\"\>", ",", "\<\"+\"\>", ",", "\<\"x)*(1\"\>", 
     ",", "\<\"+\"\>", ",", "\<\"x\"\>", ",", "\<\"+\"\>", 
     ",", "\<\"x^2)\"\>", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4", ",", "\<\"(-1\"\>", ",", "\<\"+\"\>", ",", "\<\"x)*(1\"\>", 
     ",", "\<\"+\"\>", ",", "\<\"x)*(1\"\>", ",", "\<\"+\"\>", 
     ",", "\<\"x^2)\"\>", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "5", ",", "\<\"(-1\"\>", ",", "\<\"+\"\>", ",", "\<\"x)*(1\"\>", 
     ",", "\<\"+\"\>", ",", "\<\"x\"\>", ",", "\<\"+\"\>", ",", "\<\"x^2\"\>",
      ",", "\<\"+\"\>", ",", "\<\"x^3\"\>", ",", "\<\"+\"\>", 
     ",", "\<\"x^4)\"\>", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6", ",", "\<\"(-1\"\>", ",", "\<\"+\"\>", ",", "\<\"x)*(1\"\>", 
     ",", "\<\"+\"\>", ",", "\<\"x)*(1\"\>", ",", "\<\"-\"\>", 
     ",", "\<\"x\"\>", ",", "\<\"+\"\>", ",", "\<\"x^2)*(1\"\>", 
     ",", "\<\"+\"\>", ",", "\<\"x\"\>", ",", "\<\"+\"\>", 
     ",", "\<\"x^2)\"\>", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "7", ",", "\<\"(-1\"\>", ",", "\<\"+\"\>", ",", "\<\"x)*(1\"\>", 
     ",", "\<\"+\"\>", ",", "\<\"x\"\>", ",", "\<\"+\"\>", ",", "\<\"x^2\"\>",
      ",", "\<\"+\"\>", ",", "\<\"x^3\"\>", ",", "\<\"+\"\>", 
     ",", "\<\"x^4\"\>", ",", "\<\"+\"\>", ",", "\<\"x^5\"\>", 
     ",", "\<\"+\"\>", ",", "\<\"x^6)\"\>", ",", "4"}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1421915383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1920381211],

Cell["\<\
Import a tabular data file that uses vertical bars as field separators:\
\>", "ExampleText",
 CellID->1315282514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/buildings.dat\>\"", ",", 
    RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", "\"\< | \>\""}]}], "]"}], 
  " ", "//", " ", "Grid"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1904034227],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Rank\"\>", "\<\"Name\"\>", "\<\"City\"\>", "\<\"Country\"\>", \
"\<\"Year\"\>", "\<\"Stories\"\>", "\<\"Height\"\>"},
    {"1", "\<\"Taipei 101\"\>", "\<\"Taipei\"\>", "\<\"Taiwan\"\>", "2004", 
     "101", "508"},
    {"2", "\<\"Petronas Tower 1\"\>", "\<\"Kuala Lumpur\"\>", "\<\"Malaysia\"\
\>", "1998", "88", "452"},
    {"3", "\<\"Petronas Tower 2\"\>", "\<\"Kuala Lumpur\"\>", "\<\"Malaysia\"\
\>", "1998", "88", "452"},
    {"4", "\<\"Sears Tower\"\>", "\<\"Chicago\"\>", "\<\"United States\"\>", 
     "1974", "110", "442"},
    {"5", "\<\"Jin Mao Building\"\>", "\<\"Shanghai\"\>", "\<\"China\"\>", 
     "1999", "88", "421"},
    {"6", "\<\"Two International Finance Centre\"\>", "\<\"Hong Kong\"\>", \
"\<\"China\"\>", "2003", "88", "415"},
    {"7", "\<\"CITIC Plaza\"\>", "\<\"Guangzhou\"\>", "\<\"China\"\>", "1996",
      "80", "391"},
    {"8", "\<\"Shun Hing Square\"\>", "\<\"Shenzhen\"\>", "\<\"China\"\>", 
     "1996", "69", "384"},
    {"9", "\<\"Empire State Building\"\>", "\<\"New York\"\>", "\<\"United \
States\"\>", "1931", "102", "381"},
    {"10", "\<\"Central Plaza\"\>", "\<\"Hong Kong\"\>", "\<\"China\"\>", 
     "1992", "78", "374"},
    {"11", "\<\"Bank of China\"\>", "\<\"Hong Kong\"\>", "\<\"China\"\>", 
     "1989", "70", "367"},
    {"12", "\<\"Emirates Tower One\"\>", "\<\"Dubai\"\>", "\<\"United Arab \
Emirates\"\>", "1999", "54", "355"},
    {"13", "\<\"Tuntex Sky Tower\"\>", "\<\"Kaohsiung\"\>", "\<\"Taiwan\"\>", 
     "1997", "85", "348"},
    {"14", "\<\"Aon Centre\"\>", "\<\"Chicago\"\>", "\<\"United States\"\>", 
     "1973", "80", "346"},
    {"15", "\<\"The Center\"\>", "\<\"Hong Kong\"\>", "\<\"China\"\>", "1998",
      "73", "346"},
    {"16", "\<\"John Hancock Center\"\>", "\<\"Chicago\"\>", "\<\"United \
States\"\>", "1969", "100", "344"},
    {"17", "\<\"Shimao International Plaza\"\>", "\<\"Shanghai\"\>", \
"\<\"China\"\>", "2005", "60", "333"},
    {"18", "\<\"Minsheng Bank Building\"\>", "\<\"Wuhan\"\>", "\<\"China\"\>",
      "2006", "68", "331"},
    {"19", "\<\"Ryugyong Hotel\"\>", "\<\"Pyongyang\"\>", "\<\"North \
Korea\"\>", "1995", "105", "330"},
    {"20", "\<\"Q1\"\>", "\<\"Gold Coast\"\>", "\<\"Australia\"\>", "2005", 
     "78", "323"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 CellLabel->"Out[1]=",
 CellID->78597009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2140894995],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " converts dates to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specification if the date format is specified:"
}], "ExampleText",
 CellID->620783731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{
  "\"\<01/19/00 \\n 05/18/02 \\n 12/14/04\>\"", ",", "\"\<Table\>\"", ",", 
   " ", 
   RowBox[{"\"\<DateStringFormat\>\"", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Month\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\"", ",", "\"\</\>\"", 
      ",", "\"\<YearShort\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->871592606],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2000", ",", "1", ",", "19"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2002", ",", "5", ",", "18"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"2004", ",", "12", ",", "14"}], "}"}], "}"}]}], "}"}]], "Output",\

 CellLabel->"Out[1]=",
 CellID->162542686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1563665617],

Cell["\<\
Create a UTF-8 encoded text file that contains currency tokens:\
\>", "ExampleText",
 CellID->1770636580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\<exchangerate.txt\>\"", ",", 
   "\"\<$1.00  \[Yen]116.65  \[Euro]0.7509\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1515742191],

Cell[BoxData["\<\"exchangerate.txt\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->11779093]
}, Open  ]],

Cell["\<\
When importing this file, currency tokens are automatically skipped:\
\>", "ExampleText",
 CellID->1119293659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<exchangerate.txt\>\"", ",", "\"\<Table\>\"", ",", 
   RowBox[{"\"\<CharacterEncoding\>\"", " ", "\[Rule]", "\"\<UTF8\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->428243934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"1.`", ",", "116.65`", ",", "0.7509`"}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->402720527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1268605302],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically converts expressions to a list of lists when exporting to \
the Table format:"
}], "ExampleText",
 CellID->1231663298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", " ", 
   "\"\<Table\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->970176053],

Cell[BoxData["\<\"1\\n1\\t2\\t3\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1183288969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", "\"\<Table\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1839130763],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1538602470]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Table - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 16.5921230}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Generic tabular data. Stores numerical and textual information, \
formatted as a table. Supports user-defined field and record separators, \
field delimiters, currency tokens, and number formats. Plain text format.", 
    "synonyms" -> {}, "title" -> "Table", "type" -> "Format", "uri" -> 
    "ref/format/Table"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[28117, 979, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42276, 1446}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1592, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2215, 59, 109, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2327, 65, 262, 7, 70, "FormatUsage",
 CellID->37585799],
Cell[2592, 74, 392, 13, 70, "FormatNotes",
 CellID->344331575],
Cell[2987, 89, 257, 8, 70, "FormatNotes",
 CellID->56646289],
Cell[3247, 99, 99, 1, 70, "FormatNotes",
 CellID->718923602]
}, Open  ]],
Cell[CellGroupData[{
Cell[3383, 105, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3450, 108, 295, 9, 70, "FormatNotes",
 CellID->28652],
Cell[3748, 119, 464, 16, 70, "FormatNotes",
 CellID->8194],
Cell[4215, 137, 43, 1, 70, "WeakDivider",
 CellID->325446851],
Cell[4261, 140, 379, 11, 70, "FormatNotes",
 CellID->28396],
Cell[4643, 153, 558, 20, 70, "FormatNotes",
 CellID->7572],
Cell[5204, 175, 212, 6, 70, "FormatNotes",
 CellID->1052031979],
Cell[5419, 183, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[5461, 186, 343, 11, 70, "FormatNotes",
 CellID->29174],
Cell[5807, 199, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[6384, 221, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[6967, 244, 707, 25, 70, "FormatNotes",
 CellID->32611],
Cell[7677, 271, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[7718, 274, 521, 18, 70, "FormatNotes",
 CellID->20289],
Cell[8242, 294, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[9320, 336, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[9984, 360, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[10802, 390, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[10843, 393, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[11207, 409, 344, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[11588, 426, 75, 1, 70, "NotebookInterfaceSection",
 CellID->2075609843],
Cell[11666, 429, 160, 4, 70, "FormatNotes",
 CellID->1050269433]
}, Closed]],
Cell[CellGroupData[{
Cell[11863, 438, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[11922, 441, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[12121, 451, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[12796, 466, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[12840, 469, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[12915, 472, 664, 18, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[13582, 492, 382, 14, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[14001, 511, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[14057, 514, 195, 8, 70, "FormatNotes",
 CellID->577662107],
Cell[14255, 524, 775, 20, 70, "3ColumnTableMod",
 CellID->275885706],
Cell[15033, 546, 693, 28, 70, "FormatNotes",
 CellID->1175867229],
Cell[15729, 576, 194, 8, 70, "FormatNotes",
 CellID->431454156],
Cell[15926, 586, 482, 12, 70, "3ColumnTableMod",
 CellID->1545207620],
Cell[16411, 600, 306, 12, 70, "FormatNotes",
 CellID->363422294],
Cell[16720, 614, 501, 13, 70, "3ColumnTableMod",
 CellID->595003190],
Cell[17224, 629, 274, 9, 70, "FormatNotes",
 CellID->751587654],
Cell[17501, 640, 391, 11, 70, "FormatNotes",
 CellID->1294656327],
Cell[17895, 653, 388, 13, 70, "FormatNotes",
 CellID->984576485],
Cell[18286, 668, 126, 3, 70, "FormatNotes",
 CellID->689403646],
Cell[18415, 673, 44, 1, 70, "WeakDivider",
 CellID->1791006941],
Cell[18462, 676, 182, 7, 70, "FormatNotes",
 CellID->175377388],
Cell[18647, 685, 3841, 102, 70, "3ColumnTableMod",
 CellID->1220196432],
Cell[22491, 789, 717, 24, 70, "FormatNotes",
 CellID->1885747166],
Cell[23211, 815, 514, 18, 70, "FormatNotes",
 CellID->1986350738],
Cell[23728, 835, 307, 9, 70, "FormatNotes",
 CellID->2005072920],
Cell[24038, 846, 371, 11, 70, "FormatNotes",
 CellID->1534753898],
Cell[24412, 859, 44, 1, 70, "WeakDivider",
 CellID->1520087421],
Cell[24459, 862, 183, 7, 70, "FormatNotes",
 CellID->1643820035],
Cell[24645, 871, 613, 14, 70, "3ColumnTableMod",
 CellID->306209590],
Cell[25261, 887, 148, 4, 70, "FormatNotes",
 CellID->5556],
Cell[25412, 893, 1195, 30, 70, "2ColumnTableMod",
 CellID->1993],
Cell[26610, 925, 332, 11, 70, "FormatNotes",
 CellID->1182679569]
}, Closed]],
Cell[CellGroupData[{
Cell[26979, 941, 57, 1, 70, "MoreAboutSection",
 CellID->62284587],
Cell[27039, 944, 117, 2, 70, "MoreAbout"],
Cell[27159, 948, 114, 2, 70, "MoreAbout"],
Cell[27276, 952, 134, 2, 70, "MoreAbout"],
Cell[27413, 956, 133, 2, 70, "MoreAbout"],
Cell[27549, 960, 125, 2, 70, "MoreAbout"],
Cell[27677, 964, 119, 2, 70, "MoreAbout"],
Cell[27799, 968, 129, 2, 70, "MoreAbout"],
Cell[27931, 972, 149, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28117, 979, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[28233, 985, 60, 1, 70, "ExampleSection",
 CellID->800424256],
Cell[28296, 988, 89, 1, 70, "ExampleText",
 CellID->1318310677],
Cell[CellGroupData[{
Cell[28410, 993, 264, 9, 70, "Input",
 CellID->1258762240],
Cell[28677, 1004, 326, 5, 70, "Output",
 CellID->1820502160]
}, Open  ]],
Cell[29018, 1012, 203, 8, 70, "ExampleText",
 CellID->227180302],
Cell[CellGroupData[{
Cell[29246, 1024, 3041, 104, 70, "Input",
 CellID->933818265],
Cell[32290, 1130, 86, 2, 70, "Output",
 CellID->873087579]
}, Open  ]],
Cell[32391, 1135, 69, 1, 70, "ExampleText",
 CellID->933675480],
Cell[CellGroupData[{
Cell[32485, 1140, 102, 3, 70, "Input",
 CellID->976592890],
Cell[32590, 1145, 1833, 43, 70, "Output",
 CellID->1421915383]
}, Open  ]],
Cell[34438, 1191, 126, 3, 70, "ExampleDelimiter",
 CellID->1920381211],
Cell[34567, 1196, 123, 3, 70, "ExampleText",
 CellID->1315282514],
Cell[CellGroupData[{
Cell[34715, 1203, 262, 7, 70, "Input",
 CellID->1904034227],
Cell[34980, 1212, 2456, 50, 70, "Output",
 CellID->78597009]
}, Open  ]],
Cell[37451, 1265, 126, 3, 70, "ExampleDelimiter",
 CellID->2140894995],
Cell[37580, 1270, 420, 15, 70, "ExampleText",
 CellID->620783731],
Cell[CellGroupData[{
Cell[38025, 1289, 417, 11, 70, "Input",
 CellID->871592606],
Cell[38445, 1302, 396, 14, 70, "Output",
 CellID->162542686]
}, Open  ]],
Cell[38856, 1319, 126, 3, 70, "ExampleDelimiter",
 CellID->1563665617],
Cell[38985, 1324, 115, 3, 70, "ExampleText",
 CellID->1770636580],
Cell[CellGroupData[{
Cell[39125, 1331, 197, 6, 70, "Input",
 CellID->1515742191],
Cell[39325, 1339, 93, 2, 70, "Output",
 CellID->11779093]
}, Open  ]],
Cell[39433, 1344, 120, 3, 70, "ExampleText",
 CellID->1119293659],
Cell[CellGroupData[{
Cell[39578, 1351, 243, 6, 70, "Input",
 CellID->428243934],
Cell[39824, 1359, 164, 5, 70, "Output",
 CellID->402720527]
}, Open  ]],
Cell[40003, 1367, 126, 3, 70, "ExampleDelimiter",
 CellID->1268605302],
Cell[40132, 1372, 200, 6, 70, "ExampleText",
 CellID->1231663298],
Cell[CellGroupData[{
Cell[40357, 1382, 264, 9, 70, "Input",
 CellID->970176053],
Cell[40624, 1393, 92, 2, 70, "Output",
 CellID->1183288969]
}, Open  ]],
Cell[CellGroupData[{
Cell[40753, 1400, 144, 4, 70, "Input",
 CellID->1839130763],
Cell[40900, 1406, 200, 7, 70, "Output",
 CellID->1538602470]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[41139, 1418, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

