(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35653,       1213]
NotebookOptionsPosition[     29064,       1000]
NotebookOutlinePosition[     30400,       1038]
CellTagsIndexPosition[     30314,       1033]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], 
          "CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/CharacterEncoding"], 
          "FromCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/FromCharacterCode"], 
          "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"], "String" :> 
          Documentation`HelpLookup["paclet:ref/String"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$CharacterEncoding\"\>", 
       2->"\<\"CharacterEncoding\"\>", 3->"\<\"FromCharacterCode\"\>", 
       4->"\<\"ToCharacterCode\"\>", 5->"\<\"String\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Formats" :> 
          Documentation`HelpLookup["paclet:guide/BasicFormats"], 
          "Document Formats" :> 
          Documentation`HelpLookup["paclet:guide/DocumentFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Basic Formats\"\>", 
       2->"\<\"Document Formats\"\>", 3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 5->"\<\"List Manipulation\"\>", 
       6->"\<\"Processing Textual Data\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Text ",
 StyleBox["(.txt)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Plain text file.
Universal format for storage and exchange of textual information.
Represents text as a sequence of characters and line separators.
Stores characters as ASCII, 8-bit Western character codes, or Unicode.
\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support a variety of Western character encodings and the Unicode \
standard."
}], "FormatNotes",
 CellID->344331575],

Cell["\<\
UTF (Unicode Transformation Format) and UCS (Universal Character Set) mapping \
methods are supported.\
\>", "FormatNotes",
 CellID->1664093321],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can display a wide range of character sets, including Western and Asian \
scripts, mathematical symbols, and other special characters."
}], "FormatNotes",
 CellID->1736911166]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", "]"}]], "InlineFormula"],
 " imports a text file as a string."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports any expression to a text file."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a string."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a text file from the ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " representation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->7572],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a text file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<Text\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Text\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a text file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support text formats."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->2075609843],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a plain text file."
}], "FormatNotes",
 CellID->1050269433]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "tabular representation of the text", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Lines\>\"", Cell[
    "lines, given as a list of strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Plaintext\>\"", Cell[TextData[{
     "text file represented as a single ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " string"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<String\>\"", Cell[
    "raw byte string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Words\>\"", Cell[
    "words separated by spaces, given as a list of strings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Plaintext\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->768017255],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", "]"}], " "}]], "InlineFormula"],
 "reads a text file, taking the character encoding to be ",
 Cell[BoxData["\"\<UTF8\>\""], "InlineFormula"],
 " by default."
}], "FormatNotes",
 CellID->1776349723],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", "\"\<Data\>\""}], "]"}]], 
  "InlineFormula"],
 " attempts to read any text file as TSV, CSV or Table, returning an array of \
strings and numbers."
}], "FormatNotes",
 CellID->393343899],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Import",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Import"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<Text\>\"", ",", "\"\<String\>\""}]}]}]}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).txt\>\"", ",", "\"\<String\>\""}], "]"}], " "}]],
   "InlineFormula"],
 "imports a raw sequence of bytes and returns them as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " character string."
}], "FormatNotes",
 CellID->1142774916],

Cell["Specifying and selecting subelements of text files:", "FormatNotes",
 CellID->1689286315],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Lines\>\"", ",", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " line of the file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Words\>\"", ",", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " word in the file"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->2101282865],

Cell[TextData[{
 "When importing from a text file, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically replaces any character sequence commonly used as a line \
separator with",
 " ",
 "\"",
 Cell[BoxData["\\n"], "InlineFormula"],
 "\"."
}], "FormatNotes",
 CellID->1636638294],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " typically uses character code 10 (",
 Cell[BoxData["\"\<\\n\>\""], "InlineFormula"],
 ") as a line separator in the internal representation of text."
}], "FormatNotes",
 CellID->2009256482],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " uses the line separator convention of the computer system on which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is being run."
}], "FormatNotes",
 CellID->1737965680]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<UTF8\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->257920091],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 " include:"
}], "FormatNotes",
 CellID->980295923],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AdobeStandard\>\"", Cell[
    "Adobe standard PostScript font encoding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ASCII\>\"", Cell[
    "full ASCII, with control characters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EUC\>\"", Cell[
    "extended Unix code for Japanese ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatin1\>\"", Cell[
    "ISO 8859\[Hyphen]1 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatin2\>\"", Cell[
    "ISO 8859\[Hyphen]2 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatin3\>\"", Cell[
    "ISO 8859\[Hyphen]3 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatin4\>\"", Cell[
    "ISO 8859\[Hyphen]4 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatinCyrillic\>\"", Cell[
    "ISO 8859\[Hyphen]5 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MacintoshRoman\>\"", Cell[
    "Macintosh roman font encoding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PrintableASCII\>\"", Cell[
    "printable ASCII ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShiftJIS\>\"", Cell["\<\
Shift\[Hyphen]JIS encoding of JIS X 0208\[Hyphen]1990 and extensions \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Symbol\>\"", Cell[
    "symbol font encoding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Unicode\>\"", Cell[
    "raw 2-byte Unicode values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UTF8\>\"", Cell[
    "variable-width 1-byte Unicode format ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UTF16\>\"", Cell["\<\
variable-width 2-byte Unicode format (Basic Multilingual Plane)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WindowsANSI\>\"", Cell[
    "Windows standard font encoding ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True}}}},
 CellID->339038077],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " internally stores characters as Unicode values."
}], "FormatNotes",
 CellID->2090352502],

Cell[TextData[{
 "When importing or exporting text with the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterEncoding"], "->", "\"\<Unicode\>\""}]], 
  "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always assumes the byte ordering given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ByteOrdering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteOrdering"], "->", "1"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1869519841],

Cell[TextData[{
 "A complete list of possible encodings is given by ",
 Cell[BoxData[
  ButtonBox["$CharacterEncodings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->1714233754]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CharacterEncoding"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["FromCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromCharacterCode"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["ToCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/String"]], "InlineFormula"]
}], "SeeAlso",
 CellID->269437084]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->516973735],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Document Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout"],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->187274767],

Cell["Import a text file and return the first few characters:", "ExampleText",
 CellID->639869378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", " ", 
  RowBox[{
   RowBox[{"Import", "[", "\"\<ExampleData/USConstitution.txt\>\"", "]"}], 
   ",", " ", "330"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData["\<\"\\nWe the People of the United States, in Order to form a \
more perfect Union,\\nestablish Justice, insure domestic Tranquility, provide \
for the common\\ndefence, promote the general Welfare, and secure the \
Blessings of Liberty to\\nourselves and our Posterity, do ordain and \
establish this Constitution for the\\nUnited States of America.\\n\\n\"\>"], \
"Output",
 CellLabel->"Out[1]=",
 CellID->219935695]
}, Open  ]],

Cell["Import the first line from this file:", "ExampleText",
 CellID->1834015517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/USConstitution.txt\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Lines\>\"", ",", "1"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->177337645],

Cell[BoxData["\<\"We the People of the United States, in Order to form a more \
perfect Union,\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1864078207]
}, Open  ]],

Cell["Import three lines:", "ExampleText",
 CellID->1466008828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/USConstitution.txt\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Lines\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1130490165],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"We the People of the United States, in Order to form a more \
perfect Union,\"\>", 
   ",", "\<\"establish Justice, insure domestic Tranquility, provide for the \
common\"\>", 
   ",", "\<\"defence, promote the general Welfare, and secure the Blessings \
of Liberty to\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1764593860]
}, Open  ]],

Cell[TextData[{
 "Import this file using the ",
 Cell[BoxData["\"\<Words\>\""], "InlineFormula"],
 " element:"
}], "ExampleText",
 CellID->2032971435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", " ", 
  RowBox[{
   RowBox[{"Import", "[", 
    RowBox[{
    "\"\<ExampleData/USConstitution.txt\>\"", ",", " ", "\"\<Words\>\""}], 
    "]"}], ",", " ", "6"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->779839950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"We\"\>", ",", "\<\"the\"\>", ",", "\<\"People\"\>", 
   ",", "\<\"of\"\>", ",", "\<\"the\"\>", ",", "\<\"United\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->1460951598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1337141611],

Cell["Any plain text file can be imported as text:", "ExampleText",
 CellID->1971687760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/sample.rtf\>\"", ",", " ", "\"\<Text\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1686084275],

Cell[BoxData["\<\"{\\\\rtf1\\\\mac\\\\ansicpg10000\\\\cocoartf824\\\\\
cocoasubrtf420\\n{\\\\fonttbl\\\\f0\\\\froman\\\\fcharset77 Times-Bold;\\\\f1\
\\\\froman\\\\fcharset77 Times-Roman;}\\n{\\\\colortbl;\\\\red255\\\\green255\
\\\\blue255;\\\\red255\\\\green128\\\\blue0;}\\n\\\\margl1440\\\\margr1440\\\\\
vieww9000\\\\viewh8400\\\\viewkind0\\n\\\\deftab720\\n\\\\pard\\\\\
pardeftab720\\\\qj\\n\\n\\\\f0\\\\b\\\\fs36 \\\\cf2 Lorem \
ipsum\\n\\\\f1\\\\b0  dolor sit amet, \\\\\\nconsectetur adipisicing elit, \\\
\\\\nsed do eiusmod tempor incididunt \\\\\\nut labore et dolore magna \
aliqua. \\\\\\n}\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->2007012720]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Text - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 22.5610258}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Plain text file. Universal format for storage and exchange of textual \
information. Represents text as a sequence of characters and line separators. \
Stores characters as ASCII, 8-bit Western character codes, or Unicode. ", 
    "synonyms" -> {}, "title" -> "Text", "type" -> "Format", "uri" -> 
    "ref/format/Text"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24934, 857, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30180, 1026}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2421, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3044, 80, 108, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[3155, 86, 269, 7, 70, "FormatUsage",
 CellID->37585799],
Cell[3427, 95, 375, 13, 70, "FormatNotes",
 CellID->344331575],
Cell[3805, 110, 154, 4, 70, "FormatNotes",
 CellID->1664093321],
Cell[3962, 116, 243, 6, 70, "FormatNotes",
 CellID->1736911166]
}, Open  ]],
Cell[CellGroupData[{
Cell[4242, 127, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4309, 130, 279, 9, 70, "FormatNotes",
 CellID->28652],
Cell[4591, 141, 332, 11, 70, "FormatNotes",
 CellID->8194],
Cell[4926, 154, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4968, 157, 285, 10, 70, "FormatNotes",
 CellID->28396],
Cell[5256, 169, 559, 20, 70, "FormatNotes",
 CellID->7572],
Cell[5818, 191, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[5860, 194, 342, 11, 70, "FormatNotes",
 CellID->29174],
Cell[6205, 207, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[6782, 229, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[7365, 252, 705, 25, 70, "FormatNotes",
 CellID->32611],
Cell[8073, 279, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[8114, 282, 520, 18, 70, "FormatNotes",
 CellID->20289],
Cell[8637, 302, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[9715, 344, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[10379, 368, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[11197, 398, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[11238, 401, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[11602, 417, 340, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[11979, 434, 75, 1, 70, "NotebookInterfaceSection",
 CellID->2075609843],
Cell[12057, 437, 165, 4, 70, "FormatNotes",
 CellID->1050269433]
}, Closed]],
Cell[CellGroupData[{
Cell[12259, 446, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[12318, 449, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[12517, 459, 715, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[13235, 475, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[13279, 478, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[13354, 481, 973, 21, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[14330, 504, 386, 14, 70, "FormatNotes",
 CellID->768017255],
Cell[14719, 520, 394, 12, 70, "FormatNotes",
 CellID->1776349723],
Cell[15116, 534, 386, 12, 70, "FormatNotes",
 CellID->393343899],
Cell[15505, 548, 784, 28, 70, "FormatNotes",
 CellID->1142774916],
Cell[16292, 578, 95, 1, 70, "FormatNotes",
 CellID->1689286315],
Cell[16390, 581, 935, 29, 70, "2ColumnTableMod",
 CellID->2101282865],
Cell[17328, 612, 360, 13, 70, "FormatNotes",
 CellID->1636638294],
Cell[17691, 627, 257, 7, 70, "FormatNotes",
 CellID->2009256482],
Cell[17951, 636, 310, 10, 70, "FormatNotes",
 CellID->1737965680]
}, Open  ]],
Cell[CellGroupData[{
Cell[18298, 651, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[18354, 654, 319, 13, 70, "FormatNotes",
 CellID->577662107],
Cell[18676, 669, 480, 12, 70, "3ColumnTableMod",
 CellID->257920091],
Cell[19159, 683, 231, 8, 70, "FormatNotes",
 CellID->980295923],
Cell[19393, 693, 2506, 49, 70, "2ColumnTableMod",
 CellID->339038077],
Cell[21902, 744, 156, 5, 70, "FormatNotes",
 CellID->2090352502],
Cell[22061, 751, 554, 19, 70, "FormatNotes",
 CellID->1869519841],
Cell[22618, 772, 257, 8, 70, "FormatNotes",
 CellID->1714233754]
}, Closed]],
Cell[CellGroupData[{
Cell[22912, 785, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[22970, 788, 1046, 34, 70, "SeeAlso",
 CellID->269437084]
}, Open  ]],
Cell[CellGroupData[{
Cell[24053, 827, 58, 1, 70, "MoreAboutSection",
 CellID->516973735],
Cell[24114, 830, 117, 2, 70, "MoreAbout"],
Cell[24234, 834, 123, 2, 70, "MoreAbout"],
Cell[24360, 838, 134, 2, 70, "MoreAbout"],
Cell[24497, 842, 133, 2, 70, "MoreAbout"],
Cell[24633, 846, 125, 2, 70, "MoreAbout"],
Cell[24761, 850, 136, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24934, 857, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[25050, 863, 60, 1, 70, "ExampleSection",
 CellID->187274767],
Cell[25113, 866, 98, 1, 70, "ExampleText",
 CellID->639869378],
Cell[CellGroupData[{
Cell[25236, 871, 216, 6, 70, "Input",
 CellID->976592890],
Cell[25455, 879, 432, 7, 70, "Output",
 CellID->219935695]
}, Open  ]],
Cell[25902, 889, 81, 1, 70, "ExampleText",
 CellID->1834015517],
Cell[CellGroupData[{
Cell[26008, 894, 249, 7, 70, "Input",
 CellID->177337645],
Cell[26260, 903, 155, 3, 70, "Output",
 CellID->1864078207]
}, Open  ]],
Cell[26430, 909, 63, 1, 70, "ExampleText",
 CellID->1466008828],
Cell[CellGroupData[{
Cell[26518, 914, 318, 10, 70, "Input",
 CellID->1130490165],
Cell[26839, 926, 382, 9, 70, "Output",
 CellID->1764593860]
}, Open  ]],
Cell[27236, 938, 150, 5, 70, "ExampleText",
 CellID->2032971435],
Cell[CellGroupData[{
Cell[27411, 947, 256, 8, 70, "Input",
 CellID->779839950],
Cell[27670, 957, 228, 6, 70, "Output",
 CellID->1460951598]
}, Open  ]],
Cell[27913, 966, 126, 3, 70, "ExampleDelimiter",
 CellID->1337141611],
Cell[28042, 971, 88, 1, 70, "ExampleText",
 CellID->1971687760],
Cell[CellGroupData[{
Cell[28155, 976, 174, 5, 70, "Input",
 CellID->1686084275],
Cell[28332, 983, 666, 10, 70, "Output",
 CellID->2007012720]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[29037, 998, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

