(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20544,        782]
NotebookOptionsPosition[     14852,        591]
NotebookOutlinePosition[     16233,        630]
CellTagsIndexPosition[     16148,        625]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UnsignedInteger24", "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Sequence of unsigned 24-bit integers.
Raw binary format.
Equivalent to the Byte format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read any file as a sequence of unsigned 24-bit integers."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " writes a list of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", 
     SuperscriptBox["2", "24"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " to a binary file."
}], "FormatNotes",
 CellID->1289702565]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<UnsignedInteger24\>\""}], "]"}]],
   "InlineFormula"],
 " imports any file, returning a packed array of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", 
     SuperscriptBox["2", "24"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", "\"\<UnsignedInteger24\>\""}], "]"}]], 
  "InlineFormula"],
 " exports a list of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", 
     SuperscriptBox["2", "24"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " to ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<UnsignedInteger24\>\"", ",", 
       StyleBox["elem", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["elem", "TI"]}], 
   StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
 " imports the specified element from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<UnsignedInteger24\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the UnsignedInteger24 format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation element:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[TextData[{
     "list of integers in the range ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"0", ",", 
         SuperscriptBox["2", "24"], "-", "1"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->611127238],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->456888197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<UnsignedInteger24\>\"", ",", 
       StyleBox["n", "TI"]}], "}"}]}], "]"}], " "}]], "InlineFormula"],
 "gives the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " 24-bit integer from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->61452522],

Cell["\<\
Trailing bytes are ignored if the size of the imported file is not a multiple \
of the data size.\
\>", "FormatNotes",
 CellID->647021390]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell["General option:", "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    RowBox[{"-", "1"}], Cell["what byte ordering to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2140947909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1838786897],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HeaderBytes\>\"", "0", Cell[
    "how many bytes to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->54213902]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->208130175],

Cell["Export a list of integers to a binary 24-bit representation:", \
"ExampleText",
 CellID->1868376244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i", " ", "=", " ", 
  RowBox[{"ExportString", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", 
      RowBox[{
       RowBox[{"2", "^", "24"}], "-", "1"}]}], "}"}], ",", " ", 
    "\"\<UnsignedInteger24\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1957316528],

Cell[BoxData["\<\"\.00\.00\.00\.01\.00\.00\.02\.00\.00\[YDoubleDot]\
\[YDoubleDot]\[YDoubleDot]\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1840646603]
}, Open  ]],

Cell["\<\
In the previous output, each integer is represented by a sequence of 3 bytes:\
\
\>", "ExampleText",
 CellID->643620463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "i", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->781123047],

Cell[BoxData["12"], "Output",
 CellLabel->"Out[2]=",
 CellID->1245521586]
}, Open  ]],

Cell["Convert the binary data back to a list of integers:", "ExampleText",
 CellID->453991702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"i", ",", "\"\<UnsignedInteger24\>\""}], " ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->835611228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", "16777215"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1958188593]
}, Open  ]],

Cell[TextData[{
 "Numbers outside the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", "0", ",", 
    SuperscriptBox["2", "24"], "-", "1", ")"}], TraditionalForm]], 
  "InlineMath"],
 "  cannot be converted to the UnsignedInteger24 format:"
}], "ExampleText",
 CellID->1096169162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", 
     RowBox[{"2", "^", "24"}]}], "}"}], ",", " ", 
   "\"\<UnsignedInteger24\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1088792276],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinaryWrite", "::", "\<\"nocoerce\"\>"}], ":", 
  " ", "\<\"\\!\\(16777216\\) cannot be coerced to the specified \
format.\"\>"}]], "Message", "MSG",
 CellID->623626645],

Cell[BoxData["$Failed"], "Output",
 CellLabel->"Out[4]=",
 CellID->1572825155]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173325374],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->588775885],

Cell["Export a list of integers to a binary 24-bit representation:", \
"ExampleText",
 CellID->572075586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i", " ", "=", " ", 
  RowBox[{"ExportString", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "2", ",", 
      RowBox[{
       RowBox[{"2", "^", "24"}], "-", "1"}]}], "}"}], ",", " ", 
    "\"\<UnsignedInteger24\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33956017],

Cell[BoxData["\<\"\.00\.00\.00\.01\.00\.00\.02\.00\.00\[YDoubleDot]\
\[YDoubleDot]\[YDoubleDot]\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->762732146]
}, Open  ]],

Cell["\<\
In the previous output, each integer is represented by a sequence of 3 bytes:\
\
\>", "ExampleText",
 CellID->305844790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringLength", "[", "i", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99929244],

Cell[BoxData["12"], "Output",
 CellLabel->"Out[2]=",
 CellID->30911248]
}, Open  ]],

Cell["Convert the binary data back to a list of integers:", "ExampleText",
 CellID->28595149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"i", ",", "\"\<UnsignedInteger24\>\""}], " ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95876708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "2", ",", "16777215"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->22920262]
}, Open  ]],

Cell[TextData[{
 "Numbers outside the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", "0", ",", 
    SuperscriptBox["2", "24"], "-", "1", ")"}], TraditionalForm]], 
  "InlineMath"],
 "  cannot be converted to the UnsignedInteger24 format:"
}], "ExampleText",
 CellID->113000858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2", ",", 
     RowBox[{"2", "^", "24"}]}], "}"}], ",", " ", 
   "\"\<UnsignedInteger24\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->282799387],

Cell[BoxData[
 RowBox[{
  RowBox[{"BinaryWrite", "::", "\<\"nocoerce\"\>"}], ":", 
  " ", "\<\"\\!\\(16777216\\) cannot be coerced to the specified \
format.\"\>"}]], "Message", "MSG",
 CellID->596845684],

Cell[BoxData["$Failed"], "Output",
 CellLabel->"Out[4]=",
 CellID->225896176]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnsignedInteger24 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 24.7798326}", "context" -> "", 
    "keywords" -> {"binary data", "C", "Fortran"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sequence of unsigned 24-bit integers. Raw binary format. Equivalent to \
the Byte format.", "synonyms" -> {}, "title" -> "UnsignedInteger24", "type" -> 
    "Format", "uri" -> "ref/format/UnsignedInteger24"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9787, 375, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1],
  Cell[12320, 483, 99, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->173325374]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15897, 615}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 616, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1239, 42, 63, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[1305, 45, 137, 5, 70, "FormatUsage",
 CellID->37585799],
Cell[1445, 52, 234, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[1682, 61, 391, 14, 70, "FormatNotes",
 CellID->1289702565]
}, Open  ]],
Cell[CellGroupData[{
Cell[2110, 80, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[2177, 83, 522, 18, 70, "FormatNotes",
 CellID->28652],
Cell[2702, 103, 596, 22, 70, "FormatNotes",
 CellID->8194],
Cell[3301, 127, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[3343, 130, 755, 27, 70, "FormatNotes",
 CellID->29174],
Cell[4101, 159, 635, 22, 70, "FormatNotes",
 CellID->943],
Cell[4739, 183, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[4780, 186, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[5144, 202, 356, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[5537, 219, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[5596, 222, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[5795, 232, 692, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[6490, 248, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[6534, 251, 71, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[6608, 254, 557, 16, 70, "2ColumnTableMod",
 CellID->611127238],
Cell[7168, 272, 387, 15, 70, "FormatNotes",
 CellID->456888197],
Cell[7558, 289, 634, 23, 70, "FormatNotes",
 CellID->61452522],
Cell[8195, 314, 148, 4, 70, "FormatNotes",
 CellID->647021390]
}, Open  ]],
Cell[CellGroupData[{
Cell[8380, 323, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[8436, 326, 58, 1, 70, "FormatNotes",
 CellID->577662107],
Cell[8497, 329, 461, 12, 70, "3ColumnTableMod",
 CellID->2140947909],
Cell[8961, 343, 182, 7, 70, "FormatNotes",
 CellID->1838786897],
Cell[9146, 352, 393, 9, 70, "3ColumnTableMod",
 CellID->54213902]
}, Closed]],
Cell[CellGroupData[{
Cell[9576, 366, 38, 0, 70, "MoreAboutSection"],
Cell[9617, 368, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9787, 375, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[9903, 381, 60, 1, 70, "ExampleSection",
 CellID->208130175],
Cell[9966, 384, 106, 2, 70, "ExampleText",
 CellID->1868376244],
Cell[CellGroupData[{
Cell[10097, 390, 332, 10, 70, "Input",
 CellID->1957316528],
Cell[10432, 402, 156, 3, 70, "Output",
 CellID->1840646603]
}, Open  ]],
Cell[10603, 408, 130, 4, 70, "ExampleText",
 CellID->643620463],
Cell[CellGroupData[{
Cell[10758, 416, 108, 3, 70, "Input",
 CellID->781123047],
Cell[10869, 421, 73, 2, 70, "Output",
 CellID->1245521586]
}, Open  ]],
Cell[10957, 426, 94, 1, 70, "ExampleText",
 CellID->453991702],
Cell[CellGroupData[{
Cell[11076, 431, 160, 4, 70, "Input",
 CellID->835611228],
Cell[11239, 437, 144, 4, 70, "Output",
 CellID->1958188593]
}, Open  ]],
Cell[11398, 444, 282, 9, 70, "ExampleText",
 CellID->1096169162],
Cell[CellGroupData[{
Cell[11705, 457, 266, 8, 70, "Input",
 CellID->1088792276],
Cell[11974, 467, 204, 5, 70, "Message",
 CellID->623626645],
Cell[12181, 474, 78, 2, 70, "Output",
 CellID->1572825155]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12320, 483, 99, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173325374],
Cell[CellGroupData[{
Cell[12444, 489, 60, 1, 70, "ExampleSection",
 CellID->588775885],
Cell[12507, 492, 105, 2, 70, "ExampleText",
 CellID->572075586],
Cell[CellGroupData[{
Cell[12637, 498, 330, 10, 70, "Input",
 CellID->33956017],
Cell[12970, 510, 155, 3, 70, "Output",
 CellID->762732146]
}, Open  ]],
Cell[13140, 516, 130, 4, 70, "ExampleText",
 CellID->305844790],
Cell[CellGroupData[{
Cell[13295, 524, 107, 3, 70, "Input",
 CellID->99929244],
Cell[13405, 529, 71, 2, 70, "Output",
 CellID->30911248]
}, Open  ]],
Cell[13491, 534, 93, 1, 70, "ExampleText",
 CellID->28595149],
Cell[CellGroupData[{
Cell[13609, 539, 159, 4, 70, "Input",
 CellID->95876708],
Cell[13771, 545, 142, 4, 70, "Output",
 CellID->22920262]
}, Open  ]],
Cell[13928, 552, 281, 9, 70, "ExampleText",
 CellID->113000858],
Cell[CellGroupData[{
Cell[14234, 565, 265, 8, 70, "Input",
 CellID->282799387],
Cell[14502, 575, 204, 5, 70, "Message",
 CellID->596845684],
Cell[14709, 582, 77, 2, 70, "Output",
 CellID->225896176]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[14825, 589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

