(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22047,        782]
NotebookOptionsPosition[     17605,        639]
NotebookOutlinePosition[     19018,        678]
CellTagsIndexPosition[     18933,        673]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DumpSave" :> Documentation`HelpLookup["paclet:ref/DumpSave"], 
          "\"ExpressionML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ExpressionML"], 
          "\"NB\"" :> Documentation`HelpLookup["paclet:ref/format/NB"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DumpSave\"\>", 
       2->"\<\"\\\"ExpressionML\\\"\"\>", 
       3->"\<\"\\\"NB\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compression and Archive Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/CompressionAndArchiveFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Compression and Archive Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "WDX ",
 StyleBox["(.wdx)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->3676],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " WDX data format.\nUsed by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system for storing and exchanging expressions and data.\nWDX is an acronym \
derived from Wolfram Data Exchange.\nBinary format.\nStores arbitrary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions in a serialized, platform-independent form.\nDeveloped in 2007 \
by Wolfram Research."
}], "FormatUsage",
 CellID->29643],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support the WDX file format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", "]"}]], "InlineFormula"],
 "reads in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " package, evaluating each expression in it, and returning the last one."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a single expression to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " source file."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " source file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<WDX\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<WDX\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1809274264],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " source file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Put",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Put"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).wdx\>\""}], "]"}]], "InlineFormula"],
 " can be used to export multiple expressions."
}], "FormatNotes",
 CellID->104113528],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "WDX",
 " format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation element:", "FormatNotes",
 CellID->192382544],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Expression\>\"", Cell[
    "reads and evaluates the expression stored in the file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Expression\>\""], "InlineFormula"],
 " element for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 "WDX",
 " files."
}], "FormatNotes",
 CellID->13037],

Cell["Meta-information element:", "FormatNotes",
 CellID->1482927732],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CreationID\>\"", Cell[
    "string representing a build number", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2018668289]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->19008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22619]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->195477949],

Cell[TextData[ButtonBox["Compression and Archive Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CompressionAndArchiveFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->20008063],

Cell["\<\
This converts an arbitrary expression to a string in WDX format:\
\>", "ExampleText",
 CellID->888312730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", " ", "=", " ", 
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"NestList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "#"}], "&"}], ",", "x", ",", "6"}], "]"}], ",", " ", 
    "\"\<WDX\>\""}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1907569636],

Cell[BoxData["\<\"WDX1\.06\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.b4\
\[CapitalIHat]\.1ft\.0b\[PlusMinus]\.02\.00(\[Not]Ha\[OHat]y\.970\
\[NonBreakingSpace]\.07\.02\.01x\[AGrave]\.13x\.9c\.0b\[CapitalEGrave]/O-\.8a\
\[RegisteredTrademark]\[CapitalEth]Q\.a8\.88\.05\.00\.19\.1d\.04\.02\[AGrave]\
\.16x\.9c\.0b\[CapitalEGrave]/O-\.8a\[RegisteredTrademark]\[CapitalEth]Q\.08\
\.801*bc\.01U\.02\.07\.8b\[AGrave]\.18x\.9c\.0b\[CapitalEGrave]/O-\.8a\
\[RegisteredTrademark]\[CapitalEth]Q\.08\[CapitalAGrave]`T\[CapitalADoubleDot]\
\[CapitalAE]\[CapitalAE]\.02\.00\.b4(\.0b\.14\[AGrave]\.17x\.9c\.0b\
\[CapitalEGrave]/O-\.8a\[RegisteredTrademark]\[CapitalEth]Q\.08\
\[CapitalAGrave]\[CapitalIAcute]\.a8\.88\.05\.02\.006\.9e\.0e\.9d\[AGrave]\.17\
x\.9c\.0b\[CapitalEGrave]/O-\.8a\[RegisteredTrademark]\[CapitalEth]Q\.08 \
\.82Q\.11\.0b\.02\.00\[CapitalUDoubleDot]F\.12&\[AGrave]\.17x\.9c\.0b\
\[CapitalEGrave]/O-\.8a\[RegisteredTrademark]\[CapitalEth]Q\.08 \.85Q\.11\.0b\
\.06\.00\[Yen]>\.15\.af\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1206025868]
}, Open  ]],

Cell["This converts the WDX string back to an expression:", "ExampleText",
 CellID->1468057693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", "str", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->542755409],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "x"], ",", 
   SuperscriptBox["x", 
    SuperscriptBox["x", "x"]], ",", 
   SuperscriptBox["x", 
    SuperscriptBox["x", 
     SuperscriptBox["x", "x"]]], ",", 
   SuperscriptBox["x", 
    SuperscriptBox["x", 
     SuperscriptBox["x", 
      SuperscriptBox["x", "x"]]]], ",", 
   SuperscriptBox["x", 
    SuperscriptBox["x", 
     SuperscriptBox["x", 
      SuperscriptBox["x", 
       SuperscriptBox["x", "x"]]]]], ",", 
   SuperscriptBox["x", 
    SuperscriptBox["x", 
     SuperscriptBox["x", 
      SuperscriptBox["x", 
       SuperscriptBox["x", 
        SuperscriptBox["x", "x"]]]]]]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->715071506]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WDX - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 35.1550982}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mathematica WDX data format. Used by the Mathematica system for storing \
and exchanging expressions and data. WDX is an acronym derived from Wolfram \
Data Exchange. Binary format. Stores arbitrary Mathematica expressions in a \
serialized, platform-independent form. Developed in 2007 by Wolfram \
Research.", "synonyms" -> {}, "title" -> "WDX", "type" -> "Format", "uri" -> 
    "ref/format/WDX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14874, 551, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18799, 666}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1762, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2385, 69, 101, 4, 70, "ObjectNameAlt",
 CellID->3676],
Cell[2489, 75, 488, 13, 70, "FormatUsage",
 CellID->29643],
Cell[2980, 90, 322, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3339, 107, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[3406, 110, 381, 12, 70, "FormatNotes",
 CellID->2520],
Cell[3790, 124, 395, 14, 70, "FormatNotes",
 CellID->12927],
Cell[4188, 140, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[4230, 143, 399, 14, 70, "FormatNotes",
 CellID->22675],
Cell[4632, 159, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[5209, 181, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[5794, 204, 676, 24, 70, "FormatNotes",
 CellID->21001],
Cell[6473, 230, 461, 16, 70, "FormatNotes",
 CellID->1809274264],
Cell[6937, 248, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[6978, 251, 571, 21, 70, "FormatNotes",
 CellID->9310],
Cell[7552, 274, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[8630, 316, 661, 22, 70, "FormatNotes",
 CellID->7590],
Cell[9294, 340, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[10113, 370, 505, 17, 70, "FormatNotes",
 CellID->104113528],
Cell[10621, 389, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[10662, 392, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[11026, 408, 352, 14, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[11415, 427, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[11469, 430, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[11664, 440, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[12335, 455, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[12377, 458, 71, 1, 70, "FormatNotes",
 CellID->192382544],
Cell[12451, 461, 390, 9, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[12844, 472, 338, 14, 70, "FormatNotes",
 CellID->13037],
Cell[13185, 488, 69, 1, 70, "FormatNotes",
 CellID->1482927732],
Cell[13257, 491, 372, 9, 70, "2ColumnTableMod",
 CellID->2018668289]
}, Open  ]],
Cell[CellGroupData[{
Cell[13666, 505, 50, 1, 70, "SeeAlsoSection",
 CellID->19008],
Cell[13719, 508, 596, 20, 70, "SeeAlso",
 CellID->22619]
}, Open  ]],
Cell[CellGroupData[{
Cell[14352, 533, 58, 1, 70, "MoreAboutSection",
 CellID->195477949],
Cell[14413, 536, 151, 2, 70, "MoreAbout"],
Cell[14567, 540, 134, 2, 70, "MoreAbout"],
Cell[14704, 544, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14874, 551, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[14990, 557, 59, 1, 70, "ExampleSection",
 CellID->20008063],
Cell[15052, 560, 115, 3, 70, "ExampleText",
 CellID->888312730],
Cell[CellGroupData[{
Cell[15192, 567, 316, 10, 70, "Input",
 CellID->1907569636],
Cell[15511, 579, 1054, 15, 70, "Output",
 CellID->1206025868]
}, Open  ]],
Cell[16580, 597, 95, 1, 70, "ExampleText",
 CellID->1468057693],
Cell[CellGroupData[{
Cell[16700, 602, 110, 3, 70, "Input",
 CellID->542755409],
Cell[16813, 607, 726, 25, 70, "Output",
 CellID->715071506]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[17578, 637, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

