(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37023,       1269]
NotebookOptionsPosition[     29955,       1043]
NotebookOutlinePosition[     31579,       1085]
CellTagsIndexPosition[     31493,       1080]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"HTML\"" :> Documentation`HelpLookup["paclet:ref/format/HTML"], 
          "\"LaTeX\"" :> Documentation`HelpLookup["paclet:ref/format/LaTeX"], 
          "\"NB\"" :> Documentation`HelpLookup["paclet:ref/format/NB"], 
          "\"TeX\"" :> Documentation`HelpLookup["paclet:ref/format/TeX"], 
          "\"XHTMLMathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTMLMathML"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"HTML\\\"\"\>", 3->"\<\"\\\"LaTeX\\\"\"\>", 
       4->"\<\"\\\"NB\\\"\"\>", 5->"\<\"\\\"TeX\\\"\"\>", 
       6->"\<\"\\\"XHTMLMathML\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Creating Web Pages\"\>", 
       2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 5->"\<\"Web Formats\"\>", 
       6->"\<\"XML Formats\"\>", 
       7->"\<\"XML Import & Export\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "XHTML ",
 StyleBox["(.html, .htm, .xhtml, .xht, .xml)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->19281],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["application/xhtml+xml", "InlineCode"],
 "\nXHTML markup language and file format.\nXML-based reformulation of HTML.\n\
XHTML is an acronym derived from Extensible Hypertext Markup Language.\nPlain \
text XML format.\nDescribes the structure and aspects of the appearance of \
web pages.\nSuccessor of HTML.\nPublished as a W3C recommendation in 2001."
}], "FormatUsage",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports XHTML versions 1.0 and 1.1."
}], "FormatNotes",
 CellID->9152],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " generates documents conforming to XHTML 1.1."
}], "FormatNotes",
 CellID->1564406763]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", "]"}]], "InlineFormula"],
 " gives a plain text representation of an XHTML file."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", "\"\<Data\>\""}], "]"}]], 
  "InlineFormula"],
 " extracts tabular data from XHTML."
}], "FormatNotes",
 CellID->269543858],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " creates an XHTML version of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8194],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " translates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to XHTML, saving the output in the specified directory."
}], "FormatNotes",
 CellID->1111605557],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a string, representing the textual content of the file as formatted \
plain text."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "exports a notebook, a cell, a list of cells, or other notebook elements to \
XHTML."
}], "FormatNotes",
 CellID->7572],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " always creates a complete XHTML document, and not merely a fragment of \
XHTML."
}], "FormatNotes",
 CellID->1180609883],

Cell[TextData[{
 "The output consists of one or more XHTML files and two directories, ",
 StyleBox["HTMLFiles", "InlineCode"],
 " and ",
 StyleBox["HTMLLinks", "InlineCode"],
 "."
}], "FormatNotes",
 CellID->2050276003],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by default converts typeset expressions to GIF images when exporting to \
XHTML. "
}], "FormatNotes",
 CellID->466182659],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can export ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 " expressions, creating HTML image maps if necessary."
}], "FormatNotes",
 CellID->1279277825],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an X",
 "HTML",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<XHTML\>\""}], "]"}], " "}]],
   "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XHTML\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an X",
 "HTML",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the X",
 "HTML",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a web page."
}], "FormatNotes",
 CellID->11064],

Cell[TextData[{
 StyleBox["Save As", "MenuName"],
 " exports an entire notebook as a web page."
}], "FormatNotes",
 CellID->1262458812]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->9166],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->16893],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16074],

Cell["", "WeakDivider",
 CellID->13509],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->30300],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell["\<\
textual and numerical content from HTML table and list elements\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hyperlinks\>\"", Cell[
    "list of strings, representing target URLs of hyperlinks", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Plaintext\>\"", Cell[
    "XHTML document formatted as text", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Source\>\"", Cell[
    "raw XHTML source as a single string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<XMLObject\>\"", Cell[
    "symbolic XML representation of the entire document", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->19695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Plaintext\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->9573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->435924729],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Notebook\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookObject\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Expression\>\"", Cell[TextData[{
     "an arbitrary ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1520200386]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->10422],

Cell[TextData[{
 " Basic ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula",
  ShowStringCharacters->False],
 " options:"
}], "FormatNotes",
 CellID->5764],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ConvertLinkedNotebooks\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to convert linked notebooks to HTML", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CSS\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "what CSS stylesheet to use or link to", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MathOutput\>\"", "\"\<GIF\>\"", Cell[
    "how to represent typeset expressions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Semantics\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to export MathML content elements", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1908888948],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  RowBox[{"\"\<CSS\>\"", " "}]], "InlineFormula"],
 "are:"
}], "FormatNotes",
 CellID->757163963],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "creates a CSS stylesheet from the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " stylesheet"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "does not create a stylesheet file or inline CSS style", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).css\>\"", Cell[
    "uses a stylesheet file", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1814117666],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData["\"\<MathOutput\>\""], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->1262887948],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<GIF\>\"", Cell[
    "converts all typeset expressions to GIF", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MathML\>\"", Cell[
    "converts all typeset expressions to MathML", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DisplayForm\>\"", Cell["\<\
converts all typeset expressions to ASCII approximations of their appearance\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InputForm\>\"", Cell[TextData[{
     "converts all typeset expressions to their ",
     Cell[BoxData[
      ButtonBox["InputForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InputForm"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1776858735],

Cell[TextData[{
 "See the ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 " format page for complete information about supported ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options."
}], "FormatNotes",
 CellID->1342175520]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25605],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LaTeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LaTeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTMLMathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTMLMathML"]], "InlineFormula"]
}], "SeeAlso",
 CellID->162218333]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->176385089],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->672009595],

Cell["Read an XHTML file as plain text:", "ExampleText",
 CellID->790085111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/mersenne.xhtml\>\"", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->789341257],

Cell[BoxData["\<\"Mersenne Primes\\nTable of Mersenne Primes 1 3 2 7 3 31 4 \
127 5 8191 6 131071 7 524287 8 2147483647 9 2305843009213693951 10 \
618970019642690137449562111\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1912357208]
}, Open  ]],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in this file:"
}], "ExampleText",
 CellID->216131011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/mersenne.xhtml\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1119054800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Data\"\>", ",", "\<\"HTMLSource\"\>", 
   ",", "\<\"Hyperlinks\"\>", ",", "\<\"Plaintext\"\>", 
   ",", "\<\"XMLObject\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1747333854]
}, Open  ]],

Cell["Import the tabular content from this file:", "ExampleText",
 CellID->1069071176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/mersenne.xhtml\>\"", ",", "\"\<Data\>\""}], "]"}],
   " ", "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1755176023],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "3"},
    {"2", "7"},
    {"3", "31"},
    {"4", "127"},
    {"5", "8191"},
    {"6", "131071"},
    {"7", "524287"},
    {"8", "2147483647"},
    {"9", "2305843009213693951"},
    {"10", "618970019642690137449562111"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[3]//TableForm=",
 CellID->601211453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1794351246],

Cell["This exports a mathematical expression to HTML:", "ExampleText",
 CellID->379800108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<formula.xhtml\>\"", ",", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42761584],

Cell[BoxData["\<\"formula.xhtml\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->917433311]
}, Open  ]],

Cell[TextData[{
 "Show the names of the files saved into the ",
 StyleBox["HTMLFiles", "InlineCode"],
 " directory:"
}], "ExampleText",
 CellID->1683577700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<HTMLFiles\>\"", ",", " ", "\"\<Directory\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->306780190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Default.css\"\>", ",", "\<\"formula_1.gif\"\>", 
   ",", "\<\"formula.xhtml_1.gif\"\>", ",", "\<\"xhtml-math11-f.dtd\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->369072517]
}, Open  ]],

Cell["Import the rasterized typeset expression:", "ExampleText",
 CellID->1413485298],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<HTMLFiles/formula.xhtml_1.gif\>\"", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->645871028],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAQBWJzIM4BgaQcsoAcWbrcBNMIqAi3trbNRBdUcvIjoM1f
i1MmFU3M1ybGhKCLXCTRRVSycjTBDDtmzgw9RgWs2jJYwlEFgixycjQgzAD+
RF2JLKzazDnkUQVUgX7VT4awXblEkHzubAEEEGY2ZyBvFJImU08zkHIfCM+K
QwpJLjoCCCBMB6Ecc2UkqXQzUAjFGUMkeeJ11LE5MpvPMSedNQ5DXB1EeLNz
p0izaYcxiQrao0rrsQnkGLBJY8ioI3MsFbOzsViJRcYgAZlnpYJdF4aMuwcK
VzYYlz5UmQQDBDtD3F84Cl05Dhk1JHaIUSgOuzBk1LCrIwQMY8nS5uVClrYk
MWPiQSRZVgABAO1Xvco=
   "], {{0, 0}, {55, 21}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJztlklL1VEYhy/RB2ieB/oGLSoKIr9CRdAEBUHrVkVEgx8hy9LIoWWLFmnZ
YJCVJFGBOeR4vYPdUe+ggbZJy/c9/Bb/HoI27Xzg8Cye5Tm879l17sLR8yti
sVjt0lm5dFY5tTV/OubM1GxyHsLq25xHsPpqpw1Wv1VnvIXV1zjvYPW1Tjes
Xn/b6IbV1zvvYfUNTg+s3nDX6IHV7zUaH2D1Lc5HWL3pvvEJVm9uMj7D6jud
Xlj9QavRC6v3fXHg6P30w9H7GYDVBwccWP1OvTEIR+9nCI7ezxCsftwZhtUb
G4xhWP2EMwKrj444sPpmZxRWHxt14Oj7GYPVTzljsPpWZxyOvq84rD4Rd2D1
7c4ErJ6YcGD1M04CVk8mHDj6/pOw+lknCaunkg6svttJweqHnRSsXnfTSMHq
bY+NFKw+O2OkYPUjThpWb28z0rB6f5+RhtW/zxppWP1JuzEJqw/0G5OwepgX
32D1dU4GVt/jZGD1Y04GVu94amRg9b1OFla/6GRh9WcdRhZWH/pqZGH1+Tkj
C6uHeZiD1fc5OVj9kpOD1cM8zcHqP+aNHKy+0cnD6mEe52H1MI/zsPqL50Ye
Vg//mQKsvt8pwOph3hdg9ctOAVYP+6AAqx9wirD6SacIq3e+NIqwetgnRVg9
7JMpWP2KMwWrv+o0pmD1sG+mYfXTzjSsHh83pmH1g04JVr/qlGD1sM9KsPrC
T6MEq4d9V4bVrzllWL2l2SjD6osLRhlW3+FUYPVDTgVWv+5UYPXWFqMCq3e9
Niqw+q9FowKrh31dhdUDVVg97PMqrH7DqcLqb7qMKqwe/gNVWP3f/DeW+3L/
v/03xJeEOQ==
      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{55, 21},
  PlotRange->{{0, 55}, {0, 21}}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1718074504]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XHTML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 39.4364578}", "context" -> "", 
    "keywords" -> {
     "web", "web technology", "web mining", "data mining", "WWW", 
      "world wide web", "w3c", "internet", "HTTP", "hypertext", "hyperlink", 
      "Flash", "XML"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: application/xhtml+xml XHTML markup language and \
file format. XML-based reformulation of HTML. XHTML is an acronym derived \
from Extensible Hypertext Markup Language. Plain text XML format. Describes \
the structure and aspects of the appearance of web pages. Successor of HTML. \
Published as a W3C recommendation in 2001.", "synonyms" -> {}, "title" -> 
    "XHTML", "type" -> "Format", "uri" -> "ref/format/XHTML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24392, 845, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31359, 1073}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2602, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3225, 82, 131, 4, 70, "ObjectNameAlt",
 CellID->19281],
Cell[3359, 88, 439, 8, 70, "FormatUsage",
 CellID->7085],
Cell[3801, 98, 211, 7, 70, "FormatNotes",
 CellID->9152],
Cell[4015, 107, 219, 7, 70, "FormatNotes",
 CellID->1564406763]
}, Open  ]],
Cell[CellGroupData[{
Cell[4271, 119, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4338, 122, 300, 9, 70, "FormatNotes",
 CellID->28652],
Cell[4641, 133, 324, 11, 70, "FormatNotes",
 CellID->269543858],
Cell[4968, 146, 390, 14, 70, "FormatNotes",
 CellID->8194],
Cell[5361, 162, 427, 14, 70, "FormatNotes",
 CellID->1111605557],
Cell[5791, 178, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[5833, 181, 359, 11, 70, "FormatNotes",
 CellID->28396],
Cell[6195, 194, 402, 13, 70, "FormatNotes",
 CellID->7572],
Cell[6600, 209, 254, 8, 70, "FormatNotes",
 CellID->1180609883],
Cell[6857, 219, 219, 7, 70, "FormatNotes",
 CellID->2050276003],
Cell[7079, 228, 189, 6, 70, "FormatNotes",
 CellID->466182659],
Cell[7271, 236, 425, 15, 70, "FormatNotes",
 CellID->1279277825],
Cell[7699, 253, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[7741, 256, 356, 13, 70, "FormatNotes",
 CellID->29174],
Cell[8100, 271, 576, 20, 70, "FormatNotes",
 CellID->18819],
Cell[8679, 293, 582, 21, 70, "FormatNotes",
 CellID->943],
Cell[9264, 316, 707, 25, 70, "FormatNotes",
 CellID->32611],
Cell[9974, 343, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[10015, 346, 534, 20, 70, "FormatNotes",
 CellID->20289],
Cell[10552, 368, 1077, 40, 70, "FormatNotes",
 CellID->8419],
Cell[11632, 410, 663, 22, 70, "FormatNotes",
 CellID->5565],
Cell[12298, 434, 817, 28, 70, "FormatNotes",
 CellID->3805],
Cell[13118, 464, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[13159, 467, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[13523, 483, 354, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[13914, 502, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[13986, 505, 153, 4, 70, "FormatNotes",
 CellID->11064],
Cell[14142, 511, 135, 4, 70, "FormatNotes",
 CellID->1262458812]
}, Closed]],
Cell[CellGroupData[{
Cell[14314, 520, 50, 1, 70, "ElementsSection",
 CellID->9166],
Cell[14367, 523, 192, 8, 70, "FormatNotes",
 CellID->16893],
Cell[14562, 533, 707, 14, 70, "2ColumnTableMod",
 CellID->16074],
Cell[15272, 549, 39, 1, 70, "WeakDivider",
 CellID->13509],
Cell[15314, 552, 179, 7, 70, "FormatNotes",
 CellID->30300],
Cell[15496, 561, 955, 18, 70, "2ColumnTableMod",
 CellID->19695],
Cell[16454, 581, 257, 9, 70, "FormatNotes",
 CellID->9573],
Cell[16714, 592, 183, 7, 70, "FormatNotes",
 CellID->435924729],
Cell[16900, 601, 1008, 29, 70, "2ColumnTableMod",
 CellID->1520200386]
}, Open  ]],
Cell[CellGroupData[{
Cell[17945, 635, 49, 1, 70, "OptionsSection",
 CellID->10422],
Cell[17997, 638, 220, 9, 70, "FormatNotes",
 CellID->5764],
Cell[18220, 649, 1077, 24, 70, "3ColumnTableMod",
 CellID->1908888948],
Cell[19300, 675, 155, 6, 70, "FormatNotes",
 CellID->757163963],
Cell[19458, 683, 903, 24, 70, "2ColumnTableMod",
 CellID->1814117666],
Cell[20364, 709, 160, 5, 70, "FormatNotes",
 CellID->1262887948],
Cell[20527, 716, 981, 21, 70, "2ColumnTableMod",
 CellID->1776858735],
Cell[21511, 739, 506, 18, 70, "FormatNotes",
 CellID->1342175520]
}, Closed]],
Cell[CellGroupData[{
Cell[22054, 762, 50, 1, 70, "SeeAlsoSection",
 CellID->25605],
Cell[22107, 765, 1233, 41, 70, "SeeAlso",
 CellID->162218333]
}, Open  ]],
Cell[CellGroupData[{
Cell[23377, 811, 58, 1, 70, "MoreAboutSection",
 CellID->176385089],
Cell[23438, 814, 126, 2, 70, "MoreAbout"],
Cell[23567, 818, 151, 2, 70, "MoreAbout"],
Cell[23721, 822, 134, 2, 70, "MoreAbout"],
Cell[23858, 826, 133, 2, 70, "MoreAbout"],
Cell[23994, 830, 113, 2, 70, "MoreAbout"],
Cell[24110, 834, 113, 2, 70, "MoreAbout"],
Cell[24226, 838, 129, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24392, 845, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[24508, 851, 60, 1, 70, "ExampleSection",
 CellID->672009595],
Cell[24571, 854, 76, 1, 70, "ExampleText",
 CellID->790085111],
Cell[CellGroupData[{
Cell[24672, 859, 137, 4, 70, "Input",
 CellID->789341257],
Cell[24812, 865, 235, 4, 70, "Output",
 CellID->1912357208]
}, Open  ]],
Cell[25062, 872, 220, 8, 70, "ExampleText",
 CellID->216131011],
Cell[CellGroupData[{
Cell[25307, 884, 177, 5, 70, "Input",
 CellID->1119054800],
Cell[25487, 891, 232, 6, 70, "Output",
 CellID->1747333854]
}, Open  ]],
Cell[25734, 900, 86, 1, 70, "ExampleText",
 CellID->1069071176],
Cell[CellGroupData[{
Cell[25845, 905, 216, 6, 70, "Input",
 CellID->1755176023],
Cell[26064, 913, 770, 26, 70, "Output",
 CellID->601211453]
}, Open  ]],
Cell[26849, 942, 126, 3, 70, "ExampleDelimiter",
 CellID->1794351246],
Cell[26978, 947, 90, 1, 70, "ExampleText",
 CellID->379800108],
Cell[CellGroupData[{
Cell[27093, 952, 253, 8, 70, "Input",
 CellID->42761584],
Cell[27349, 962, 91, 2, 70, "Output",
 CellID->917433311]
}, Open  ]],
Cell[27455, 967, 156, 5, 70, "ExampleText",
 CellID->1683577700],
Cell[CellGroupData[{
Cell[27636, 976, 165, 5, 70, "Input",
 CellID->306780190],
Cell[27804, 983, 232, 6, 70, "Output",
 CellID->369072517]
}, Open  ]],
Cell[28051, 992, 85, 1, 70, "ExampleText",
 CellID->1413485298],
Cell[CellGroupData[{
Cell[28161, 997, 141, 4, 70, "Input",
 CellID->645871028],
Cell[28305, 1003, 1584, 33, 70, "Output",
 CellID->1718074504]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[29928, 1041, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

