(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32326,       1122]
NotebookOptionsPosition[     26131,        922]
NotebookOutlinePosition[     27637,        963]
CellTagsIndexPosition[     27552,        958]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"HTML\"" :> Documentation`HelpLookup["paclet:ref/format/HTML"], 
          "\"LaTeX\"" :> Documentation`HelpLookup["paclet:ref/format/LaTeX"], 
          "\"NB\"" :> Documentation`HelpLookup["paclet:ref/format/NB"], 
          "\"TeX\"" :> Documentation`HelpLookup["paclet:ref/format/TeX"], 
          "\"XHTML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"GIF\\\"\"\>", 
       2->"\<\"\\\"HTML\\\"\"\>", 3->"\<\"\\\"LaTeX\\\"\"\>", 
       4->"\<\"\\\"NB\\\"\"\>", 5->"\<\"\\\"TeX\\\"\"\>", 
       6->"\<\"\\\"XHTML\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Importing & Exporting in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ImportingAndExportingInNotebooks"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"], 
          "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Creating Web Pages\"\>", 
       2->"\<\"Importing & Exporting in Notebooks\"\>", 
       3->"\<\"Listing of All Formats\"\>", 4->"\<\"Web Formats\"\>", 
       5->"\<\"Web Operations\"\>", 
       6->"\<\"XML Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "XHTMLMathML ",
 StyleBox["(.html, .htm, .xhtml, .xht, .xml)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->19281],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["application/xhtml+xml", "InlineCode"],
 "\nXHTML with embedded MathML.\nPlain text XML format.\nDescribes the \
structure and aspects of the appearance of web pages, including typeset \
mathematical formulas."
}], "FormatUsage",
 CellID->7085],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports XHTML versions 1.0 and 1.1."
}], "FormatNotes",
 CellID->9152],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " generates documents conforming to XHTML 1.1 and MathML 2.0."
}], "FormatNotes",
 CellID->1564406763]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", "]"}]], "InlineFormula"],
 " gives a plain text representation of an XHTML+MathML file."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", "\"\<Data\>\""}], "]"}]], 
  "InlineFormula"],
 " extracts tabular data from XHTML+MathML."
}], "FormatNotes",
 CellID->269543858],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " creates an XHTML+MathML version of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8194],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " translates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to XHTML+MathML, saving the output in the specified directory."
}], "FormatNotes",
 CellID->1111605557],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a string, representing the textual content of the file as formatted \
plain text."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
     StyleBox["expr", "TI"], 
     StyleBox[",", "TI"], 
     StyleBox[" ", "TI"], "\"\<XHTMLMathML\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "exports a notebook, a cell, a list of cells, or other notebook elements to \
XHTML, formatting all typeset expressions as MathML."
}], "FormatNotes",
 CellID->7572],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " always creates a complete XHTML+MathML document."
}], "FormatNotes",
 CellID->1180609883],

Cell[TextData[{
 "The output consists of one or more XHTML+MathML files and two directories, \
",
 StyleBox["HTMLFiles", "InlineCode"],
 " and ",
 StyleBox["HTMLLinks", "InlineCode"],
 "."
}], "FormatNotes",
 CellID->2050276003],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " always converts typeset expressions to MathML when exporting to \
XHTML+MathML. "
}], "FormatNotes",
 CellID->466182659],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can export ",
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Hyperlink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hyperlink"]], "InlineFormula"],
 " expressions, creating HTML image maps if necessary."
}], "FormatNotes",
 CellID->1279277825],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an X",
 "HTML+MathML",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<XHTMLMathML\>\""}], "]"}], 
   " "}]], "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XHTMLMathML\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<XHTMLMathML\>\"", ",", 
      StyleBox["elem", "TI"]}], 
     StyleBox["}", "TI"]}]}], "]"}]], "InlineFormula"],
 " creates an X",
 "HTML+MathML",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<XHTMLMathML\>\"", ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    StyleBox["expr", "TI"], ",", "\"\<XHTMLMathML\>\"", ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xhtml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XHTMLMathML\>\"", ",", "\"\<Rules\>\""}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the X",
 "HTML+MathML",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook to XHTML+MathML."
}], "FormatNotes",
 CellID->11064],

Cell[TextData[{
 StyleBox["Save As", "MenuName"],
 " exports an entire notebook to XHTML+MathML."
}], "FormatNotes",
 CellID->1262458812]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->9166],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->16893],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16074],

Cell["", "WeakDivider",
 CellID->13509],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->30300],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell["\<\
textual and numerical content from HTML table and list elements\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hyperlinks\>\"", Cell[
    "list of strings, representing target URLs of hyperlinks", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Plaintext\>\"", Cell[
    "XHTML+MathML document formatted as text", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Source\>\"", Cell[
    "raw XHTML+MathML source as a single string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<XMLObject\>\"", Cell[
    "symbolic XML representation of the entire document", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->19695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData["\"\<Plaintext\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->9573],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->435924729],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Notebook\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["Notebook",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NotebookObject\>\"", Cell[TextData[{
     "a ",
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
     " expression"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Expression\>\"", Cell[TextData[{
     "an arbitrary ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1520200386]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->10422],

Cell[TextData[{
 " Basic ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula",
  ShowStringCharacters->False],
 " options:"
}], "FormatNotes",
 CellID->5764],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ConvertLinkedNotebooks\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to convert linked notebooks to HTML", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Semantics\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to export MathML content elements", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1908888948],

Cell[TextData[{
 "See the ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 " format page for complete information about supported ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options."
}], "FormatNotes",
 CellID->1342175520]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->25605],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LaTeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LaTeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTML"]], "InlineFormula"]
}], "SeeAlso",
 CellID->275080737]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->176385089],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExportingInNotebooks"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->101579890],

Cell["Read an XHTML file as plain text:", "ExampleText",
 CellID->790085111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/mersenne.xhtml\>\"", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->789341257],

Cell[BoxData["\<\"Mersenne Primes\\nTable of Mersenne Primes 1 3 2 7 3 31 4 \
127 5 8191 6 131071 7 524287 8 2147483647 9 2305843009213693951 10 \
618970019642690137449562111\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1912357208]
}, Open  ]],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in this file:"
}], "ExampleText",
 CellID->216131011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/mersenne.xhtml\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1119054800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Data\"\>", ",", "\<\"HTMLSource\"\>", 
   ",", "\<\"Hyperlinks\"\>", ",", "\<\"Plaintext\"\>", 
   ",", "\<\"XMLObject\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1747333854]
}, Open  ]],

Cell["Import the tabular content from this file:", "ExampleText",
 CellID->1069071176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", 
   RowBox[{"\"\<ExampleData/mersenne.xhtml\>\"", ",", "\"\<Data\>\""}], "]"}],
   " ", "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1755176023],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "3"},
    {"2", "7"},
    {"3", "31"},
    {"4", "127"},
    {"5", "8191"},
    {"6", "131071"},
    {"7", "524287"},
    {"8", "2147483647"},
    {"9", "2305843009213693951"},
    {"10", "618970019642690137449562111"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[3]//TableForm=",
 CellID->601211453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1794351246],

Cell["This exports a mathematical expression to HTML:", "ExampleText",
 CellID->379800108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", "\"\<XHTMLMathML\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42761584],

Cell[BoxData["\<\"<?xml version=\\\"1.0\\\" \
encoding=\\\"UTF-8\\\"?>\\n<?xml-stylesheet type=\\\"text/xsl\\\" \
href=\\\"HTMLFiles/pmathml.xsl\\\"?>\\n<!DOCTYPE html PUBLIC \\\"-//W3C//DTD \
XHTML 1.1 plus MathML 2.0//EN\\\"\\n        \
\\\"HTMLFiles/xhtml-math11-f.dtd\\\">\\n\\n<!-- Created by Wolfram \
Mathematica 6.0 -->\\n\\n<html \
xmlns=\\\"http://www.w3.org/1999/xhtml\\\">\\n<head>\\n <title>\\n  \
Untitled\\n </title>\\n <link href=\\\"HTMLFiles/Default.css\\\" \
rel=\\\"stylesheet\\\" type=\\\"text/css\\\"/>\\n</head>\\n\\n<body>\\n\\n<p \
class=\\\"Output\\\">\\n <math xmlns='http://www.w3.org/1998/Math/MathML'>\\n \
<msqrt>\\n  <mrow>\\n   <msup>\\n    <mi>x</mi>\\n    <mn>2</mn>\\n   </msup>\
\\n   <mo>-</mo>\\n   <msup>\\n    <mi>y</mi>\\n    <mn>2</mn>\\n   \
</msup>\\n  </mrow>\\n \
</msqrt>\\n</math>\\n</p>\\n\\n<hr/>\\n\\n<table><tr>\\n<td \
style='font-family: Helvetica; font-size: 10px; width: 100%'>Created by\\n <a \
href=\\\"http://www.wolfram.com/products/mathematica\\\"><span \
style='font-style: italic'>Wolfram Mathematica 6.0</span></a>\\n &nbsp;(17 \
April 2007)</td>\\n<td><img \
src='http://www.w3.org/Icons/valid-xhtml11.gif'\\n alt='Valid XHTML 1.1!' \
height='31' \
width='88'/></td>\\n</tr></table>\\n</body>\\n\\n</html>\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->223146539]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XHTMLMathML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 39.1083244}", "context" -> "", 
    "keywords" -> {
     "web", "web technology", "web mining", "data mining", "WWW", 
      "world wide web", "w3c", "internet", "HTTP", "hypertext", "hyperlink", 
      "Flash", "XML"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: application/xhtml+xml XHTML with embedded MathML. \
Plain text XML format. Describes the structure and aspects of the appearance \
of web pages, including typeset mathematical formulas.", "synonyms" -> {}, 
    "title" -> "XHTMLMathML", "type" -> "Format", "uri" -> 
    "ref/format/XHTMLMathML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21767, 775, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27418, 951}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2433, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3056, 80, 137, 4, 70, "ObjectNameAlt",
 CellID->19281],
Cell[3196, 86, 297, 7, 70, "FormatUsage",
 CellID->7085],
Cell[3496, 95, 211, 7, 70, "FormatNotes",
 CellID->9152],
Cell[3710, 104, 234, 7, 70, "FormatNotes",
 CellID->1564406763]
}, Open  ]],
Cell[CellGroupData[{
Cell[3981, 116, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4048, 119, 307, 9, 70, "FormatNotes",
 CellID->28652],
Cell[4358, 130, 331, 11, 70, "FormatNotes",
 CellID->269543858],
Cell[4692, 143, 397, 14, 70, "FormatNotes",
 CellID->8194],
Cell[5092, 159, 434, 14, 70, "FormatNotes",
 CellID->1111605557],
Cell[5529, 175, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[5571, 178, 359, 11, 70, "FormatNotes",
 CellID->28396],
Cell[5933, 191, 528, 16, 70, "FormatNotes",
 CellID->7572],
Cell[6464, 209, 223, 7, 70, "FormatNotes",
 CellID->1180609883],
Cell[6690, 218, 228, 8, 70, "FormatNotes",
 CellID->2050276003],
Cell[6921, 228, 188, 6, 70, "FormatNotes",
 CellID->466182659],
Cell[7112, 236, 425, 15, 70, "FormatNotes",
 CellID->1279277825],
Cell[7540, 253, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[7582, 256, 363, 13, 70, "FormatNotes",
 CellID->29174],
Cell[7948, 271, 576, 20, 70, "FormatNotes",
 CellID->18819],
Cell[8527, 293, 582, 21, 70, "FormatNotes",
 CellID->943],
Cell[9112, 316, 720, 25, 70, "FormatNotes",
 CellID->32611],
Cell[9835, 343, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[9876, 346, 634, 23, 70, "FormatNotes",
 CellID->20289],
Cell[10513, 371, 1105, 40, 70, "FormatNotes",
 CellID->8419],
Cell[11621, 413, 691, 22, 70, "FormatNotes",
 CellID->5565],
Cell[12315, 437, 886, 30, 70, "FormatNotes",
 CellID->3805],
Cell[13204, 469, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[13245, 472, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[13609, 488, 361, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[14007, 507, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[14079, 510, 155, 4, 70, "FormatNotes",
 CellID->11064],
Cell[14237, 516, 137, 4, 70, "FormatNotes",
 CellID->1262458812]
}, Closed]],
Cell[CellGroupData[{
Cell[14411, 525, 50, 1, 70, "ElementsSection",
 CellID->9166],
Cell[14464, 528, 192, 8, 70, "FormatNotes",
 CellID->16893],
Cell[14659, 538, 707, 14, 70, "2ColumnTableMod",
 CellID->16074],
Cell[15369, 554, 39, 1, 70, "WeakDivider",
 CellID->13509],
Cell[15411, 557, 179, 7, 70, "FormatNotes",
 CellID->30300],
Cell[15593, 566, 969, 18, 70, "2ColumnTableMod",
 CellID->19695],
Cell[16565, 586, 257, 9, 70, "FormatNotes",
 CellID->9573],
Cell[16825, 597, 183, 7, 70, "FormatNotes",
 CellID->435924729],
Cell[17011, 606, 1008, 29, 70, "2ColumnTableMod",
 CellID->1520200386]
}, Open  ]],
Cell[CellGroupData[{
Cell[18056, 640, 49, 1, 70, "OptionsSection",
 CellID->10422],
Cell[18108, 643, 220, 9, 70, "FormatNotes",
 CellID->5764],
Cell[18331, 654, 704, 17, 70, "3ColumnTableMod",
 CellID->1908888948],
Cell[19038, 673, 506, 18, 70, "FormatNotes",
 CellID->1342175520]
}, Closed]],
Cell[CellGroupData[{
Cell[19581, 696, 50, 1, 70, "SeeAlsoSection",
 CellID->25605],
Cell[19634, 699, 1221, 41, 70, "SeeAlso",
 CellID->275080737]
}, Open  ]],
Cell[CellGroupData[{
Cell[20892, 745, 58, 1, 70, "MoreAboutSection",
 CellID->176385089],
Cell[20953, 748, 126, 2, 70, "MoreAbout"],
Cell[21082, 752, 158, 2, 70, "MoreAbout"],
Cell[21243, 756, 133, 2, 70, "MoreAbout"],
Cell[21379, 760, 113, 2, 70, "MoreAbout"],
Cell[21495, 764, 119, 2, 70, "MoreAbout"],
Cell[21617, 768, 113, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21767, 775, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[21883, 781, 60, 1, 70, "ExampleSection",
 CellID->101579890],
Cell[21946, 784, 76, 1, 70, "ExampleText",
 CellID->790085111],
Cell[CellGroupData[{
Cell[22047, 789, 137, 4, 70, "Input",
 CellID->789341257],
Cell[22187, 795, 235, 4, 70, "Output",
 CellID->1912357208]
}, Open  ]],
Cell[22437, 802, 220, 8, 70, "ExampleText",
 CellID->216131011],
Cell[CellGroupData[{
Cell[22682, 814, 177, 5, 70, "Input",
 CellID->1119054800],
Cell[22862, 821, 232, 6, 70, "Output",
 CellID->1747333854]
}, Open  ]],
Cell[23109, 830, 86, 1, 70, "ExampleText",
 CellID->1069071176],
Cell[CellGroupData[{
Cell[23220, 835, 216, 6, 70, "Input",
 CellID->1755176023],
Cell[23439, 843, 770, 26, 70, "Output",
 CellID->601211453]
}, Open  ]],
Cell[24224, 872, 126, 3, 70, "ExampleDelimiter",
 CellID->1794351246],
Cell[24353, 877, 90, 1, 70, "ExampleText",
 CellID->379800108],
Cell[CellGroupData[{
Cell[24468, 882, 260, 9, 70, "Input",
 CellID->42761584],
Cell[24731, 893, 1334, 22, 70, "Output",
 CellID->223146539]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[26104, 920, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

