(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32907,       1175]
NotebookOptionsPosition[     27018,        985]
NotebookOutlinePosition[     28321,       1022]
CellTagsIndexPosition[     28235,       1017]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Basic Formats" :> 
         Documentation`HelpLookup["paclet:guide/BasicFormats"], "Date & Time" :> 
         Documentation`HelpLookup["paclet:guide/DateAndTime"], 
         "Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Importing & Exporting Database Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/ImportingAndExportingDatabaseFormats"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "Numerical Data" :> 
         Documentation`HelpLookup["paclet:guide/NumericalData"], "Statistics" :> 
         Documentation`HelpLookup["paclet:guide/Statistics"], 
         "Tabular & Spreadsheet Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/TabularAndSpreadsheetFormats"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Basic Formats\"\>", 2->"\<\"Date & Time\"\>", 
      3->"\<\"Importing & Exporting\"\>", 
      4->"\<\"Importing & Exporting Database Formats\"\>", 
      5->"\<\"Listing of All Formats\"\>", 6->"\<\"Numerical Data\"\>", 
      7->"\<\"Statistics\"\>", 
      8->"\<\"Tabular & Spreadsheet Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "XLS ",
 StyleBox["(.xls)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->16827],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["application/vnd.ms-excel", "InlineCode"],
 " \nMicrosoft Excel spreadsheet file.\nXLS is an acronym for Excel \
Spreadsheet.\nCommonly used for storage and exchange of spreadsheet data and \
formulas."
}], "FormatUsage",
 CellID->9961],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " supports XLS files created by Excel 95, 97, 2000, XP, and 2003."
}], "FormatNotes",
 CellID->491],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates Excel 2000 files."
}], "FormatNotes",
 CellID->1844293906]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->2995],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", "]"}]], "InlineFormula"],
 " imports all sheets of an XLS file, returning the result as a list of \
arrays."
}], "FormatNotes",
 CellID->11942],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports an array or a list of arrays to XLS."
}], "FormatNotes",
 CellID->4827],

Cell["", "WeakDivider",
 CellID->5436],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", "]"}], " "}]], "InlineFormula"],
 "returns the sheets of an XLS file as an expression of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["1", "TR"]], ",", " ", 
    SubscriptBox[
     StyleBox["s", "TI"], 
     StyleBox["2", "TR"]], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are full arrays containing numerical and textual data, Boolean values, and \
date specifications."
}], "FormatNotes",
 CellID->32391],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates an XLS file from array data."
}], "FormatNotes",
 CellID->14604],

Cell[TextData[{
 "The following expression types are supported by ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ": ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->2145052763],

Cell["", "WeakDivider",
 CellID->3902],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "XLS",
 " file."
}], "FormatNotes",
 CellID->153],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->292],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->12382],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<XLS\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XLS\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->17421],

Cell["", "WeakDivider",
 CellID->18716],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "XLS",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->19718],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->19895],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5447],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->21726],

Cell["", "WeakDivider",
 CellID->14771],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->11538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "XLS",
 " format."
}], "FormatNotes",
 CellID->1869]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->19912],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->25667],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->26299],

Cell["", "WeakDivider",
 CellID->17035],

Cell["Data representation elements:", "FormatNotes",
 CellID->9894],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "list of full arrays, representing all sheets", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Formulas\>\"", Cell[
    "all XLS formulas as text", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->146182287],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->812283704],

Cell[TextData[{
 "XLS data is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by real or integer numbers, strings, Boolean values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ",",
 " ",
 "and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specifications."
}], "FormatNotes",
 CellID->373727629],

Cell[TextData[{
 "XLS error cells are imported as ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->819249840],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "[\"",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 ".xls\",",
 Cell[BoxData[
  RowBox[{"\"\<Formulas\>\"", "]"}]], "InlineFormula"],
 " gives the Excel formulas for each cell in the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", " ", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are arrays corresponding to the sheets of an XLS file."
}], "FormatNotes",
 CellID->498669149],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Importing parts of a data sheet:", "FormatNotes",
 CellID->1203739437],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     RowBox[{
      StyleBox["k", "TI"], Cell["", "TableText"]}]}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet, given as an array"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     StyleBox["k", "TI"], ",", " ", 
     StyleBox["m", "TI"]}], Cell[TextData[{
     "row ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Data\>\"", ",", 
     StyleBox["k", "TI"], ",", " ", 
     StyleBox["m", "TI"], ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "cell ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
     " of the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " sheet"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1453356619],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xls\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Data\>\"", ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 "returns the first sheet as an array."
}], "FormatNotes",
 CellID->2093805552],

Cell["\<\
The following can be used to select or specify individual sheets by name:\
\>", "FormatNotes",
 CellID->28703],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Sheets\>\"", Cell[
    "list of sheet names", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"]}], Cell[TextData[{
     "sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     " as an array"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"], ",", " ", 
     StyleBox["m", "TI"]}], Cell[TextData[{
     "row ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " of sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Sheets\>\"", ",", " ", 
     StyleBox["name", "TI"], ",", " ", 
     StyleBox["m", "TI"], ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "cell ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["n", "TI"]}], "}"}]], "InlineFormula"],
     " in sheet ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->487595630],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " yields spreadsheets as full rectangular arrays. "
}], "FormatNotes",
 CellID->1651196649],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " supports full and ragged arrays."
}], "FormatNotes",
 CellID->1878393209]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    TextData[{
     "how empty cells are represented in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->159661309],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting Database Formats",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ImportingAndExportingDatabaseFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tabular & Spreadsheet Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TabularAndSpreadsheetFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->129590187],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements in a file:"
}], "ExampleText",
 CellID->1617836650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/elements.xls\>\"", ",", " ", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1979676312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Data\"\>", ",", "\<\"Sheets\"\>", ",", "\<\"Formulas\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->458737380]
}, Open  ]],

Cell["Import the first 10 rows of the first sheet:", "ExampleText",
 CellID->1112288712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Take", "[", " ", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{"\"\<ExampleData/elements.xls\>\"", ",", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<Data\>\"", ",", "1"}], "}"}]}], "]"}], ",", " ", "10"}], 
   "]"}], " ", "//", " ", "TableForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1194929201],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"AtomicNumber\"\>", "\<\"Abbreviation\"\>", "\<\"Name\"\>", \
"\<\"AtomicWeight\"\>"},
    {"1.`", "\<\"H\"\>", "\<\"Hydrogen\"\>", "1.0079345703125`"},
    {"2.`", "\<\"He\"\>", "\<\"Helium\"\>", "4.002593994140625`"},
    {"3.`", "\<\"Li\"\>", "\<\"Lithium\"\>", "6.94140625`"},
    {"4.`", "\<\"Be\"\>", "\<\"Beryllium\"\>", "9.012176513671875`"},
    {"5.`", "\<\"B\"\>", "\<\"Boron\"\>", "10.80859375`"},
    {"6.`", "\<\"C\"\>", "\<\"Carbon\"\>", "12.010696411132812`"},
    {"7.`", "\<\"N\"\>", "\<\"Nitrogen\"\>", "14.006698608398438`"},
    {"8.`", "\<\"O\"\>", "\<\"Oxygen\"\>", "15.99609375`"},
    {"9.`", "\<\"F\"\>", "\<\"Fluorine\"\>", "18.998403191566467`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellLabel->"Out[2]//TableForm=",
 CellID->1021957098]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2128139439],

Cell["Export a formatted table to XLS:", "ExampleText",
 CellID->340734375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<mersenne.xls\>\"", ",", 
   TagBox[GridBox[{
      {"1", "3"},
      {"2", "7"},
      {"3", "31"},
      {"4", "127"},
      {"5", "8191"},
      {"6", "131071"},
      {"7", "524287"},
      {"8", "2147483647"},
      {"9", "2305843009213693951"},
      {"10", "618970019642690137449562111"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Function[BoxForm`e$, 
     TableForm[BoxForm`e$]]]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1430865473],

Cell[BoxData["\<\"mersenne.xls\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1034125605]
}, Open  ]],

Cell["Import the first sheet of the generated file:", "ExampleText",
 CellID->1531237723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", "\"\<mersenne.xls\>\"", "]"}], " ", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->963888064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "3.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "7.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", "31.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "127.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.`", ",", "8191.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.`", ",", "131071.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7.`", ",", "524287.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8.`", ",", "2.147483647`*^9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9.`", ",", "2.305843009213694`*^18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10.`", ",", "6.189700196426902`*^26"}], "}"}]}], "}"}]], "Output",\

 CellLabel->"Out[2]=",
 CellID->68384813]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XLS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 39.9520960}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: application/vnd.ms-excel Microsoft Excel \
spreadsheet file. XLS is an acronym for Excel Spreadsheet. Commonly used for \
storage and exchange of spreadsheet data and formulas.", "synonyms" -> {}, 
    "title" -> "XLS", "type" -> "Format", "uri" -> "ref/format/XLS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[22166, 813, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28101, 1010}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1636, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2259, 60, 102, 4, 70, "ObjectNameAlt",
 CellID->16827],
Cell[2364, 66, 289, 7, 70, "FormatUsage",
 CellID->9961],
Cell[2656, 75, 231, 7, 70, "FormatNotes",
 CellID->491],
Cell[2890, 84, 200, 7, 70, "FormatNotes",
 CellID->1844293906]
}, Open  ]],
Cell[CellGroupData[{
Cell[3127, 96, 63, 1, 70, "ImportExportSection",
 CellID->2995],
Cell[3193, 99, 325, 10, 70, "FormatNotes",
 CellID->11942],
Cell[3521, 111, 338, 11, 70, "FormatNotes",
 CellID->4827],
Cell[3862, 124, 38, 1, 70, "WeakDivider",
 CellID->5436],
Cell[3903, 127, 822, 27, 70, "FormatNotes",
 CellID->32391],
Cell[4728, 156, 354, 12, 70, "FormatNotes",
 CellID->14604],
Cell[5085, 170, 1098, 43, 70, "FormatNotes",
 CellID->2145052763],
Cell[6186, 215, 38, 1, 70, "WeakDivider",
 CellID->3902],
Cell[6227, 218, 350, 13, 70, "FormatNotes",
 CellID->153],
Cell[6580, 233, 572, 20, 70, "FormatNotes",
 CellID->292],
Cell[7155, 255, 582, 21, 70, "FormatNotes",
 CellID->12382],
Cell[7740, 278, 703, 25, 70, "FormatNotes",
 CellID->17421],
Cell[8446, 305, 39, 1, 70, "WeakDivider",
 CellID->18716],
Cell[8488, 308, 529, 20, 70, "FormatNotes",
 CellID->19718],
Cell[9020, 330, 1076, 40, 70, "FormatNotes",
 CellID->19895],
Cell[10099, 372, 661, 22, 70, "FormatNotes",
 CellID->5447],
Cell[10763, 396, 816, 28, 70, "FormatNotes",
 CellID->21726],
Cell[11582, 426, 39, 1, 70, "WeakDivider",
 CellID->14771],
Cell[11624, 429, 361, 14, 70, "FormatNotes",
 CellID->11538],
Cell[11988, 445, 351, 14, 70, "FormatNotes",
 CellID->1869]
}, Closed]],
Cell[CellGroupData[{
Cell[12376, 464, 51, 1, 70, "ElementsSection",
 CellID->19912],
Cell[12430, 467, 192, 8, 70, "FormatNotes",
 CellID->25667],
Cell[12625, 477, 668, 13, 70, "2ColumnTableMod",
 CellID->26299],
Cell[13296, 492, 39, 1, 70, "WeakDivider",
 CellID->17035],
Cell[13338, 495, 67, 1, 70, "FormatNotes",
 CellID->9894],
Cell[13408, 498, 496, 11, 70, "2ColumnTableMod",
 CellID->146182287],
Cell[13907, 511, 381, 14, 70, "FormatNotes",
 CellID->812283704],
Cell[14291, 527, 587, 23, 70, "FormatNotes",
 CellID->373727629],
Cell[14881, 552, 213, 8, 70, "FormatNotes",
 CellID->819249840],
Cell[15097, 562, 824, 29, 70, "FormatNotes",
 CellID->498669149],
Cell[15924, 593, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[15966, 596, 76, 1, 70, "FormatNotes",
 CellID->1203739437],
Cell[16045, 599, 1664, 53, 70, "2ColumnTableMod",
 CellID->1453356619],
Cell[17712, 654, 378, 12, 70, "FormatNotes",
 CellID->2093805552],
Cell[18093, 668, 120, 3, 70, "FormatNotes",
 CellID->28703],
Cell[18216, 673, 1457, 43, 70, "2ColumnTableMod",
 CellID->487595630],
Cell[19676, 718, 223, 7, 70, "FormatNotes",
 CellID->1651196649],
Cell[19902, 727, 207, 7, 70, "FormatNotes",
 CellID->1878393209]
}, Open  ]],
Cell[CellGroupData[{
Cell[20146, 739, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[20198, 742, 302, 12, 70, "FormatNotes",
 CellID->31322],
Cell[20503, 756, 460, 13, 70, "3ColumnTableMod",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[21000, 774, 58, 1, 70, "MoreAboutSection",
 CellID->159661309],
Cell[21061, 777, 117, 2, 70, "MoreAbout"],
Cell[21181, 781, 114, 2, 70, "MoreAbout"],
Cell[21298, 785, 134, 2, 70, "MoreAbout"],
Cell[21435, 789, 169, 3, 70, "MoreAbout"],
Cell[21607, 794, 133, 2, 70, "MoreAbout"],
Cell[21743, 798, 119, 2, 70, "MoreAbout"],
Cell[21865, 802, 112, 2, 70, "MoreAbout"],
Cell[21980, 806, 149, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22166, 813, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[22282, 819, 60, 1, 70, "ExampleSection",
 CellID->129590187],
Cell[22345, 822, 208, 8, 70, "ExampleText",
 CellID->1617836650],
Cell[CellGroupData[{
Cell[22578, 834, 180, 5, 70, "Input",
 CellID->1979676312],
Cell[22761, 841, 168, 5, 70, "Output",
 CellID->458737380]
}, Open  ]],
Cell[22944, 849, 88, 1, 70, "ExampleText",
 CellID->1112288712],
Cell[CellGroupData[{
Cell[23057, 854, 345, 10, 70, "Input",
 CellID->1194929201],
Cell[23405, 866, 1225, 27, 70, "Output",
 CellID->1021957098]
}, Open  ]],
Cell[24645, 896, 126, 3, 70, "ExampleDelimiter",
 CellID->2128139439],
Cell[24774, 901, 75, 1, 70, "ExampleText",
 CellID->340734375],
Cell[CellGroupData[{
Cell[24874, 906, 881, 28, 70, "Input",
 CellID->1430865473],
Cell[25758, 936, 91, 2, 70, "Output",
 CellID->1034125605]
}, Open  ]],
Cell[25864, 941, 89, 1, 70, "ExampleText",
 CellID->1531237723],
Cell[CellGroupData[{
Cell[25978, 946, 177, 5, 70, "Input",
 CellID->963888064],
Cell[26158, 953, 794, 25, 70, "Output",
 CellID->68384813]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[26991, 983, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

