(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37487,       1160]
NotebookOptionsPosition[     31755,        976]
NotebookOutlinePosition[     33321,       1018]
CellTagsIndexPosition[     33235,       1013]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"MOL\"" :> Documentation`HelpLookup["paclet:ref/format/MOL"], 
          "\"PDB\"" :> Documentation`HelpLookup["paclet:ref/format/PDB"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"MOL\\\"\"\>", 
       2->"\<\"\\\"PDB\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Scientific & Medical Data Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/ScientificAndMedicalDataFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Geometry & Modeling Formats\"\>",
        2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"New in 6.0: Import & Export Formats\"\>", 
       5->"\<\"Scientific & Medical Data Formats\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "XYZ ",
 StyleBox["(.xyz)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "MIME type: ",
 StyleBox["chemical/x-xyz", "InlineCode"],
 "\nXMOL molecule model files.\nUsed in cheminformatics applications and on \
the web for storing and exchanging 3D molecule models.\nPlain text tabular \
format.\nRepresents a single chemical compound.\nStores atomic coordinates \
and meta-information.\nDoes not store chemical bond information.\nDeveloped \
in 1990 at the Minnesota Supercomputer Center."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the XYZ format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", "]"}]], "InlineFormula"],
 "reads an XYZ molecule model and gives a visual representation of it."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports elements of a molecule model to an ",
 "XYZ file",
 "."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object.  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "XYZ file",
 "."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<XYZ\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XYZ\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "XYZ file",
 " by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "XYZ",
 " format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Graphics element:", "FormatNotes",
 CellID->525384128],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "XYZ file",
     " rendered as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->263380570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Graphics3D\>\""], "InlineFormula"],
 " element by default for the ",
 "XYZ",
 " format."
}], "FormatNotes",
 CellID->13037],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<VertexCoordinates\>\"", Cell[
    "atomic coordinates, typically given in picometers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexTypes\>\"", Cell["\<\
all atoms or groups constituing the molecule, typically given as a list of \
chemical element abbreviations\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xyz\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["vert", "TI"], ",", 
      StyleBox["coord", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"\"\<VertexTypes\>\"", ",", "\"\<VertexCoordinates\>\""}], 
      "}"}], "}"}]}], "]"}]], "InlineFormula"],
 " creates an XYZ model from a specification of atom types and their 3D \
coordinates."
}], "FormatNotes",
 CellID->1210665048]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1911960202],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies the overall size of the graphics to display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["White",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/White"], Cell[
    "specifies what background color to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ViewPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ViewPoint"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "point in space from which the 3D model is to be viewed", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->2123520593],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<ViewPoint\>\"", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically calculates the optimal viewing angle for the imported \
molecule model."
}], "FormatNotes",
 CellID->389608530],

Cell["Selecting a 3D rendering style:", "FormatNotes",
 CellID->2097373960],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Rendering\>\"", 
    "\"\<BallAndStick\>\"", Cell[
    "specifies the visualization method", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333],

Cell["Possible settings for \"Rendering\" are:", "FormatNotes",
 CellID->1728212143],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BallAndStick\>\"", Cell[
    "displays atoms and bonds as a ball and stick model", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Spacefilling\>\"", Cell[
    "atoms shown as overlapping spheres", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Wireframe\>\"", Cell[
    "bonds rendered as lines", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1345161726]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<MOL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MOL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PDB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PDB"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2645]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->329426040],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Scientific & Medical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScientificAndMedicalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->517534330],

Cell["\<\
Import an XYZ example file, rendering it as a ball-and-stick model:\
\>", "ExampleText",
 CellID->1141387271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/caffeine.xyz\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], GraphicsComplex3DBox[CompressedData["
1:eJwlk3k0FAgcx61pY9bx6oV1M60iiskjYw1+rsK4j1xjMqMxGHbMmMS6j+iw
ZaMDI0fLC7GFvET8Ykh6HW96kqJm4+2ytreOrCO01B/fP7/f933fz/uSWDw/
tqyMjIzZpgibMg8kG9frn0CTgZVyH1M6fvfxDNWtwQNSdMcq7pgEw+Nql/aF
kVB8f2I9ZzwjAK3WRy+o3FYDLnGliuMbCFMFO3uvVzhBmltk23kyE41yr08O
F4Sgesu94USJGr7WLy4UnTmGAspCo/WUNTTaBYXdNnEHt50aR+ea7fBvIo1a
pcBGe56xH/MfX2x6dSzJO40O+gYKV/G+OazVz0k8ZW3w5U+dz+kED5AqFNfn
KMZC0KX0oG3VAfCroduIR40rzlhPp0+I+Ehu3zFZRWWgRtH9t+nCBFzk2Ps5
V7Ox/9G6skv2RI/wyWR5vJSLSpqrhneX/cFhF7PvhX0YZBR2cInveLDAj79x
9ZIAkvhaStI93sAv6frx4Y0YyCTPjqW2sjGnaH+EbAMLw8cOE5JlefjN6My4
ngIfHx9oyhfHuMJywyWi/VMBSnTET1UGOXj3B5Fal10ojjMk6geoAqBWxQ2p
anLQSrrQJ1/rj5ox9V06XfGQZ2yZWiVHR4uaNqvlpniUL/Hs6E1jA4F4Vi/S
lI+tivyb5xQ5GGzdNpjEMMWsnHOqlmGJoP1i1+Vks0h4bjhvMN3AAX+hwZXP
KbFQqyJMdVtyhsZt5/pKi+Mg+kO7wpOZYNg/l9Wyj0PBP+lnG4fektHHZs1y
1CUFln753bYVguDUHl2fQ00OkJpr5lEnEsJWzT+SebCFo8mMgaXXbokJh/hA
u0URrWSxoW4+Ka94SIBffGNMnFjzNHKmU6H4k85Z2YBQ6HvlWJRrdBiZ0o6l
BHsaGr4OdF3JhK99bJhYNF8cW2npjyO+w9t837GgJYs4du8CExNpjST+NB3T
m9tZmaN2QBuUsy0PZQEtJJ/ykucFH+OOpjf/HIGKd+pSHio5YfRUpZTlawW1
3L3v4rYHYg/b60r/XxHI1My/cDrECUcs/qX0K8aguMS15oo5E325ZSdFjkSc
Nf1+rkLCRuOp/y4OCNy/5hsHgNYr4wfv15xQ2q0sat0dh3cv6mhlqwRjdnJ4
jzSaDQntHQdtyz1hC1NnmzWeIpBCsJEBmhim7+AUCw2VVqr12t6QFXFet4dr
AZRNwJ3kBBiskDxYzQyH0xX7hIxqPk72ZhfdbItCmt69qm62O7puREg7Fnm4
Vqgg1/uGi78d4gt6tCjwZTcxF7Rvfk68KuGBct8RcYmyO1BVvl0VX+SAI0lW
mSQfh2VPvbYfeXMc1erJ7UU7eMCIbn4xGBWF17L29uan0XFgoyVV0MIFKctF
qe4NE8NKZ2nrJtHIMH1vc9DEADZyxm99+JQIGRPcZ/sDYuARdV6OIEfGqbd9
ewp8kkC9bMZC8owBRpu36173wcIduvEiVwG0OezVsA4+DnaX7YQOerGQt5ip
vHAyErQpHOeYAhL8D7d4HIA=
    "], {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[1, 24.], SphereBox[12, 24.], 
      SphereBox[14, 24.], SphereBox[15, 24.], SphereBox[16, 24.], 
      SphereBox[17, 24.], SphereBox[18, 24.], SphereBox[22, 24.], 
      SphereBox[23, 24.], SphereBox[24, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[3, 34.], SphereBox[5, 34.], 
      SphereBox[6, 34.], SphereBox[7, 34.], SphereBox[10, 34.], 
      SphereBox[13, 34.], SphereBox[19, 34.], SphereBox[20, 34.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[2, 32.], 
      SphereBox[4, 32.], SphereBox[8, 32.], SphereBox[21, 32.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[9, 31.], 
      SphereBox[11, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{1, 25}, 15.], 
      CylinderBox[{38, 15}, 15.], CylinderBox[{39, 14}, 15.], 
      CylinderBox[{12, 40}, 15.], CylinderBox[{41, 18}, 15.], 
      CylinderBox[{42, 16}, 15.], CylinderBox[{43, 17}, 15.], 
      CylinderBox[{44, 23}, 15.], CylinderBox[{45, 22}, 15.], 
      CylinderBox[{46, 24}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{25, 10}, 15.], 
      CylinderBox[{26, 7}, 15.], CylinderBox[{27, 6}, 15.], 
      CylinderBox[{28, 13}, 15.], CylinderBox[{3, 29}, 15.], 
      CylinderBox[{3, 7}, 15.], CylinderBox[{3, 5}, 15.], 
      CylinderBox[{30, 5}, 15.], CylinderBox[{31, 6}, 15.], 
      CylinderBox[{32, 10}, 15.], CylinderBox[{5, 33}, 15.], 
      CylinderBox[{6, 34}, 15.], CylinderBox[{7, 35}, 15.], 
      CylinderBox[{36, 20}, 15.], CylinderBox[{37, 19}, 15.], 
      CylinderBox[{10, 38}, 15.], CylinderBox[{10, 39}, 15.], 
      CylinderBox[{40, 20}, 15.], CylinderBox[{13, 41}, 15.], 
      CylinderBox[{13, 42}, 15.], CylinderBox[{13, 43}, 15.], 
      CylinderBox[{19, 44}, 15.], CylinderBox[{19, 45}, 15.], 
      CylinderBox[{19, 46}, 15.], CylinderBox[{20, 47}, 15.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], CylinderBox[{2, 26}, 15.], 
      CylinderBox[{2, 27}, 15.], CylinderBox[{2, 28}, 15.], 
      CylinderBox[{29, 8}, 15.], CylinderBox[{4, 30}, 15.], 
      CylinderBox[{4, 31}, 15.], CylinderBox[{4, 32}, 15.], 
      CylinderBox[{35, 21}, 15.], CylinderBox[{8, 36}, 15.], 
      CylinderBox[{8, 37}, 15.], CylinderBox[{47, 21}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{33, 11}, 15.], 
      CylinderBox[{34, 9}, 15.]}}]},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-0.9267137882864505, 
   1.4119664272226369`, -2.9277896719190606`}]], "Output",
 CellLabel->"Out[1]=",
 CellID->932075802]
}, Open  ]],

Cell["Show the same molecule as space-filling atoms:", "ExampleText",
 CellID->1461156454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/caffeine.xyz\>\"", ",", " ", 
   RowBox[{
   "\"\<Rendering\>\"", " ", "\[Rule]", " ", "\"\<Spacefilling\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1652282996],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], 
   GraphicsComplex3DBox[{{-338.0413, -112.72367000000001`, 57.33036}, {
    96.68296, -107.37425, -81.98227}, {5.67293, 85.27194999999999, 
    39.23156}, {-137.51742000000002`, -102.12243000000001`, -5.70552}, \
{-126.15018, 25.907130000000002`, 
    52.34135}, {-30.68337, -168.36331, -71.69344}, {113.94234999999999`, 
    18.74122, -27.009}, {56.02627, 208.39094999999998`, 
    82.51589}, {-49.26797, -281.80554, -120.94731999999999`}, {-263.28073, \
-173.03959, -0.60953}, {-223.01337999999998`, 79.88624, 
    108.99730000000001`}, {254.9699, 297.34977, 62.2959}, {
    205.27432000000002`, -173.60887, -149.31279}, {-248.07715, \
-272.69527999999997`, 48.82631}, {-300.89039, -190.25254, -104.98023}, {
    291.76101, -184.81516, -78.57866}, {237.87863, -112.11917, -237.43655}, {
    171.89877, -274.8992, -184.39205}, {-15.1845, 309.70046, 153.48347}, {
    189.34096, 211.81244999999998`, 41.93193}, {228.61252, 
    99.68439000000001, -24.40298}, {-16.87028, 404.36553000000004`, 
    93.01093999999999}, {35.35322, 329.7906, 251.77747}, {-120.74498, 
    275.37592, 172.03047}}, {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[1, 120.], SphereBox[12, 120.], 
      SphereBox[14, 120.], SphereBox[15, 120.], SphereBox[16, 120.], 
      SphereBox[17, 120.], SphereBox[18, 120.], SphereBox[22, 120.], 
      SphereBox[23, 120.], SphereBox[24, 120.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[3, 170.], SphereBox[5, 170.], 
      SphereBox[6, 170.], SphereBox[7, 170.], SphereBox[10, 170.], 
      SphereBox[13, 170.], SphereBox[19, 170.], SphereBox[20, 170.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[2, 160.], 
      SphereBox[4, 160.], SphereBox[8, 160.], SphereBox[21, 160.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[9, 155.], 
      SphereBox[11, 155.]}}]},
  Boxed->False,
  Lighting->"Neutral",
  ViewPoint->{-0.9267137882864505, 
   1.4119664272226369`, -2.9277896719190606`}]], "Output",
 CellLabel->"Out[2]=",
 CellID->132535228]
}, Open  ]],

Cell["Read the atom types and atom coordinates:", "ExampleText",
 CellID->554451922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/caffeine.xyz\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\"\<VertexTypes\>\"", ",", " ", "\"\<VertexCoordinates\>\""}], 
     "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1739788112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"H\"\>", ",", "\<\"N\"\>", ",", "\<\"C\"\>", ",", "\<\"N\"\>",
      ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", ",", "\<\"N\"\>", 
     ",", "\<\"O\"\>", ",", "\<\"C\"\>", ",", "\<\"O\"\>", ",", "\<\"H\"\>", 
     ",", "\<\"C\"\>", ",", "\<\"H\"\>", ",", "\<\"H\"\>", ",", "\<\"H\"\>", 
     ",", "\<\"H\"\>", ",", "\<\"H\"\>", ",", "\<\"C\"\>", ",", "\<\"C\"\>", 
     ",", "\<\"N\"\>", ",", "\<\"H\"\>", ",", "\<\"H\"\>", ",", "\<\"H\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "338.0413`"}], ",", 
       RowBox[{"-", "112.72367000000001`"}], ",", "57.33036`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"96.68296`", ",", 
       RowBox[{"-", "107.37425`"}], ",", 
       RowBox[{"-", "81.98227`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.67293`", ",", "85.27194999999999`", ",", "39.23156`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "137.51742000000002`"}], ",", 
       RowBox[{"-", "102.12243000000001`"}], ",", 
       RowBox[{"-", "5.70552`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "126.15018`"}], ",", "25.907130000000002`", ",", 
       "52.34135`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "30.68337`"}], ",", 
       RowBox[{"-", "168.36331`"}], ",", 
       RowBox[{"-", "71.69344`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"113.94234999999999`", ",", "18.74122`", ",", 
       RowBox[{"-", "27.009`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"56.02627`", ",", "208.39094999999998`", ",", "82.51589`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "49.26797`"}], ",", 
       RowBox[{"-", "281.80554`"}], ",", 
       RowBox[{"-", "120.94731999999999`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "263.28073`"}], ",", 
       RowBox[{"-", "173.03959`"}], ",", 
       RowBox[{"-", "0.60953`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "223.01337999999998`"}], ",", "79.88624`", ",", 
       "108.99730000000001`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"254.9699`", ",", "297.34977`", ",", "62.2959`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"205.27432000000002`", ",", 
       RowBox[{"-", "173.60887`"}], ",", 
       RowBox[{"-", "149.31279`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "248.07715`"}], ",", 
       RowBox[{"-", "272.69527999999997`"}], ",", "48.82631`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "300.89039`"}], ",", 
       RowBox[{"-", "190.25254`"}], ",", 
       RowBox[{"-", "104.98023`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"291.76101`", ",", 
       RowBox[{"-", "184.81516`"}], ",", 
       RowBox[{"-", "78.57866`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"237.87863`", ",", 
       RowBox[{"-", "112.11917`"}], ",", 
       RowBox[{"-", "237.43655`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"171.89877`", ",", 
       RowBox[{"-", "274.8992`"}], ",", 
       RowBox[{"-", "184.39205`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "15.1845`"}], ",", "309.70046`", ",", "153.48347`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"189.34096`", ",", "211.81244999999998`", ",", "41.93193`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"228.61252`", ",", "99.68439000000001`", ",", 
       RowBox[{"-", "24.40298`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "16.87028`"}], ",", "404.36553000000004`", ",", 
       "93.01093999999999`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"35.35322`", ",", "329.7906`", ",", "251.77747`"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "120.74498`"}], ",", "275.37592`", ",", "172.03047`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->618889871]
}, Open  ]],

Cell["Export this data to XYZ:", "ExampleText",
 CellID->741908721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<XYZ\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<VertexTypes\>\"", ",", " ", "\"\<VertexCoordinates\>\""}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->193821528],

Cell[BoxData["\<\"24\\nCreated by Wolfram Mathematica \
6.0\\nH\\t-3.38041\\t-1.12724\\t 5.73304E-1\\nN\\t \
9.66830E-1\\t-1.07374\\t-8.19823E-1\\nC\\t 5.67293E-2\\t 8.52719E-1\\t \
3.92316E-1\\nN\\t-1.37517\\t-1.02122\\t-5.70552E-2\\nC\\t-1.26150\\t \
2.59071E-1\\t 5.23414E-1\\nC\\t-3.06834E-1\\t-1.68363\\t-7.16934E-1\\nC\\t \
1.13942\\t 1.87412E-1\\t-2.70090E-1\\nN\\t 5.60263E-1\\t 2.08391\\t \
8.25159E-1\\nO\\t-4.92680E-1\\t-2.81806\\t-1.20947\\nC\\t-2.63281\\t-1.73040\\\
t-6.09530E-3\\nO\\t-2.23013\\t 7.98862E-1\\t 1.08997\\nH\\t 2.54970\\t \
2.97350\\t 6.22959E-1\\nC\\t \
2.05274\\t-1.73609\\t-1.49313\\nH\\t-2.48077\\t-2.72695\\t \
4.88263E-1\\nH\\t-3.00890\\t-1.90253\\t-1.04980\\nH\\t \
2.91761\\t-1.84815\\t-7.85787E-1\\nH\\t 2.37879\\t-1.12119\\t-2.37437\\nH\\t \
1.71899\\t-2.74899\\t-1.84392\\nC\\t-1.51845E-1\\t 3.09700\\t 1.53483\\nC\\t \
1.89341\\t 2.11812\\t 4.19319E-1\\nN\\t 2.28613\\t \
9.96844E-1\\t-2.44030E-1\\nH\\t-1.68703E-1\\t 4.04366\\t 9.30109E-1\\nH\\t \
3.53532E-1\\t 3.29791\\t 2.51777\\nH\\t-1.20745\\t 2.75376\\t 1.72030\"\>"], \
"Output",
 CellLabel->"Out[4]=",
 CellID->1418759476]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XYZ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 40.8896200}", "context" -> "", 
    "keywords" -> {
     "chemistry", "biology", "biochemistry", "molecule", "compound", 
      "geometry"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: chemical/x-xyz XMOL molecule model files. Used in \
cheminformatics applications and on the web for storing and exchanging 3D \
molecule models. Plain text tabular format. Represents a single chemical \
compound. Stores atomic coordinates and meta-information. Does not store \
chemical bond information. Developed in 1990 at the Minnesota Supercomputer \
Center.", "synonyms" -> {}, "title" -> "XYZ", "type" -> "Format", "uri" -> 
    "ref/format/XYZ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18564, 658, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33101, 1006}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2065, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2688, 75, 101, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[2792, 81, 467, 9, 70, "FormatUsage",
 CellID->20778],
Cell[3262, 92, 323, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3622, 109, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[3689, 112, 313, 9, 70, "FormatNotes",
 CellID->2520],
Cell[4005, 123, 357, 13, 70, "FormatNotes",
 CellID->12927],
Cell[4365, 138, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[4407, 141, 416, 15, 70, "FormatNotes",
 CellID->25134],
Cell[4826, 158, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[4868, 161, 352, 13, 70, "FormatNotes",
 CellID->22675],
Cell[5223, 176, 574, 20, 70, "FormatNotes",
 CellID->13336],
Cell[5800, 198, 582, 21, 70, "FormatNotes",
 CellID->16334],
Cell[6385, 221, 681, 25, 70, "FormatNotes",
 CellID->21001],
Cell[7069, 248, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[7110, 251, 524, 20, 70, "FormatNotes",
 CellID->9310],
Cell[7637, 273, 1075, 40, 70, "FormatNotes",
 CellID->5974],
Cell[8715, 315, 666, 22, 70, "FormatNotes",
 CellID->7590],
Cell[9384, 339, 816, 28, 70, "FormatNotes",
 CellID->20356],
Cell[10203, 369, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[10244, 372, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[10608, 388, 352, 14, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[10997, 407, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[11051, 410, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[11246, 420, 668, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[11917, 435, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[11959, 438, 60, 1, 70, "FormatNotes",
 CellID->525384128],
Cell[12022, 441, 542, 16, 70, "2ColumnTableMod",
 CellID->263380570],
Cell[12567, 459, 288, 11, 70, "FormatNotes",
 CellID->13037],
Cell[12858, 472, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[12929, 475, 603, 13, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[13535, 490, 600, 19, 70, "FormatNotes",
 CellID->1210665048]
}, Open  ]],
Cell[CellGroupData[{
Cell[14172, 514, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[14224, 517, 196, 8, 70, "FormatNotes",
 CellID->1911960202],
Cell[14423, 527, 1173, 31, 70, "3ColumnTableMod",
 CellID->2123520593],
Cell[15599, 560, 394, 13, 70, "FormatNotes",
 CellID->389608530],
Cell[15996, 575, 75, 1, 70, "FormatNotes",
 CellID->2097373960],
Cell[16074, 578, 395, 10, 70, "3ColumnTableMod",
 CellID->30333],
Cell[16472, 590, 84, 1, 70, "FormatNotes",
 CellID->1728212143],
Cell[16559, 593, 646, 13, 70, "2ColumnTableMod",
 CellID->1345161726]
}, Closed]],
Cell[CellGroupData[{
Cell[17242, 611, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[17295, 614, 376, 13, 70, "SeeAlso",
 CellID->2645]
}, Open  ]],
Cell[CellGroupData[{
Cell[17708, 632, 58, 1, 70, "MoreAboutSection",
 CellID->329426040],
Cell[17769, 635, 150, 2, 70, "MoreAbout"],
Cell[17922, 639, 151, 2, 70, "MoreAbout"],
Cell[18076, 643, 133, 2, 70, "MoreAbout"],
Cell[18212, 647, 156, 2, 70, "MoreAbout"],
Cell[18371, 651, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18564, 658, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18680, 664, 60, 1, 70, "ExampleSection",
 CellID->517534330],
Cell[18743, 667, 119, 3, 70, "ExampleText",
 CellID->1141387271],
Cell[CellGroupData[{
Cell[18887, 674, 129, 3, 70, "Input",
 CellID->17199],
Cell[19019, 679, 4214, 74, 70, "Output",
 CellID->932075802]
}, Open  ]],
Cell[23248, 756, 90, 1, 70, "ExampleText",
 CellID->1461156454],
Cell[CellGroupData[{
Cell[23363, 761, 244, 7, 70, "Input",
 CellID->1652282996],
Cell[23610, 770, 2088, 37, 70, "Output",
 CellID->132535228]
}, Open  ]],
Cell[25713, 810, 84, 1, 70, "ExampleText",
 CellID->554451922],
Cell[CellGroupData[{
Cell[25822, 815, 285, 8, 70, "Input",
 CellID->1739788112],
Cell[26110, 825, 4040, 107, 70, "Output",
 CellID->618889871]
}, Open  ]],
Cell[30165, 935, 67, 1, 70, "ExampleText",
 CellID->741908721],
Cell[CellGroupData[{
Cell[30257, 940, 307, 9, 70, "Input",
 CellID->193821528],
Cell[30567, 951, 1122, 18, 70, "Output",
 CellID->1418759476]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[31728, 974, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

