(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     75906,       1644]
NotebookOptionsPosition[     71563,       1502]
NotebookOutlinePosition[     72872,       1539]
CellTagsIndexPosition[     72786,       1534]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"NOFF\"" :> Documentation`HelpLookup["paclet:ref/format/NOFF"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"X3D\"" :> Documentation`HelpLookup["paclet:ref/format/X3D"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"NOFF\\\"\"\>", 7->"\<\"\\\"OBJ\\\"\"\>", 
       8->"\<\"\\\"PLY\\\"\"\>", 9->"\<\"\\\"POV\\\"\"\>", 
       10->"\<\"\\\"RIB\\\"\"\>", 11->"\<\"\\\"STL\\\"\"\>", 
       12->"\<\"\\\"X3D\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ZPR ",
 StyleBox["(.zpr)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
ZPrint CAD format.
Used with Z Corporation 3D printers.
Native format of the ZEdit and ZPrint applications.
Developed by Z Corporation.
Stores a physical 3D model and color information.
Binary format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " supports Version 1 of the ZPR format."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zpr\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a 3D object to a ZPR file."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zpr\>\"", ",", " ", 
     RowBox[{
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "creates a ZPR file representing a solid physical model."
}], "FormatNotes",
 CellID->6249],

Cell["\<\
The actual physical size of the object described in the ZPR file is typically \
determined at print time.\
\>", "FormatNotes",
 CellID->1572705229],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zpr\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "ZPR",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zpr\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zpr\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zpr\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the ",
 "ZPR",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "exports a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object to ZPR"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "exports a ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "the polygon elements in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexColors\>\"", Cell["\<\
colors associated with each vertex, given as a list of color primitives\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->230773093],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->2136836049]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell["Advanced option:", "FormatNotes",
 CellID->2132824898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by the ZPR format the vertical \
axis corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["z", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["y", "TI"]}]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when exporting to ZPR."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NOFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NOFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<X3D\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/X3D"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1314740650]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->70106775],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->301532412],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 " to compute a solid 3D geometry:"
}], "ExampleText",
 CellID->1061340363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", "y", " ", "z"}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "4"}], ",", "5"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", " ", "False"}], ",", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<GreenPinkTones\>\""}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->948308959],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJzNnU2MJddVx8v2S+slekiviycBS5CBLBBkZRQJ6ZZYYcSKBbBgEaGAiETI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   "], {{
     {EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{1112, 1336, 1335}, {846, 723, 714}, {371, 312, 313}, {
         465, 404, 402}, {405, 404, 406}, {722, 723, 724}, {819, 826, 820}, {
         824, 833, 825}, {374, 377, 375}, {405, 345, 343}, {361, 302, 303}, {
         471, 408, 406}, {850, 851, 852}, {846, 847, 848}, {471, 470, 472}, {
         596, 501, 502}, {117, 129, 118}, {949, 890, 889}, {228, 227, 229}, {
         750, 751, 752}, {581, 494, 496}, {712, 713, 714}, {498, 501, 499}, {
         687, 695, 688}, {691, 697, 693}, {702, 703, 704}, {228, 55, 45}, {
         437, 377, 378}, {839, 716, 704}, {117, 1304, 1303}, {836, 837, 
         838}, {900, 901, 902}, {565, 480, 478}, {495, 426, 427}, {572, 485, 
         488}, {361, 364, 362}, {409, 408, 410}, {1112, 1054, 1053}, {1078, 
         1079, 1080}, {1078, 1029, 1021}, {1331, 995, 1332}, {487, 492, 
         488}, {490, 423, 424}, {858, 751, 741}, {910, 911, 912}, {949, 958, 
         950}, {910, 851, 848}, {1326, 669, 1327}, {900, 847, 838}, {477, 476,
          478}, {806, 669, 671}, {557, 474, 472}, {409, 348, 346}, {822, 692, 
         693}, {443, 446, 444}, {475, 412, 410}, {1290, 446, 1291}, {309, 251,
          252}, {535, 470, 467}, {309, 312, 310}}], 
        Polygon3DBox[CompressedData["
1:eJxNmHm0llUVxr/3e9+DyFIExCwTTTFZBAiIgExyCYHwGioydJlkSmQQEly4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         "]], 
        Polygon3DBox[{{446, 1290, 1289, 512, 444}, {254, 313, 312, 309, 
         252}, {305, 365, 364, 361, 303}, {312, 371, 372, 369, 310}, {1020, 
         1081, 1079, 1078, 1021}, {470, 535, 538, 557, 472}, {476, 558, 559, 
         565, 478}, {751, 858, 857, 860, 752}, {317, 378, 377, 374, 315}, {
         837, 903, 901, 900, 838}, {692, 685, 684, 691, 693}, {1292, 1291, 
         446, 443, 382}, {302, 361, 362, 360, 301}, {1054, 1112, 1335, 1334, 
         1333}, {751, 750, 753, 742, 741}, {716, 715, 717, 702, 704}, {723, 
         722, 725, 712, 714}, {669, 1326, 1325, 667, 671}, {851, 910, 912, 
         914, 852}, {669, 806, 807, 1328, 1327}, {703, 841, 840, 839, 704}, {
         697, 829, 831, 822, 693}, {477, 478, 480, 414, 413}, {421, 487, 488, 
         485, 419}, {935, 994, 995, 1331, 1330}, {409, 410, 412, 349, 348}, {
         431, 502, 501, 498, 429}, {1065, 1337, 1336, 1112, 1053}, {228, 229, 
         231, 58, 55}, {225, 227, 228, 45, 35}, {251, 309, 310, 307, 249}, {
         501, 596, 595, 588, 499}, {897, 957, 958, 949, 889}, {890, 949, 950, 
         947, 887}, {492, 579, 576, 572, 488}, {377, 437, 438, 435, 375}, {
         1029, 1078, 1080, 1089, 1030}, {402, 404, 405, 343, 341}, {1304, 117,
          118, 105, 1305}, {1302, 131, 129, 117, 1303}}], 
        Polygon3DBox[{{713, 836, 838, 847, 846, 714}, {426, 495, 496, 494, 
         490, 424}, {847, 900, 902, 911, 910, 848}, {404, 465, 467, 470, 471, 
         406}, {408, 471, 472, 474, 475, 410}, {695, 824, 825, 826, 819, 
         688}, {723, 846, 848, 851, 850, 724}, {345, 405, 406, 408, 409, 
         346}}]}]}, 
     {EdgeForm[None], 
      GraphicsGroup3DBox[{
        Polygon3DBox[{{1131, 1133, 1132}, {104, 106, 116}, {464, 466, 468}, {
         514, 516, 515}, {996, 937, 936}}], Polygon3DBox[CompressedData["
1:eJxNmnncjmXax6/7vu4rWSpSthYekSXTIvPOTPWqVEZliTYzxlBSylgbRXjs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         "]], 
        Polygon3DBox[{{515, 516, 650, 649, 648}, {1164, 1179, 1181, 1180, 
         1165}, {479, 486, 573, 574, 570}, {568, 569, 571, 484, 483}, {937, 
         996, 997, 998, 938}, {447, 448, 517, 516, 514}, {1132, 1133, 1134, 
         1115, 1113}, {564, 570, 699, 698, 690}, {571, 700, 710, 709, 575}, {
         650, 651, 798, 797, 796}, {531, 670, 672, 673, 532}, {106, 107, 120, 
         119, 116}, {466, 533, 536, 534, 468}, {1162, 1163, 1164, 1143, 
         1142}, {400, 463, 466, 464, 401}, {44, 46, 56, 57, 54}, {53, 54, 94, 
         93, 90}}]}]}, {}, {}, {}}, {{
      Line3DBox[{80, 1267, 1268, 1269, 1270, 1271, 1272, 1273, 1274, 1275, 
       1276, 1277, 1278, 1279, 1280, 1281, 1282, 1283, 1284, 1285, 1286, 1287,
        1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 1296, 1297, 1298, 
       1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 1308, 1309, 1311,
        80}], 
      Line3DBox[{659, 1321, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329, 
       1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341,
        1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1353, 
       659}], Line3DBox[{23, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 
       1369, 1370, 1371, 1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379, 1380,
        1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391, 
       1392, 1393, 1395, 23}], 
      Line3DBox[{789, 1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1425, 
       1426, 1427, 1428, 1429, 1430, 1431, 1432, 1433, 1434, 1435, 1436, 1437,
        1438, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 1446, 1447, 1448, 
       1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460,
        1461, 1463, 789}]}, {
      Line3DBox[{1, 1354, 1355, 1356, 1357, 1358, 1359, 1360, 1394, 222, 281, 
       340, 401, 464, 468, 534, 537, 540, 543, 546, 549, 1472, 1473, 1474, 
       1475, 1476, 1477, 1478, 1479, 1480, 1514, 1126, 1124, 1122, 1120, 1118,
        1116, 1114, 1055, 997, 996, 936, 876, 808, 672, 670, 668, 666, 664, 
       661, 662, 525, 456, 393, 332, 273, 214, 5, 1}], 
      Line3DBox[{4, 1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 
       1352, 683, 690, 698, 828, 892, 952, 1011, 1069, 1506, 1154, 1173, 1189,
        1197, 1205, 1213, 1221, 1229, 1237, 1245, 1253, 1105, 1046, 987, 928, 
       868, 791, 641, 639, 631, 623, 615, 607, 599, 591, 584, 577, 573, 486, 
       420, 357, 298, 240, 82, 83, 48, 38, 28, 4}], 
      Line3DBox[{25, 26, 20, 17, 14, 11, 8, 2, 1261, 1262, 1263, 1264, 1265, 
       1266, 1310, 84, 86, 88, 90, 93, 104, 116, 119, 130, 141, 152, 163, 174,
        185, 1464, 1465, 1466, 1467, 1468, 1469, 1471, 210, 212, 194, 183, 
       172, 161, 150, 139, 127, 114, 102, 78, 77, 74, 71, 68, 65, 62, 59, 56, 
       46, 36, 25}], 
      Line3DBox[{76, 1396, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404, 
       1405, 1406, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 1416, 1462,
        779, 769, 759, 748, 739, 730, 720, 709, 710, 844, 908, 968, 1027, 
       1087, 1485, 1172, 1151, 1141, 1129, 1130, 1063, 1005, 945, 885, 817, 
       681, 554, 552, 553, 562, 568, 483, 417, 354, 295, 237, 76}], 
      Line3DBox[{196, 197, 264, 323, 384, 447, 514, 515, 648, 646, 644, 642, 
       638, 1487, 1488, 1489, 1490, 1491, 1492, 1493, 1494, 1495, 1516, 1517, 
       1518, 1519, 1520, 1521, 1260, 1111, 1052, 993, 934, 874, 797, 798, 799,
        800, 801, 802, 803, 804, 805, 658, 524, 455, 392, 331, 272, 213, 1407,
        1470, 208, 206, 204, 202, 200, 198, 196}], 
      Line3DBox[{1113, 1508, 1509, 1510, 1511, 1512, 1513, 1515, 1128, 1481, 
       1482, 1483, 1484, 1486, 1188, 1187, 1186, 1185, 1184, 1183, 1182, 1180,
        1181, 1196, 1204, 1212, 1220, 1228, 1236, 1244, 1252, 1522, 1259, 
       1258, 1257, 1256, 1255, 1254, 1496, 1497, 1498, 1499, 1500, 1501, 1502,
        1503, 1504, 1505, 1507, 1152, 1153, 1156, 1158, 1160, 1162, 1142, 
       1131, 1132, 1113}]}}},
   VertexColors->CompressedData["
1:eJztXWlQVVcSRhAnEkMFEdyCIEZ2HSqIW9CGJ7K6ZEQlLgTLDUUBMyoKWuK4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    "],
   VertexNormals->CompressedData["
1:eJztfXlcTev3vxAyhQyJFA1CkoSMyxQRhVBkCMmsQpmLJIU0T5pVp3mexxWa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    "]],
  BoxRatios->{1, 1, 1},
  Boxed->False,
  Lighting->"Neutral",
  PlotRange->{{-5, 5}, {-2, 5}, {-4, 5}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1038093209]
}, Open  ]],

Cell["Export it to the ZPR format:", "ExampleText",
 CellID->2025524877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<test.zpr\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1085835495],

Cell[BoxData["\<\"test.zpr\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->321132259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->674089440],

Cell["Export inline 3D graphics:", "ExampleText",
 CellID->1444980155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<spikey.zpr\>\"", ",", 
   Graphics3DBox[
    GraphicsComplex3DBox[
     NCache[{{0, 0, Root[5 - 20 #^2 + 16 #^4& , 1, 0]}, {
       0, 0, Root[5 - 20 #^2 + 16 #^4& , 4, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 1, 0], 0, Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 5 #^2 + 5 #^4& , 4, 0], 0, Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[-1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 1, 0], Rational[1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[-1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 40 #^2 + 80 #^4& , 4, 0], Rational[1, 2], Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 2, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 1, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (-1 - 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 20 #^2 + 80 #^4& , 3, 0], 
        Rational[1, 4] (1 + 5^Rational[1, 2]), Root[
        1 - 20 #^2 + 80 #^4& , 4, 0]}, {
       Root[1 - 290 #^2 + 2555 #^4 - 5850 #^6 + 2025 #^8& , 1, 0], 0, Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 290 #^2 + 2555 #^4 - 5850 #^6 + 2025 #^8& , 8, 0], 0, Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 740 #^2 + 3230 #^4 - 4500 #^6 + 2025 #^8& , 1, 0], 0, Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 740 #^2 + 3230 #^4 - 4500 #^6 + 2025 #^8& , 8, 0], 0, Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0], 
        Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0], 
        Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0], 
        Root[1 + 28 # - 20 #^2 - 144 #^3 + 144 #^4& , 4, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0], 
        Root[1 - 28 # - 20 #^2 + 144 #^3 + 144 #^4& , 1, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 44 # - 100 #^2 - 48 #^3 + 144 #^4& , 3, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 44 # - 100 #^2 + 48 #^3 + 144 #^4& , 2, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 1, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 44 # - 100 #^2 - 48 #^3 + 144 #^4& , 3, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 1160 #^2 + 40880 #^4 - 374400 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 44 # - 100 #^2 + 48 #^3 + 144 #^4& , 2, 0], Root[
        1 - 520 #^2 + 40880 #^4 - 835200 #^6 + 518400 #^8& , 8, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 1, 0], Root[
        1 + 16 # - 40 #^2 - 192 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 1, 0], Root[
        1 - 16 # - 40 #^2 + 192 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 6, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 8, 0], Root[
        1 + 16 # - 40 #^2 - 192 #^3 + 144 #^4& , 4, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}, {
       Root[1 - 2960 #^2 + 51680 #^4 - 288000 #^6 + 518400 #^8& , 8, 0], Root[
        1 - 16 # - 40 #^2 + 192 #^3 + 144 #^4& , 1, 0], Root[
        1 - 7720 #^2 + 127280 #^4 - 489600 #^6 + 518400 #^8& , 3, 0]}}, {{
       0, 0, -0.9510565162951532}, {
       0, 0, 0.9510565162951536}, {-0.8506508083520394, 
        0, -0.4253254041760197}, {
       0.85065080835204, 0, 0.42532540417602}, {-0.6881909602355868, -0.5, 
       0.42532540417602}, {-0.6881909602355868, 0.5, 0.42532540417602}, {
       0.6881909602355868, -0.5, -0.4253254041760197}, {0.6881909602355868, 
       0.5, -0.4253254041760197}, {-0.2628655560595671, -0.8090169943749475, \
-0.4253254041760197}, {-0.2628655560595671, 
       0.8090169943749475, -0.4253254041760197}, {
       0.2628655560595668, -0.8090169943749475, 0.42532540417602}, {
       0.2628655560595668, 0.8090169943749475, 
       0.42532540417602}, {-1.5443455162844653`, 0, 0.29494374842358073`}, {
       1.5443455162844653`, 0, -0.29494374842358073`}, {-0.9544580194373125, 
        0, 1.2494017678608846`}, {
       0.954458019437308, 0, -1.2494017678608846`}, {-1.2494017678608846`, 
       0.9077435189160142, -0.29494374842358073`}, {-1.2494017678608846`, \
-0.9077435189160141, -0.29494374842358073`}, {1.2494017678608846`, 
       0.9077435189160142, 0.29494374842358073`}, {
       1.2494017678608846`, -0.9077435189160141, 
       0.29494374842358073`}, {-0.29494374842358073`, 0.9077435189160142, 
       1.2494017678608846`}, {-0.29494374842358073`, -0.9077435189160141, 
       1.2494017678608846`}, {0.29494374842358073`, 
       0.9077435189160142, -1.2494017678608846`}, {
       0.29494374842358073`, -0.9077435189160141, -1.2494017678608846`}, \
{-0.7721727581422326, 
       0.5610163477575297, -1.2494017678608846`}, {-0.7721727581422326, \
-0.5610163477575298, -1.2494017678608846`}, {0.7721727581422326, 
       0.5610163477575297, 1.2494017678608846`}, {
       0.7721727581422326, -0.5610163477575298, 
       1.2494017678608846`}, {-0.4772290097186562, 1.468759866673544, 
       0.29494374842358073`}, {-0.4772290097186562, -1.468759866673544, 
       0.29494374842358073`}, {0.477229009718654, 
       1.468759866673544, -0.29494374842358073`}, {
       0.477229009718654, -1.468759866673544, -0.29494374842358073`}}], 
     Polygon3DBox[{{21, 2, 12}, {21, 12, 6}, {21, 6, 2}, {15, 2, 6}, {15, 6, 
      5}, {15, 5, 2}, {22, 2, 5}, {22, 5, 11}, {22, 11, 2}, {28, 2, 11}, {28, 
      11, 4}, {28, 4, 2}, {27, 2, 4}, {27, 4, 12}, {27, 12, 2}, {24, 7, 9}, {
      24, 9, 1}, {24, 1, 7}, {16, 8, 7}, {16, 7, 1}, {16, 1, 8}, {23, 10, 
      8}, {23, 8, 1}, {23, 1, 10}, {25, 3, 10}, {25, 10, 1}, {25, 1, 3}, {26, 
      9, 3}, {26, 3, 1}, {26, 1, 9}, {29, 12, 10}, {29, 10, 6}, {29, 6, 12}, {
      13, 6, 3}, {13, 3, 5}, {13, 5, 6}, {30, 5, 9}, {30, 9, 11}, {30, 11, 
      5}, {20, 11, 7}, {20, 7, 4}, {20, 4, 11}, {19, 4, 8}, {19, 8, 12}, {19, 
      12, 4}, {32, 7, 11}, {32, 11, 9}, {32, 9, 7}, {14, 8, 4}, {14, 4, 7}, {
      14, 7, 8}, {31, 10, 12}, {31, 12, 8}, {31, 8, 10}, {17, 3, 6}, {17, 6, 
      10}, {17, 10, 3}, {18, 9, 5}, {18, 5, 3}, {18, 3, 9}}]],
    Boxed->False,
    ImageSize->{99.83940242220801, 100.},
    ViewPoint->{0.0030124698202508293`, -2.8066412788513992`, 
     1.8901734462405728`},
    ViewVertical->{-0.28104140417203943`, -0.07172101959684306, 
     1.183248966211339}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355229611],

Cell[BoxData["\<\"spikey.zpr\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1980166917]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ZPR - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 41.8271440}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ZPrint CAD format. Used with Z Corporation 3D printers. Native format of \
the ZEdit and ZPrint applications. Developed by Z Corporation. Stores a \
physical 3D model and color information. Binary format.", "synonyms" -> {}, 
    "title" -> "ZPR", "type" -> "Format", "uri" -> "ref/format/ZPR"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15123, 527, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72652, 1527}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2522, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3145, 78, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[3255, 84, 250, 8, 70, "FormatUsage",
 CellID->37585799],
Cell[3508, 94, 211, 7, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3756, 106, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3812, 109, 328, 11, 70, "FormatNotes",
 CellID->8194],
Cell[4143, 122, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4185, 125, 516, 17, 70, "FormatNotes",
 CellID->6249],
Cell[4704, 144, 157, 4, 70, "FormatNotes",
 CellID->1572705229],
Cell[4864, 150, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[4905, 153, 529, 20, 70, "FormatNotes",
 CellID->20289],
Cell[5437, 175, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[6515, 217, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[7179, 241, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[7997, 271, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[8038, 274, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[8277, 285, 216, 9, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[8530, 299, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[8589, 302, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[8660, 305, 1577, 39, 70, "2ColumnTableMod",
 CellID->230773093],
Cell[10240, 346, 332, 12, 70, "FormatNotes",
 CellID->2136836049]
}, Open  ]],
Cell[CellGroupData[{
Cell[10609, 363, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[10661, 366, 60, 1, 70, "FormatNotes",
 CellID->2132824898],
Cell[10724, 369, 468, 12, 70, "3ColumnTableMod",
 CellID->28047],
Cell[11195, 383, 243, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[11441, 392, 701, 25, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[12179, 422, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[12237, 425, 2466, 83, 70, "SeeAlso",
 CellID->1314740650]
}, Open  ]],
Cell[CellGroupData[{
Cell[14740, 513, 57, 1, 70, "MoreAboutSection",
 CellID->70106775],
Cell[14800, 516, 150, 2, 70, "MoreAbout"],
Cell[14953, 520, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15123, 527, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[15239, 533, 60, 1, 70, "ExampleSection",
 CellID->301532412],
Cell[15302, 536, 227, 8, 70, "ExampleText",
 CellID->1061340363],
Cell[CellGroupData[{
Cell[15554, 548, 713, 20, 70, "Input",
 CellID->948308959],
Cell[16270, 570, 45954, 753, 70, "Output",
 CellID->1038093209]
}, Open  ]],
Cell[62239, 1326, 72, 1, 70, "ExampleText",
 CellID->2025524877],
Cell[CellGroupData[{
Cell[62336, 1331, 141, 4, 70, "Input",
 CellID->1085835495],
Cell[62480, 1337, 86, 2, 70, "Output",
 CellID->321132259]
}, Open  ]],
Cell[62581, 1342, 125, 3, 70, "ExampleDelimiter",
 CellID->674089440],
Cell[62709, 1347, 70, 1, 70, "ExampleText",
 CellID->1444980155],
Cell[CellGroupData[{
Cell[62804, 1352, 8601, 139, 70, "Input",
 CellID->355229611],
Cell[71408, 1493, 89, 2, 70, "Output",
 CellID->1980166917]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[71536, 1500, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

