(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7689,        262]
NotebookOptionsPosition[      5303,        185]
NotebookOutlinePosition[      6808,        231]
CellTagsIndexPosition[      6731,        226]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA FRONT END TOKEN", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Install\"" :> 
          Documentation`HelpLookup["paclet:ref/frontendobject/Install"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"\\\"Install\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Front End Tokens" :> 
          Documentation`HelpLookup["paclet:guide/FrontEndTokens"], 
          "Tokens Related to the Palettes Menu" :> 
          Documentation`HelpLookup["paclet:guide/PalettesTokens"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Front End Tokens\"\>", 
       2->"\<\"Tokens Related to the Palettes Menu\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"GeneratePalette\"", "ObjectNameAlt",
 CellTags->"GeneratePalette",
 CellID->2403],

Cell[TextData[{
 "This token has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["\"\<GeneratePalette\>\""], "InlineFormula"],
     "\[LineSeparator]is a front end token that converts a selection into a \
palette."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"GeneratePalette",
 CellID->28042]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["\"\<GeneratePalette\>\""], "InlineFormula"],
 " is equivalent to ",
 StyleBox[ButtonBox["Palettes",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/PalettesMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Generate Palette from Selection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/GeneratePaletteFromSelection"], 
  "MenuName"],
 "."
}], "Notes",
 CellTags->"GeneratePalette",
 CellID->6300],

Cell[TextData[{
 "A typical use is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"], "[", 
   RowBox[{
    ButtonBox["FrontEndToken",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrontEndToken"], "[", "\"\<GeneratePalette\>\"", 
    "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"GeneratePalette",
 CellID->15811]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26615],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["\"\<Install\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/Install"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->28804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Front End Tokens",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FrontEndTokens"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tokens Related to the Palettes Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PalettesTokens"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"GeneratePalette\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 52, 35.3753898}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Front End Token", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"GeneratePalette\" is a front end token that converts a selection into \
a palette.", "synonyms" -> {"generate palette"}, "title" -> "GeneratePalette",
     "type" -> "Front End Object", "uri" -> 
    "ref/frontendobject/GeneratePalette"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GeneratePalette"->{
  Cell[1966, 61, 89, 2, 70, "ObjectNameAlt",
   CellTags->"GeneratePalette",
   CellID->2403],
  Cell[2256, 72, 406, 12, 70, "Usage",
   CellTags->"GeneratePalette",
   CellID->28042],
  Cell[3177, 106, 490, 14, 70, "Notes",
   CellTags->"GeneratePalette",
   CellID->6300],
  Cell[3670, 122, 418, 15, 70, "Notes",
   CellTags->"GeneratePalette",
   CellID->15811]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GeneratePalette", 6341, 210}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1343, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1966, 61, 89, 2, 70, "ObjectNameAlt",
 CellTags->"GeneratePalette",
 CellID->2403],
Cell[2058, 65, 195, 5, 70, "AwaitingReviewNote"],
Cell[2256, 72, 406, 12, 70, "Usage",
 CellTags->"GeneratePalette",
 CellID->28042]
}, Open  ]],
Cell[CellGroupData[{
Cell[2699, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3177, 106, 490, 14, 70, "Notes",
 CellTags->"GeneratePalette",
 CellID->6300],
Cell[3670, 122, 418, 15, 70, "Notes",
 CellTags->"GeneratePalette",
 CellID->15811]
}, Closed]],
Cell[CellGroupData[{
Cell[4125, 142, 311, 9, 70, "SeeAlsoSection",
 CellID->26615],
Cell[4439, 153, 217, 6, 70, "SeeAlso",
 CellID->28804]
}, Open  ]],
Cell[CellGroupData[{
Cell[4693, 164, 299, 8, 70, "MoreAboutSection"],
Cell[4995, 174, 122, 2, 70, "MoreAbout"],
Cell[5120, 178, 141, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5276, 183, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

