(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8271,        274]
NotebookOptionsPosition[      5814,        196]
NotebookOutlinePosition[      7344,        242]
CellTagsIndexPosition[      7266,        237]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA FRONT END TOKEN", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"ImportPictures\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/ImportPictures"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"\\\"ImportPictures\\\"\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Front End Tokens" :> 
          Documentation`HelpLookup["paclet:guide/FrontEndTokens"], 
          "Tokens Related to the Graphics Menu" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsTokens"], 
          "Tokens Related to the Insert Menu" :> 
          Documentation`HelpLookup["paclet:guide/InsertTokens"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Front End Tokens\"\>", 
       2->"\<\"Tokens Related to the Graphics Menu\"\>", 
       3->"\<\"Tokens Related to the Insert Menu\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"InsertNewGraphic\"", "ObjectNameAlt",
 CellTags->"InsertNewGraphic",
 CellID->1710],

Cell[TextData[{
 "This token has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["\"\<InsertNewGraphic\>\""], "InlineFormula"],
     "\[LineSeparator]is a front end token that inserts an empty graphic into \
the input notebook."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"InsertNewGraphic",
 CellID->21968]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["\"\<InsertNewGraphic\>\""], "InlineFormula"],
 " is equivalent to ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Picture",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Picture"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["New Graphic",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/NewGraphic"], "MenuName"],
 "."
}], "Notes",
 CellTags->"InsertNewGraphic",
 CellID->31708],

Cell[TextData[{
 "A typical use is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"], "[", 
   RowBox[{
    ButtonBox["FrontEndToken",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrontEndToken"], "[", "\"\<InsertNewGraphic\>\"",
     "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"InsertNewGraphic",
 CellID->2641]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32701],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["\"\<ImportPictures\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/ImportPictures"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->29869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Front End Tokens",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FrontEndTokens"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tokens Related to the Graphics Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTokens"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tokens Related to the Insert Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InsertTokens"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"InsertNewGraphic\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 52, 43.5005978}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Front End Token", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"InsertNewGraphic\" is a front end token that inserts an empty graphic \
into the input notebook.", "synonyms" -> {"insert new graphic"}, "title" -> 
    "InsertNewGraphic", "type" -> "Front End Object", "uri" -> 
    "ref/frontendobject/InsertNewGraphic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "InsertNewGraphic"->{
  Cell[2176, 65, 91, 2, 70, "ObjectNameAlt",
   CellTags->"InsertNewGraphic",
   CellID->1710],
  Cell[2468, 76, 421, 12, 70, "Usage",
   CellTags->"InsertNewGraphic",
   CellID->21968],
  Cell[3404, 110, 619, 17, 70, "Notes",
   CellTags->"InsertNewGraphic",
   CellID->31708],
  Cell[4026, 129, 419, 15, 70, "Notes",
   CellTags->"InsertNewGraphic",
   CellID->2641]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"InsertNewGraphic", 6872, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1553, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2176, 65, 91, 2, 70, "ObjectNameAlt",
 CellTags->"InsertNewGraphic",
 CellID->1710],
Cell[2270, 69, 195, 5, 70, "AwaitingReviewNote"],
Cell[2468, 76, 421, 12, 70, "Usage",
 CellTags->"InsertNewGraphic",
 CellID->21968]
}, Open  ]],
Cell[CellGroupData[{
Cell[2926, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3404, 110, 619, 17, 70, "Notes",
 CellTags->"InsertNewGraphic",
 CellID->31708],
Cell[4026, 129, 419, 15, 70, "Notes",
 CellTags->"InsertNewGraphic",
 CellID->2641]
}, Closed]],
Cell[CellGroupData[{
Cell[4482, 149, 311, 9, 70, "SeeAlsoSection",
 CellID->32701],
Cell[4796, 160, 231, 6, 70, "SeeAlso",
 CellID->29869]
}, Open  ]],
Cell[CellGroupData[{
Cell[5064, 171, 299, 8, 70, "MoreAboutSection"],
Cell[5366, 181, 122, 2, 70, "MoreAbout"],
Cell[5491, 185, 141, 2, 70, "MoreAbout"],
Cell[5635, 189, 137, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5787, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

