(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8903,        295]
NotebookOptionsPosition[      6189,        212]
NotebookOutlinePosition[      7927,        262]
CellTagsIndexPosition[      7840,        257]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA FRONT END TOKEN", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"EvaluatorAbort\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/EvaluatorAbort"], 
          "\"FindEvaluatingCell\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/FindEvaluatingCell"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"EvaluatorAbort\\\"\"\>", 
       2->"\<\"\\\"FindEvaluatingCell\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tokens Related to the Evaluation Menu" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationTokens"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Tokens Related to the Evaluation Menu\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"RemoveFromEvaluationQueue\"", "ObjectNameAlt",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->5312],

Cell[TextData[{
 "This token has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["\"\<RemoveFromEvaluationQueue\>\""], "InlineFormula"],
     "\[LineSeparator]is a front end token that cancels the pending \
evaluation of a selected cell."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"RemoveFromEvaluationQueue",
 CellID->9401]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["\"\<RemoveFromEvaluationQueue\>\""], "InlineFormula"],
 " is equivalent to ",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Remove from Evaluation Queue",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/RemoveFromEvaluationQueue"], "MenuName"],
 "."
}], "Notes",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->25199],

Cell[TextData[{
 "To stop the evaluation of a cell that is currently being evaluated, use the \
front end token ",
 Cell[BoxData[
  ButtonBox["\"\<EvaluatorInterrupt\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/EvaluatorInterrupt"]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["\"\<EvaluatorAbort\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/EvaluatorAbort"]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->24727],

Cell[TextData[{
 "A typical use is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"], "[", 
   RowBox[{
    ButtonBox["FrontEndToken",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrontEndToken"], "[", 
    "\"\<RemoveFromEvaluationQueue\>\"", "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->32692]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27149],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<EvaluatorAbort\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/EvaluatorAbort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<FindEvaluatingCell\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/FindEvaluatingCell"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Tokens Related to the Evaluation Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationTokens"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"RemoveFromEvaluationQueue\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 53, 22.6891010}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Front End Token", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"RemoveFromEvaluationQueue\" is a front end token that cancels the \
pending evaluation of a selected cell.", 
    "synonyms" -> {"remove from evaluation queue"}, "title" -> 
    "RemoveFromEvaluationQueue", "type" -> "Front End Object", "uri" -> 
    "ref/frontendobject/RemoveFromEvaluationQueue"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "RemoveFromEvaluationQueue"->{
  Cell[2049, 63, 109, 2, 70, "ObjectNameAlt",
   CellTags->"RemoveFromEvaluationQueue",
   CellID->5312],
  Cell[2359, 74, 439, 12, 70, "Usage",
   CellTags->"RemoveFromEvaluationQueue",
   CellID->9401],
  Cell[3313, 108, 506, 13, 70, "Notes",
   CellTags->"RemoveFromEvaluationQueue",
   CellID->25199],
  Cell[3822, 123, 520, 17, 70, "Notes",
   CellTags->"RemoveFromEvaluationQueue",
   CellID->24727],
  Cell[4345, 142, 438, 15, 70, "Notes",
   CellTags->"RemoveFromEvaluationQueue",
   CellID->32692]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"RemoveFromEvaluationQueue", 7308, 238}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1426, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2049, 63, 109, 2, 70, "ObjectNameAlt",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->5312],
Cell[2161, 67, 195, 5, 70, "AwaitingReviewNote"],
Cell[2359, 74, 439, 12, 70, "Usage",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->9401]
}, Open  ]],
Cell[CellGroupData[{
Cell[2835, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3313, 108, 506, 13, 70, "Notes",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->25199],
Cell[3822, 123, 520, 17, 70, "Notes",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->24727],
Cell[4345, 142, 438, 15, 70, "Notes",
 CellTags->"RemoveFromEvaluationQueue",
 CellID->32692]
}, Closed]],
Cell[CellGroupData[{
Cell[4820, 162, 311, 9, 70, "SeeAlsoSection",
 CellID->27149],
Cell[5134, 173, 529, 17, 70, "SeeAlso",
 CellID->12376]
}, Open  ]],
Cell[CellGroupData[{
Cell[5700, 195, 299, 8, 70, "MoreAboutSection"],
Cell[6002, 205, 145, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6162, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

