(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7858,        260]
NotebookOptionsPosition[      5502,        187]
NotebookOutlinePosition[      6985,        230]
CellTagsIndexPosition[      6902,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA FRONT END TOKEN", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Convert Dynamic To Literal" :> 
          Documentation`HelpLookup[
           "paclet:ref/menuitem/ConvertDynamicToLiteral"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Convert Dynamic To Literal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tokens Related to the Evaluation Menu" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationTokens"], 
          "Front End Tokens" :> 
          Documentation`HelpLookup["paclet:guide/FrontEndTokens"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Tokens Related to the Evaluation Menu\"\>", 
       2->"\<\"Front End Tokens\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["\"ToggleDynamicUpdating\"", "ObjectNameAlt",
 CellTags->"RefreshDynamicObjects",
 CellID->21479],

Cell[TextData[{
 "This token has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["\"\<ToggleDynamicUpdating\>\""], "InlineFormula"],
     "\[LineSeparator]is a front end token that toggles automatic refreshing \
of a ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"RefreshDynamicObjects",
 CellID->14144]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["\"\<ToggleDynamicUpdating\>\""], "InlineFormula"],
 " is equivalent to ",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Dynamic Updating Enabled",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/DynamicUpdatingEnabled"], "MenuName"],
 "."
}], "Notes",
 CellID->9594744],

Cell[TextData[{
 " A typical use is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FrontEndExecute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrontEndExecute"], "[", 
   RowBox[{
    ButtonBox["FrontEndToken",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrontEndToken"], "[", 
    "\"\<ToggleDynamicUpdating\>\"", "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->"RefreshDynamicObjects",
 CellID->9449]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21027],

Cell[TextData[StyleBox[ButtonBox["Convert Dynamic To Literal",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/menuitem/ConvertDynamicToLiteral"], "MenuName",
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->15610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Tokens Related to the Evaluation Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationTokens"]], "MoreAbout"],

Cell[TextData[ButtonBox["Front End Tokens",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FrontEndTokens"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"\"ToggleDynamicUpdating\" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 53, 46.5647122}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Front End Token", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "\"ToggleDynamicUpdating\" is a front end token that toggles automatic \
refreshing of a Dynamic.", "synonyms" -> {"toggle dynamic updating"}, "title" -> 
    "ToggleDynamicUpdating", "type" -> "Front End Object", "uri" -> 
    "ref/frontendobject/ToggleDynamicUpdating"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "RefreshDynamicObjects"->{
  Cell[2025, 62, 102, 2, 70, "ObjectNameAlt",
   CellTags->"RefreshDynamicObjects",
   CellID->21479],
  Cell[2328, 73, 559, 17, 70, "Usage",
   CellTags->"RefreshDynamicObjects",
   CellID->14144],
  Cell[3862, 126, 430, 15, 70, "Notes",
   CellTags->"RefreshDynamicObjects",
   CellID->9449]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"RefreshDynamicObjects", 6583, 212}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1402, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2025, 62, 102, 2, 70, "ObjectNameAlt",
 CellTags->"RefreshDynamicObjects",
 CellID->21479],
Cell[2130, 66, 195, 5, 70, "AwaitingReviewNote"],
Cell[2328, 73, 559, 17, 70, "Usage",
 CellTags->"RefreshDynamicObjects",
 CellID->14144]
}, Open  ]],
Cell[CellGroupData[{
Cell[2924, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3402, 112, 457, 12, 70, "Notes",
 CellID->9594744],
Cell[3862, 126, 430, 15, 70, "Notes",
 CellTags->"RefreshDynamicObjects",
 CellID->9449]
}, Closed]],
Cell[CellGroupData[{
Cell[4329, 146, 311, 9, 70, "SeeAlsoSection",
 CellID->21027],
Cell[4643, 157, 208, 4, 70, "SeeAlso",
 CellID->15610]
}, Open  ]],
Cell[CellGroupData[{
Cell[4888, 166, 299, 8, 70, "MoreAboutSection"],
Cell[5190, 176, 145, 2, 70, "MoreAbout"],
Cell[5338, 180, 122, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5475, 185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

