(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11079,        345]
NotebookOptionsPosition[      7310,        239]
NotebookOutlinePosition[      9810,        305]
CellTagsIndexPosition[      9684,        299]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Numbering" :> 
          Documentation`HelpLookup["paclet:tutorial/AutomaticNumbering"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Automatic Numbering\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Add/Remove Cell Tags" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/AddRemoveCellTags"], 
          RowBox[{"\"CreateCounterBoxDialog\"", " "}] :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/CreateCounterBoxDialog"], 
          "Show Page Breaks" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/ShowPageBreaks"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Add/Remove Cell Tags\"\>", 2->
       
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"\\\"CreateCounterBoxDialog\\\"\"\>", ",", "\<\" \"\>"}],
          "}"}], "]"}], 3->"\<\"Show Page Breaks\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Insert Menu" :> 
          Documentation`HelpLookup["paclet:guide/InsertMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Insert Menu\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Insert ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Automatic Numbering..."
}], "ObjectName",
 CellID->29421455],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Automatic Numbering", "MenuName"],
     "\[LineSeparator]creates an automatic numbering object, or counter, in \
the current notebook."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->7518]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The counters available in a particular notebook are usually defined by the \
stylesheet. The default stylesheet defines counters named \"Section\", \
\"Subsection\", \"Subsubsection\", \"Equation\", \"Figure\", and \"Table\".\
\>", "Notes",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->8177],

Cell["\<\
Counter values can be displayed either as they exist at the location of the \
display or as they exist at a remote location defined by a cell tag.\
\>", "Notes",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->17773],

Cell["\<\
A counter named \"Page\" is always available, but it is only valid when the \
option to show page breaks is turned on. \
\>", "Notes",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->32270],

Cell[TextData[{
 "Counter values are set and incremented by the options ",
 Cell[BoxData[
  ButtonBox["CounterAssignments",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CounterAssignments"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CounterIncrements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CounterIncrements"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->1763]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7627],

Cell[TextData[{
 StyleBox[ButtonBox["Add/Remove Cell Tags",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AddRemoveCellTags"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    RowBox[{"\"\<CreateCounterBoxDialog\>\"", " "}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/CreateCounterBoxDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Show Page Breaks",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowPageBreaks"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->8080810]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Insert Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InsertMenu"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13985],

Cell[TextData[ButtonBox["Automatic Numbering",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AutomaticNumbering"]], "Tutorials",
 CellID->3102]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Insert > Automatic Numbering... - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 53, 55.2836854}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Automatic Numbering creates an automatic numbering object, or counter, \
in the current notebook.", "synonyms" -> {}, "title" -> 
    "Insert > Automatic Numbering...", "type" -> "Menu Item", "uri" -> 
    "ref/menuitem/AutomaticNumbering"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "CreateCounterBoxDialog"->{
  Cell[2969, 89, 441, 12, 70, "Usage",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->7518],
  Cell[3925, 123, 332, 6, 70, "Notes",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->8177],
  Cell[4260, 131, 254, 5, 70, "Notes",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->17773],
  Cell[4517, 138, 227, 5, 70, "Notes",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->32270],
  Cell[4747, 145, 460, 14, 70, "Notes",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->1763]},
 "createCounterBoxDialogID"->{
  Cell[2969, 89, 441, 12, 70, "Usage",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->7518],
  Cell[3925, 123, 332, 6, 70, "Notes",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->8177],
  Cell[4260, 131, 254, 5, 70, "Notes",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->17773],
  Cell[4517, 138, 227, 5, 70, "Notes",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->32270],
  Cell[4747, 145, 460, 14, 70, "Notes",
   CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
   CellID->1763]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"CreateCounterBoxDialog", 8362, 264},
 {"createCounterBoxDialogID", 9027, 280}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2200, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2823, 82, 143, 5, 70, "ObjectName",
 CellID->29421455],
Cell[2969, 89, 441, 12, 70, "Usage",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->7518]
}, Open  ]],
Cell[CellGroupData[{
Cell[3447, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3925, 123, 332, 6, 70, "Notes",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->8177],
Cell[4260, 131, 254, 5, 70, "Notes",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->17773],
Cell[4517, 138, 227, 5, 70, "Notes",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->32270],
Cell[4747, 145, 460, 14, 70, "Notes",
 CellTags->{"CreateCounterBoxDialog", "createCounterBoxDialogID"},
 CellID->1763]
}, Closed]],
Cell[CellGroupData[{
Cell[5244, 164, 310, 9, 70, "SeeAlsoSection",
 CellID->7627],
Cell[5557, 175, 758, 23, 70, "SeeAlso",
 CellID->8080810]
}, Open  ]],
Cell[CellGroupData[{
Cell[6352, 203, 299, 8, 70, "MoreAboutSection"],
Cell[6654, 213, 113, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6804, 220, 314, 9, 70, "TutorialsSection",
 CellID->13985],
Cell[7121, 231, 147, 3, 70, "Tutorials",
 CellID->3102]
}, Open  ]],
Cell[7283, 237, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

