(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11410,        369]
NotebookOptionsPosition[      7478,        253]
NotebookOutlinePosition[     10024,        324]
CellTagsIndexPosition[      9911,        318]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Find" :> Documentation`HelpLookup["paclet:ref/menuitem/Find"], 
          "\"FindNextMisspelling\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/FindNextMisspelling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Find\"\>", 
       2->"\<\"\\\"FindNextMisspelling\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Edit Menu" :> 
          Documentation`HelpLookup["paclet:guide/EditMenu"], 
          "Notebook Basics" :> 
          Documentation`HelpLookup["paclet:guide/NotebookBasics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Edit Menu\"\>", 
       2->"\<\"Notebook Basics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Edit ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Check Spelling..."
}], "ObjectName",
 CellID->68996591],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Check Spelling", "MenuName"],
     "\[LineSeparator]opens the ",
     StyleBox["Check Spelling", "DialogElementName"],
     " dialog box and searches for misspelled words. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->32257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When a misspelled word is found, it is displayed in the dialog box along \
with a list of suggested alternatives. Click a suggested word to copy it to \
the ",
 StyleBox["Replace with:", "DialogElementName"],
 " field. ",
 "Double-click",
 " a suggested word to paste it into the notebook and continue the search."
}], "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->24766],

Cell[TextData[{
 "There are several possible reasons for stopping at a word. The reason for \
stopping is given in a string at the top of the dialog box. Click ",
 StyleBox["Skip", "DialogElementName"],
 " if you do not want to stop for the same reason again."
}], "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->4944],

Cell[TextData[{
 "To continue the search without replacing the selected word, click ",
 StyleBox["Skip", "DialogElementName"],
 ". Click ",
 StyleBox["Add Word", "DialogElementName"],
 " to add the selected word to the dictionary. All future occurrences of that \
word will then be ignored. "
}], "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->14955],

Cell[TextData[{
 "You can modify the conditions used for stopping at or skipping words by \
changing the settings for the options ",
 StyleBox["Always Stop", "DialogElementName"],
 ", ",
 StyleBox["Always Skip", "DialogElementName"],
 ", and ",
 StyleBox["Word Splitting", "DialogElementName"],
 ". To do this, click ",
 StyleBox["Options", "DialogElementName"],
 " to open the ",
 StyleBox["Option Inspector", "DialogElementName"],
 " at the scope specified by the ",
 StyleBox["Store words and options:", "DialogElementName"],
 " popup menu on the ",
 StyleBox["Check Spelling", "DialogElementName"],
 " dialog box. "
}], "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->23318],

Cell[TextData[{
 "Keyboard shortcuts: ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[";", "KeyEvent"],
 " (Windows); ",
 StyleBox["Cmd", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[";", "KeyEvent"],
 " (Macintosh); ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[";", "KeyEvent"],
 " (X)."
}], "Notes",
 AspectRatioFixed->False,
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->25411]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9496],

Cell[TextData[{
 StyleBox[ButtonBox["Find",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Find"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<FindNextMisspelling\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/FindNextMisspelling"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->522978780]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31001],

Cell[TextData[Cell[BoxData[
 ButtonBox["SpellingOptions",
  BaseStyle->"Link",
  ButtonData->
   "paclet:ref/SpellingOptions"]], "InlineFormula"]], "RelatedLinks",
 CellID->22549]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Edit Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EditMenu"]], "MoreAbout"],

Cell[TextData[ButtonBox["Notebook Basics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookBasics"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Edit > Check Spelling... - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 54, 3.5963982}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Check Spelling opens the Check Spelling dialog box and searches for \
misspelled words. ", "synonyms" -> {}, "title" -> "Edit > Check Spelling...", 
    "type" -> "Menu Item", "uri" -> "ref/menuitem/CheckSpelling"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "CheckSpelling"->{
  Cell[2178, 69, 467, 13, 70, "Usage",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->32257],
  Cell[3160, 104, 415, 10, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->24766],
  Cell[3578, 116, 342, 7, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->4944],
  Cell[3923, 125, 375, 9, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->14955],
  Cell[4301, 136, 702, 19, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->23318],
  Cell[5006, 157, 479, 17, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->25411]},
 "spellCheckerDialogID"->{
  Cell[2178, 69, 467, 13, 70, "Usage",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->32257],
  Cell[3160, 104, 415, 10, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->24766],
  Cell[3578, 116, 342, 7, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->4944],
  Cell[3923, 125, 375, 9, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->14955],
  Cell[4301, 136, 702, 19, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->23318],
  Cell[5006, 157, 479, 17, 70, "Notes",
   CellTags->{"CheckSpelling", "spellCheckerDialogID"},
   CellID->25411]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"CheckSpelling", 8487, 277},
 {"spellCheckerDialogID", 9201, 296}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1416, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2039, 62, 136, 5, 70, "ObjectName",
 CellID->68996591],
Cell[2178, 69, 467, 13, 70, "Usage",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->32257]
}, Open  ]],
Cell[CellGroupData[{
Cell[2682, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3160, 104, 415, 10, 70, "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->24766],
Cell[3578, 116, 342, 7, 70, "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->4944],
Cell[3923, 125, 375, 9, 70, "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->14955],
Cell[4301, 136, 702, 19, 70, "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->23318],
Cell[5006, 157, 479, 17, 70, "Notes",
 CellTags->{"CheckSpelling", "spellCheckerDialogID"},
 CellID->25411]
}, Closed]],
Cell[CellGroupData[{
Cell[5522, 179, 310, 9, 70, "SeeAlsoSection",
 CellID->9496],
Cell[5835, 190, 469, 15, 70, "SeeAlso",
 CellID->522978780]
}, Open  ]],
Cell[CellGroupData[{
Cell[6341, 210, 321, 9, 70, "RelatedLinksSection",
 CellID->31001],
Cell[6665, 221, 179, 5, 70, "RelatedLinks",
 CellID->22549]
}, Open  ]],
Cell[CellGroupData[{
Cell[6881, 231, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[7203, 242, 109, 2, 70, "MoreAbout"],
Cell[7315, 246, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7451, 251, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

