(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10954,        350]
NotebookOptionsPosition[      7327,        243]
NotebookOutlinePosition[      9665,        308]
CellTagsIndexPosition[      9548,        302]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Setting Up Hyperlinks" :> 
          Documentation`HelpLookup["paclet:tutorial/SettingUpHyperlinks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Setting Up Hyperlinks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Tags" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/CellTags"], 
          "\"CreateHyperlinkDialog\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/CreateHyperlinkDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cell Tags\"\>", 
       2->"\<\"\\\"CreateHyperlinkDialog\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Insert Menu" :> 
          Documentation`HelpLookup["paclet:guide/InsertMenu"], "Menu Items" :> 
          Documentation`HelpLookup["paclet:guide/MenuItems"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Insert Menu\"\>", 
       2->"\<\"Menu Items\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Insert ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Hyperlink..."
}], "ObjectName",
 CellID->875407522],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Hyperlink", "MenuName"],
     "\[LineSeparator]creates a hyperlink to a specified cell, notebook, or \
URL."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->25191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "To create a hyperlink, select a string and choose ",
 StyleBox[ButtonBox["Insert",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/InsertMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Hyperlink", "MenuName"],
 ". Specify a link destination, which can be a cell, notebook, or URL, and \
click ",
 StyleBox["OK", "DialogElementName"],
 "."
}], "Notes",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->8990],

Cell[TextData[{
 "When you click the hyperlink, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will jump to the linked cell or notebook."
}], "Notes",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->29832],

Cell[TextData[{
 "Cells are targeted by use of cell tags. If your destination cells do not \
already have cell tags, you must add them first by using ",
 StyleBox[ButtonBox["Cell",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CellMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Cell Tags",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CellTags"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Add/Remove Cell Tags",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AddRemoveCellTags"], "MenuName"],
 "."
}], "Notes",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->10996],

Cell["\<\
To edit the name of a hyperlink, click beside the hyperlink and use the arrow \
keys to move the insertion point into the hyperlink's text.\
\>", "Notes",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->3967]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19095],

Cell[TextData[{
 StyleBox[ButtonBox["Cell Tags",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CellTags"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<CreateHyperlinkDialog\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/CreateHyperlinkDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30906]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11462],

Cell[TextData[ButtonBox["Setting Up Hyperlinks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SettingUpHyperlinks"]], "Tutorials",
 CellID->32138]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Insert Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InsertMenu"]], "MoreAbout"],

Cell[TextData[ButtonBox["Menu Items",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MenuItems"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Insert > Hyperlink... - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 54, 51.1444904}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Hyperlink creates a hyperlink to a specified cell, notebook, or URL.", 
    "synonyms" -> {}, "title" -> "Insert > Hyperlink...", "type" -> 
    "Menu Item", "uri" -> "ref/menuitem/Hyperlink"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "CreateHyperlinkDialog"->{
  Cell[2765, 84, 406, 12, 70, "Usage",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->25191],
  Cell[3686, 118, 487, 13, 70, "Notes",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->8990],
  Cell[4176, 133, 232, 7, 70, "Notes",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->29832],
  Cell[4411, 142, 714, 17, 70, "Notes",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->10996],
  Cell[5128, 161, 237, 5, 70, "Notes",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->3967]},
 "copyLinkDialogID"->{
  Cell[2765, 84, 406, 12, 70, "Usage",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->25191],
  Cell[3686, 118, 487, 13, 70, "Notes",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->8990],
  Cell[4176, 133, 232, 7, 70, "Notes",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->29832],
  Cell[4411, 142, 714, 17, 70, "Notes",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->10996],
  Cell[5128, 161, 237, 5, 70, "Notes",
   CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
   CellID->3967]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"CreateHyperlinkDialog", 8320, 267},
 {"copyLinkDialogID", 8934, 283}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2005, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2628, 77, 134, 5, 70, "ObjectName",
 CellID->875407522],
Cell[2765, 84, 406, 12, 70, "Usage",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->25191]
}, Open  ]],
Cell[CellGroupData[{
Cell[3208, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3686, 118, 487, 13, 70, "Notes",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->8990],
Cell[4176, 133, 232, 7, 70, "Notes",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->29832],
Cell[4411, 142, 714, 17, 70, "Notes",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->10996],
Cell[5128, 161, 237, 5, 70, "Notes",
 CellTags->{"CreateHyperlinkDialog", "copyLinkDialogID"},
 CellID->3967]
}, Closed]],
Cell[CellGroupData[{
Cell[5402, 171, 311, 9, 70, "SeeAlsoSection",
 CellID->19095],
Cell[5716, 182, 478, 15, 70, "SeeAlso",
 CellID->30906]
}, Open  ]],
Cell[CellGroupData[{
Cell[6231, 202, 314, 9, 70, "TutorialsSection",
 CellID->11462],
Cell[6548, 213, 151, 3, 70, "Tutorials",
 CellID->32138]
}, Open  ]],
Cell[CellGroupData[{
Cell[6736, 221, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[7058, 232, 113, 2, 70, "MoreAbout"],
Cell[7174, 236, 111, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7300, 241, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

