(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10835,        347]
NotebookOptionsPosition[      6991,        235]
NotebookOutlinePosition[      9610,        308]
CellTagsIndexPosition[      9497,        302]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Editable" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/Editable"], 
          "Evaluatable" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/Evaluatable"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Editable\"\>", 
       2->"\<\"Evaluatable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Managing Computations in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ManagingComputationsInNotebooks"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Managing Computations in Notebooks\"\>", 
       2->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Cell ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Cell Properties ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Initialization Cell"
}], "ObjectName",
 CellID->100170434],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Initialization Cell", "MenuName"],
     "\[LineSeparator]makes a cell auto-evaluate whenever the notebook is \
opened and the kernel is launched."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->19891]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
When a cell is an initialization cell, a vertical tick mark (|) appears in \
the cell bracket.\
\>", "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->138],

Cell[TextData[{
 StyleBox["Initialization Cell", "MenuName"],
 " toggles the option ",
 Cell[BoxData[
  ButtonBox["InitializationCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InitializationCell"]], "InlineFormula"],
 " between ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " on the selected cell objects."
}], "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->13310],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["InitializationCellEvaluation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InitializationCellEvaluation"]], "InlineFormula"],
 ", set at the notebook level, determines when the initialization cells in a \
notebook are evaluated."
}], "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->20967],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["InitializationCellWarning",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InitializationCellWarning"]], "InlineFormula"],
 " determines whether you get a dialog box confirming that you want to \
evaluate the initialization cells, at the time determined by ",
 Cell[BoxData[
  ButtonBox["InitializationCellEvaluation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InitializationCellEvaluation"]], "InlineFormula"],
 ". "
}], "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->15055],

Cell[TextData[{
 "You can evaluate the initialization cells manually at any time by choosing \
",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Evaluate Initialization Cells",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EvaluateInitializationCells"], 
  "MenuName"],
 "."
}], "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->13787]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6648],

Cell[TextData[{
 StyleBox[ButtonBox["Editable",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Editable"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Evaluatable",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Evaluatable"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->183979256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Managing Computations in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManagingComputationsInNotebooks"]], "MoreAbout"],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cell > Cell Properties > Initialization Cell - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 54, 51.3007444}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Initialization Cell makes a cell auto-evaluate whenever the notebook is \
opened and the kernel is launched.", "synonyms" -> {}, "title" -> 
    "Cell > Cell Properties > Initialization Cell", "type" -> "Menu Item", 
    "uri" -> "ref/menuitem/InitializationCell"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "InitializationCell"->{
  Cell[2331, 73, 440, 12, 70, "Usage",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->19891],
  Cell[3286, 107, 187, 5, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->138],
  Cell[3476, 114, 590, 20, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->13310],
  Cell[4069, 136, 377, 10, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->20967],
  Cell[4449, 148, 569, 15, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->15055],
  Cell[5021, 165, 515, 14, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->13787]},
 "askIfInitNoteID"->{
  Cell[2331, 73, 440, 12, 70, "Usage",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->19891],
  Cell[3286, 107, 187, 5, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->138],
  Cell[3476, 114, 590, 20, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->13310],
  Cell[4069, 136, 377, 10, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->20967],
  Cell[4449, 148, 569, 15, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->15055],
  Cell[5021, 165, 515, 14, 70, "Notes",
   CellTags->{"InitializationCell", "askIfInitNoteID"},
   CellID->13787]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"InitializationCell", 8078, 261},
 {"askIfInitNoteID", 8787, 280}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1492, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2115, 64, 213, 7, 70, "ObjectName",
 CellID->100170434],
Cell[2331, 73, 440, 12, 70, "Usage",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->19891]
}, Open  ]],
Cell[CellGroupData[{
Cell[2808, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3286, 107, 187, 5, 70, "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->138],
Cell[3476, 114, 590, 20, 70, "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->13310],
Cell[4069, 136, 377, 10, 70, "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->20967],
Cell[4449, 148, 569, 15, 70, "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->15055],
Cell[5021, 165, 515, 14, 70, "Notes",
 CellTags->{"InitializationCell", "askIfInitNoteID"},
 CellID->13787]
}, Closed]],
Cell[CellGroupData[{
Cell[5573, 184, 310, 9, 70, "SeeAlsoSection",
 CellID->6648],
Cell[5886, 195, 415, 13, 70, "SeeAlso",
 CellID->183979256]
}, Open  ]],
Cell[CellGroupData[{
Cell[6338, 213, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[6660, 224, 157, 2, 70, "MoreAbout"],
Cell[6820, 228, 129, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6964, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

