(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6957,        236]
NotebookOptionsPosition[      4931,        170]
NotebookOutlinePosition[      6258,        210]
CellTagsIndexPosition[      6181,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stack Windows" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/StackWindows"], 
          "\"TileWindowsTall\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/TileWindowsTall"], "Tile Windows Wide" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/TileWindowsWide"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Stack Windows\"\>", 
       2->"\<\"\\\"TileWindowsTall\\\"\"\>", 
       3->"\<\"Tile Windows Wide\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Window Menu" :> 
          Documentation`HelpLookup["paclet:guide/WindowMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Window Menu\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Window ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Tile Windows Tall"
}], "ObjectName",
 CellID->265239903],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Tile Windows Tall", "MenuName"],
     "\[LineSeparator]arranges all windows to fit in the screen one beside \
the other (Windows and Macintosh only)."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"TileWindowsTall",
 CellID->28540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
With a large number of windows, there is some overlapping since windows \
cannot be made smaller than a certain minimum size.\
\>", "Notes",
 CellTags->"TileWindowsTall",
 CellID->13886]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->610],

Cell[TextData[{
 StyleBox[ButtonBox["Stack Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/StackWindows"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<TileWindowsTall\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/TileWindowsTall"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Tile Windows Wide",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TileWindowsWide"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->16842543]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Window Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowMenu"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Window > Tile Windows Tall - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 2.6619462}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Tile Windows Tall arranges all windows to fit in the screen one beside \
the other (Windows and Macintosh only).", "synonyms" -> {}, "title" -> 
    "Window > Tile Windows Tall", "type" -> "Menu Item", "uri" -> 
    "ref/menuitem/TileWindowsTall"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TileWindowsTall"->{
  Cell[2222, 70, 420, 12, 70, "Usage",
   CellTags->"TileWindowsTall",
   CellID->28540],
  Cell[3157, 104, 196, 5, 70, "Notes",
   CellTags->"TileWindowsTall",
   CellID->13886]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TileWindowsTall", 5977, 195}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1457, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2080, 63, 139, 5, 70, "ObjectName",
 CellID->265239903],
Cell[2222, 70, 420, 12, 70, "Usage",
 CellTags->"TileWindowsTall",
 CellID->28540]
}, Open  ]],
Cell[CellGroupData[{
Cell[2679, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3157, 104, 196, 5, 70, "Notes",
 CellTags->"TileWindowsTall",
 CellID->13886]
}, Closed]],
Cell[CellGroupData[{
Cell[3390, 114, 309, 9, 70, "SeeAlsoSection",
 CellID->610],
Cell[3702, 125, 715, 22, 70, "SeeAlso",
 CellID->16842543]
}, Open  ]],
Cell[CellGroupData[{
Cell[4454, 152, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[4776, 163, 113, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[4904, 168, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

