(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10173,        390]
NotebookOptionsPosition[      5726,        245]
NotebookOutlinePosition[      8051,        315]
CellTagsIndexPosition[      7927,        309]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["$IterationLimit::itlim", "ObjectName",
 CellID->26069],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of `1` exceeded.\"\>"}]], "Message", "MSG",
 CellID->8068848],

Cell["\<\
Generated when the number of iterative evaluations of  an expression exceeds \
the indicated limit.\
\>", "Notes",
 CellID->16910],

Cell[TextData[{
 "The limit on  the number of iterative evaluations of an expression is \
determined by the  value of ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19521],

Cell[TextData[{
 "If your calculation requires a large number of  iterative evaluations, you \
can set the value of ",
 Cell[BoxData[
  ButtonBox["$IterationLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IterationLimit"]], "InlineFormula"],
 " to a large positive integer or to ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30323],

Cell[TextData[{
 "This message is sometimes caused by syntax errors,  such as misplaced \
\[OpenCurlyDoubleQuote]",
 StyleBox["=", "MR"],
 "\[CloseCurlyDoubleQuote] signs."
}], "Notes",
 CellID->31210]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->365610718],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->388188946],

Cell[TextData[{
 "With this rule for ",
 StyleBox["f[p_]", "MR"],
 ", evaluation of ",
 StyleBox["f[p-1]", "MR"],
 " will lead to infinite iteration."
}], "ExampleText",
 CellID->155443876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "p_", "]"}], "=", " ", 
  RowBox[{"f", "[", 
   RowBox[{"p", "-", "1"}], "]"}]}]], "Input",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"In[1]:=",
 CellID->5622],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(4096\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellTags->"$IterationLimit::itlim",
 CellID->154082929],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "4095"}], "+", "p"}], ")"}]}], "]"}], "]"}]], "Output",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"Out[1]=",
 CellID->742592060]
}, Open  ]],

Cell[TextData[{
 "Clear the rule for ",
 StyleBox["f[p_]", "MR"],
 "."
}], "ExampleText",
 CellID->193002762],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"In[2]:=",
 CellID->24303],

Cell["\<\
A termination rule can be added so that the iteration will stop.\
\>", "ExampleText",
 CellID->256735590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "p_Integer", "]"}], "=", 
  RowBox[{"f", "[", 
   RowBox[{"p", "-", "1"}], "]"}]}]], "Input",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"In[3]:=",
 CellID->14085],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "+", "p"}], "]"}]], "Output",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"Out[3]=",
 CellID->2263700]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "0", "]"}], "=", "1"}]], "Input",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"In[4]:=",
 CellID->26000],

Cell[BoxData["1"], "Output",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"Out[4]=",
 CellID->118951855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"In[5]:=",
 CellID->718865085],

Cell[BoxData["1"], "Output",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"Out[5]=",
 CellID->196214664]
}, Open  ]],

Cell[TextData[{
 "Clear the rules for ",
 StyleBox["f", "MR"],
 "."
}], "ExampleText",
 CellID->244517557],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellTags->"$IterationLimit::itlim",
 CellLabel->"In[6]:=",
 CellID->9401]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$IterationLimit::itlim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 22, 3.3893998}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "$IterationLimit::itlim", "synonyms" -> {}, "title" -> 
    "$IterationLimit::itlim", "type" -> "Message", "uri" -> 
    "ref/message/itlim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2560, 99, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->365610718]},
 "$IterationLimit::itlim"->{
  Cell[3310, 131, 210, 7, 70, "Input",
   CellTags->"$IterationLimit::itlim",
   CellID->5622],
  Cell[3523, 140, 224, 6, 70, "Message",
   CellTags->"$IterationLimit::itlim",
   CellID->154082929],
  Cell[3750, 148, 286, 10, 70, "Output",
   CellTags->"$IterationLimit::itlim",
   CellID->742592060],
  Cell[4163, 168, 134, 4, 70, "Input",
   CellTags->"$IterationLimit::itlim",
   CellID->24303],
  Cell[4440, 181, 213, 7, 70, "Input",
   CellTags->"$IterationLimit::itlim",
   CellID->14085],
  Cell[4656, 190, 175, 6, 70, "Output",
   CellTags->"$IterationLimit::itlim",
   CellID->2263700],
  Cell[4868, 201, 153, 5, 70, "Input",
   CellTags->"$IterationLimit::itlim",
   CellID->26000],
  Cell[5024, 208, 108, 3, 70, "Output",
   CellTags->"$IterationLimit::itlim",
   CellID->118951855],
  Cell[5169, 216, 135, 4, 70, "Input",
   CellTags->"$IterationLimit::itlim",
   CellID->718865085],
  Cell[5307, 222, 108, 3, 70, "Output",
   CellTags->"$IterationLimit::itlim",
   CellID->196214664],
  Cell[5539, 235, 133, 4, 70, "Input",
   CellTags->"$IterationLimit::itlim",
   CellID->9401]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6661, 268},
 {"$IterationLimit::itlim", 6809, 272}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 60, 1, 70, "ObjectName",
 CellID->26069],
Cell[CellGroupData[{
Cell[788, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1266, 49, 173, 4, 70, "Message",
 CellID->8068848],
Cell[1442, 55, 140, 4, 70, "Notes",
 CellID->16910],
Cell[1585, 61, 287, 9, 70, "Notes",
 CellID->19521],
Cell[1875, 72, 444, 14, 70, "Notes",
 CellID->30323],
Cell[2322, 88, 201, 6, 70, "Notes",
 CellID->31210]
}, Closed]],
Cell[CellGroupData[{
Cell[2560, 99, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->365610718],
Cell[CellGroupData[{
Cell[2945, 113, 148, 5, 70, "ExampleSection",
 CellID->388188946],
Cell[3096, 120, 189, 7, 70, "ExampleText",
 CellID->155443876],
Cell[CellGroupData[{
Cell[3310, 131, 210, 7, 70, "Input",
 CellTags->"$IterationLimit::itlim",
 CellID->5622],
Cell[3523, 140, 224, 6, 70, "Message",
 CellTags->"$IterationLimit::itlim",
 CellID->154082929],
Cell[3750, 148, 286, 10, 70, "Output",
 CellTags->"$IterationLimit::itlim",
 CellID->742592060]
}, Open  ]],
Cell[4051, 161, 109, 5, 70, "ExampleText",
 CellID->193002762],
Cell[4163, 168, 134, 4, 70, "Input",
 CellTags->"$IterationLimit::itlim",
 CellID->24303],
Cell[4300, 174, 115, 3, 70, "ExampleText",
 CellID->256735590],
Cell[CellGroupData[{
Cell[4440, 181, 213, 7, 70, "Input",
 CellTags->"$IterationLimit::itlim",
 CellID->14085],
Cell[4656, 190, 175, 6, 70, "Output",
 CellTags->"$IterationLimit::itlim",
 CellID->2263700]
}, Open  ]],
Cell[CellGroupData[{
Cell[4868, 201, 153, 5, 70, "Input",
 CellTags->"$IterationLimit::itlim",
 CellID->26000],
Cell[5024, 208, 108, 3, 70, "Output",
 CellTags->"$IterationLimit::itlim",
 CellID->118951855]
}, Open  ]],
Cell[CellGroupData[{
Cell[5169, 216, 135, 4, 70, "Input",
 CellTags->"$IterationLimit::itlim",
 CellID->718865085],
Cell[5307, 222, 108, 3, 70, "Output",
 CellTags->"$IterationLimit::itlim",
 CellID->196214664]
}, Open  ]],
Cell[5430, 228, 106, 5, 70, "ExampleText",
 CellID->244517557],
Cell[5539, 235, 133, 4, 70, "Input",
 CellTags->"$IterationLimit::itlim",
 CellID->9401]
}, Open  ]]
}, Open  ]],
Cell[5699, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

