(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7325,        262]
NotebookOptionsPosition[      4429,        167]
NotebookOutlinePosition[      6131,        219]
CellTagsIndexPosition[      6010,        213]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["$MaxPrecision::prec", "ObjectName",
 CellID->15907],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"$MaxPrecision", "::", "\<\"prec\"\>"}], ":", 
  " ", "\<\"In increasing internal precision while attempting to evaluate \
`1`, the limit $MaxPrecision = `2` was reached. Increasing the value of \
$MaxPrecision may help resolve the uncertainty.\"\>"}]], "Message", "MSG",
 CellID->373405274],

Cell[TextData[{
 "Generated when internal calculations use precision  greater than the value \
of ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15393]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->176420018],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->48421284],

Cell[TextData[{
 "An error occurs in this example because the precision needed in the  \
numerical evaluation exceeds the value of ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->33297573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxPrecision", "=", "30"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "50", "]"}], ",", "30"}], "]"}]}], "]"}]], "Input",
 CellTags->"$MaxPrecision::prec",
 CellLabel->"In[1]:=",
 CellID->14779],

Cell[BoxData[
 RowBox[{
  RowBox[{"$MaxPrecision", "::", "\<\"prec\"\>"}], ":", 
  " ", "\<\"In increasing internal precision while attempting to evaluate \\!\
\\(\[ExponentialE]\\^50\\), the limit $MaxPrecision = \\!\\(30.`\\) was \
reached. Increasing the value of $MaxPrecision may help resolve the \
uncertainty.\"\>"}]], "Message", "MSG",
 CellTags->"$MaxPrecision::prec",
 CellID->6975090],

Cell[BoxData["5.1847055285870724640874533229334853848218`28.*^21"], "Output",
 CellTags->"$MaxPrecision::prec",
 CellLabel->"Out[1]=",
 CellID->321008004]
}, Open  ]],

Cell[TextData[{
 "This message can be avoided by raising the value of ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->254250993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxPrecision", "=", "40"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "50", "]"}], ",", "30"}], "]"}]}], "]"}]], "Input",
 CellTags->"$MaxPrecision::prec",
 CellLabel->"In[2]:=",
 CellID->17810],

Cell[BoxData["5.1847055285870724640874533229334853848275`30.*^21"], "Output",
 CellTags->"$MaxPrecision::prec",
 CellLabel->"Out[2]=",
 CellID->772336149]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MaxPrecision::prec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 22, 11.1864744}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "$MaxPrecision::prec", "synonyms" -> {}, "title" -> 
    "$MaxPrecision::prec", "type" -> "Message", "uri" -> 
    "ref/message/prec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1891, 71, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->176420018]},
 "$MaxPrecision::prec"->{
  Cell[2756, 105, 305, 10, 70, "Input",
   CellTags->"$MaxPrecision::prec",
   CellID->14779],
  Cell[3064, 117, 395, 8, 70, "Message",
   CellTags->"$MaxPrecision::prec",
   CellID->6975090],
  Cell[3462, 127, 154, 3, 70, "Output",
   CellTags->"$MaxPrecision::prec",
   CellID->321008004],
  Cell[3901, 145, 305, 10, 70, "Input",
   CellTags->"$MaxPrecision::prec",
   CellID->17810],
  Cell[4209, 157, 154, 3, 70, "Output",
   CellTags->"$MaxPrecision::prec",
   CellID->772336149]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5355, 190},
 {"$MaxPrecision::prec", 5500, 194}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 57, 1, 70, "ObjectName",
 CellID->15907],
Cell[CellGroupData[{
Cell[785, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1263, 49, 325, 6, 70, "Message",
 CellID->373405274],
Cell[1591, 57, 263, 9, 70, "Notes",
 CellID->15393]
}, Closed]],
Cell[CellGroupData[{
Cell[1891, 71, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->176420018],
Cell[CellGroupData[{
Cell[2276, 85, 147, 5, 70, "ExampleSection",
 CellID->48421284],
Cell[2426, 92, 305, 9, 70, "ExampleText",
 CellID->33297573],
Cell[CellGroupData[{
Cell[2756, 105, 305, 10, 70, "Input",
 CellTags->"$MaxPrecision::prec",
 CellID->14779],
Cell[3064, 117, 395, 8, 70, "Message",
 CellTags->"$MaxPrecision::prec",
 CellID->6975090],
Cell[3462, 127, 154, 3, 70, "Output",
 CellTags->"$MaxPrecision::prec",
 CellID->321008004]
}, Open  ]],
Cell[3631, 133, 245, 8, 70, "ExampleText",
 CellID->254250993],
Cell[CellGroupData[{
Cell[3901, 145, 305, 10, 70, "Input",
 CellTags->"$MaxPrecision::prec",
 CellID->17810],
Cell[4209, 157, 154, 3, 70, "Output",
 CellTags->"$MaxPrecision::prec",
 CellID->772336149]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4402, 165, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

