(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8446,        319]
NotebookOptionsPosition[      4709,        198]
NotebookOutlinePosition[      6749,        259]
CellTagsIndexPosition[      6624,        253]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["$RecursionLimit::reclim", "ObjectName",
 CellID->7307],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of `1` exceeded.\"\>"}]], "Message", "MSG",
 CellID->246847941],

Cell["\<\
Generated when an evaluation exceeds the indicated  number of recursive \
evaluations.\
\>", "Notes",
 CellID->2995],

Cell[TextData[{
 "The limit on the  number of levels of recursion that will be used in \
evaluating an expression  is given by the value of ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15208],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " can be set to a large value or to ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " for calculations that require many levels of recursion."
}], "Notes",
 CellID->5330]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62358819],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->471916964],

Cell[TextData[{
 "If ",
 StyleBox["var", "MR"],
 " does not have a value, evaluation of this assignment will generate  \
infinite recursion."
}], "ExampleText",
 CellID->184813104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"var", "=", 
  RowBox[{"var", "+", "1"}]}]], "Input",
 CellTags->"$RecursionLimit::reclim",
 CellLabel->"In[1]:=",
 CellID->7258],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded.\"\>"}]], "Message", \
"MSG",
 CellTags->"$RecursionLimit::reclim",
 CellID->46838879],

Cell[BoxData[
 RowBox[{"255", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "var"}], "]"}]}]], "Output",
 CellTags->"$RecursionLimit::reclim",
 CellLabel->"Out[1]=",
 CellID->293328300]
}, Open  ]],

Cell[TextData[{
 "If ",
 StyleBox["var", "MR"],
 " has a value, the same assignment does not lead to infinite recursion."
}], "ExampleText",
 CellID->179200377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"var", "=", "17"}]], "Input",
 CellTags->"$RecursionLimit::reclim",
 CellLabel->"In[2]:=",
 CellID->8900],

Cell[BoxData["17"], "Output",
 CellTags->"$RecursionLimit::reclim",
 CellLabel->"Out[2]=",
 CellID->693611628]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"var", "=", 
  RowBox[{"var", "+", "1"}]}]], "Input",
 CellTags->"$RecursionLimit::reclim",
 CellLabel->"In[3]:=",
 CellID->1882],

Cell[BoxData["18"], "Output",
 CellTags->"$RecursionLimit::reclim",
 CellLabel->"Out[3]=",
 CellID->1390013]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["var", "MR"],
 "."
}], "ExampleText",
 CellID->607192522],

Cell[BoxData[
 RowBox[{"Clear", "[", "var", "]"}]], "Input",
 CellTags->"$RecursionLimit::reclim",
 CellLabel->"In[4]:=",
 CellID->848242637]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$RecursionLimit::reclim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 22, 26.3274870}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "$RecursionLimit::reclim", "synonyms" -> {}, "title" -> 
    "$RecursionLimit::reclim", "type" -> "Message", "uri" -> 
    "ref/message/reclim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2336, 90, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62358819]},
 "$RecursionLimit::reclim"->{
  Cell[3076, 121, 152, 5, 70, "Input",
   CellTags->"$RecursionLimit::reclim",
   CellID->7258],
  Cell[3231, 128, 224, 6, 70, "Message",
   CellTags->"$RecursionLimit::reclim",
   CellID->46838879],
  Cell[3458, 136, 190, 6, 70, "Output",
   CellTags->"$RecursionLimit::reclim",
   CellID->293328300],
  Cell[3848, 154, 128, 4, 70, "Input",
   CellTags->"$RecursionLimit::reclim",
   CellID->8900],
  Cell[3979, 160, 110, 3, 70, "Output",
   CellTags->"$RecursionLimit::reclim",
   CellID->693611628],
  Cell[4126, 168, 152, 5, 70, "Input",
   CellTags->"$RecursionLimit::reclim",
   CellID->1882],
  Cell[4281, 175, 108, 3, 70, "Output",
   CellTags->"$RecursionLimit::reclim",
   CellID->1390013],
  Cell[4514, 188, 141, 4, 70, "Input",
   CellTags->"$RecursionLimit::reclim",
   CellID->848242637]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5649, 221},
 {"$RecursionLimit::reclim", 5797, 225}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 60, 1, 70, "ObjectName",
 CellID->7307],
Cell[CellGroupData[{
Cell[788, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1266, 49, 176, 4, 70, "Message",
 CellID->246847941],
Cell[1445, 55, 126, 4, 70, "Notes",
 CellID->2995],
Cell[1574, 61, 309, 9, 70, "Notes",
 CellID->15208],
Cell[1886, 72, 413, 13, 70, "Notes",
 CellID->5330]
}, Closed]],
Cell[CellGroupData[{
Cell[2336, 90, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62358819],
Cell[CellGroupData[{
Cell[2720, 104, 148, 5, 70, "ExampleSection",
 CellID->471916964],
Cell[2871, 111, 180, 6, 70, "ExampleText",
 CellID->184813104],
Cell[CellGroupData[{
Cell[3076, 121, 152, 5, 70, "Input",
 CellTags->"$RecursionLimit::reclim",
 CellID->7258],
Cell[3231, 128, 224, 6, 70, "Message",
 CellTags->"$RecursionLimit::reclim",
 CellID->46838879],
Cell[3458, 136, 190, 6, 70, "Output",
 CellTags->"$RecursionLimit::reclim",
 CellID->293328300]
}, Open  ]],
Cell[3663, 145, 160, 5, 70, "ExampleText",
 CellID->179200377],
Cell[CellGroupData[{
Cell[3848, 154, 128, 4, 70, "Input",
 CellTags->"$RecursionLimit::reclim",
 CellID->8900],
Cell[3979, 160, 110, 3, 70, "Output",
 CellTags->"$RecursionLimit::reclim",
 CellID->693611628]
}, Open  ]],
Cell[CellGroupData[{
Cell[4126, 168, 152, 5, 70, "Input",
 CellTags->"$RecursionLimit::reclim",
 CellID->1882],
Cell[4281, 175, 108, 3, 70, "Output",
 CellTags->"$RecursionLimit::reclim",
 CellID->1390013]
}, Open  ]],
Cell[4404, 181, 107, 5, 70, "ExampleText",
 CellID->607192522],
Cell[4514, 188, 141, 4, 70, "Input",
 CellTags->"$RecursionLimit::reclim",
 CellID->848242637]
}, Open  ]]
}, Open  ]],
Cell[4682, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

