(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13249,        454]
NotebookOptionsPosition[      7447,        285]
NotebookOutlinePosition[     11087,        384]
CellTagsIndexPosition[     10933,        377]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Array::plen
StringReplacePart::plen\
\>", "ObjectName",
 CellID->3893],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"plen\"\>"}], ":", 
  " ", "\<\"`1` and `2` should have the same length.\"\>"}]], "Message", \
"MSG",
 CellID->190026959],

Cell[TextData[{
 "Generated when the length of the second argument in ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 " is not the same as the length of the third argument."
}], "Notes",
 CellID->10220],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 " is used for multiple replacements and the number of replacement strings \
is",
 " ",
 "not the same as the number of position specifications."
}], "Notes",
 CellID->3717],

Cell[TextData[{
 "The second argument in ",
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 " gives the replacement strings and the third argument gives the position \
specifications."
}], "Notes",
 CellID->6093]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159885545],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->97028710],

Cell["\<\
An error occurs in this example because the second and third arguments do not \
have the same length.\
\>", "ExampleText",
 CellID->10405382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"List", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellLabel->"In[1]:=",
 CellID->16316],

Cell[BoxData[
 RowBox[{
  RowBox[{"Array", "::", "\<\"plen\"\>"}], ":", 
  " ", "\<\"\\!\\({2}\\) and \\!\\({2, 3}\\) should have the same \
length.\"\>"}]], "Message", "MSG",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->186045029],

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"List", ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Output",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellLabel->"Out[1]=",
 CellID->425525501]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->220313240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{"List", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellLabel->"In[2]:=",
 CellID->20784],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellLabel->"Out[2]=",
 CellID->413675319]
}, Open  ]],

Cell["\<\
An error occurs in this example because the length of the second argument is \
not the same as the length of the third argument.\
\>", "ExampleText",
 CellID->226960025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<123456789\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellLabel->"In[3]:=",
 CellID->28484],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringReplacePart", "::", "\<\"plen\"\>"}], ":", 
  " ", "\<\"\\!\\({\\\"x\\\", \\\"y\\\", \\\"z\\\"}\\) and \\!\\({\\(\\({1, \
2}\\)\\), \\(\\({4, 5}\\)\\)}\\) should have the same length.\"\>"}]], \
"Message", "MSG",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->11986289],

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\<\"123456789\"\>", ",", 
   RowBox[{"{", 
    RowBox[{"\<\"x\"\>", ",", "\<\"y\"\>", ",", "\<\"z\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}]}], "}"}]}], "]"}]], "Output",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellLabel->"Out[3]=",
 CellID->182570492]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments for multiple string replacements using ",
 Cell[BoxData[
  ButtonBox["StringReplacePart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringReplacePart"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->467279620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplacePart", "[", 
  RowBox[{"\"\<123456789\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<x\>\"", ",", "\"\<y\>\"", ",", "\"\<z\>\""}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "7"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellLabel->"In[4]:=",
 CellID->14560],

Cell[BoxData["\<\"x3y6z89\"\>"], "Output",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellLabel->"Out[4]=",
 CellID->81052761]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Array::plen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 26.7250622}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Array::plen StringReplacePart::plen", "synonyms" -> {}, 
    "title" -> "Array::plen", "type" -> "Message", "uri" -> 
    "ref/message/plen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2448, 97, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->159885545]},
 "Array::plen"->{
  Cell[3159, 126, 261, 8, 70, "Input",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->16316],
  Cell[3423, 136, 250, 6, 70, "Message",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->186045029],
  Cell[3676, 144, 266, 8, 70, "Output",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->425525501],
  Cell[4189, 167, 286, 9, 70, "Input",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->20784],
  Cell[4478, 178, 481, 17, 70, "Output",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->413675319],
  Cell[5178, 206, 451, 13, 70, "Input",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->28484],
  Cell[5632, 221, 327, 7, 70, "Message",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->11986289],
  Cell[5962, 230, 456, 13, 70, "Output",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->182570492],
  Cell[6725, 258, 514, 15, 70, "Input",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->14560],
  Cell[7242, 275, 139, 3, 70, "Output",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->81052761]},
 "StringReplacePart::plen"->{
  Cell[3159, 126, 261, 8, 70, "Input",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->16316],
  Cell[3423, 136, 250, 6, 70, "Message",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->186045029],
  Cell[3676, 144, 266, 8, 70, "Output",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->425525501],
  Cell[4189, 167, 286, 9, 70, "Input",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->20784],
  Cell[4478, 178, 481, 17, 70, "Output",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->413675319],
  Cell[5178, 206, 451, 13, 70, "Input",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->28484],
  Cell[5632, 221, 327, 7, 70, "Message",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->11986289],
  Cell[5962, 230, 456, 13, 70, "Output",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->182570492],
  Cell[6725, 258, 514, 15, 70, "Input",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->14560],
  Cell[7242, 275, 139, 3, 70, "Output",
   CellTags->{"Array::plen", "StringReplacePart::plen"},
   CellID->81052761]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8373, 308},
 {"Array::plen", 8510, 312},
 {"StringReplacePart::plen", 9725, 343}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 80, 4, 70, "ObjectName",
 CellID->3893],
Cell[CellGroupData[{
Cell[808, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1286, 52, 197, 6, 70, "Message",
 CellID->190026959],
Cell[1486, 60, 271, 8, 70, "Notes",
 CellID->10220],
Cell[1760, 70, 346, 11, 70, "Notes",
 CellID->3717],
Cell[2109, 83, 302, 9, 70, "Notes",
 CellID->6093]
}, Closed]],
Cell[CellGroupData[{
Cell[2448, 97, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159885545],
Cell[CellGroupData[{
Cell[2833, 111, 147, 5, 70, "ExampleSection",
 CellID->97028710],
Cell[2983, 118, 151, 4, 70, "ExampleText",
 CellID->10405382],
Cell[CellGroupData[{
Cell[3159, 126, 261, 8, 70, "Input",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->16316],
Cell[3423, 136, 250, 6, 70, "Message",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->186045029],
Cell[3676, 144, 266, 8, 70, "Output",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->425525501]
}, Open  ]],
Cell[3957, 155, 207, 8, 70, "ExampleText",
 CellID->220313240],
Cell[CellGroupData[{
Cell[4189, 167, 286, 9, 70, "Input",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->20784],
Cell[4478, 178, 481, 17, 70, "Output",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->413675319]
}, Open  ]],
Cell[4974, 198, 179, 4, 70, "ExampleText",
 CellID->226960025],
Cell[CellGroupData[{
Cell[5178, 206, 451, 13, 70, "Input",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->28484],
Cell[5632, 221, 327, 7, 70, "Message",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->11986289],
Cell[5962, 230, 456, 13, 70, "Output",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->182570492]
}, Open  ]],
Cell[6433, 246, 267, 8, 70, "ExampleText",
 CellID->467279620],
Cell[CellGroupData[{
Cell[6725, 258, 514, 15, 70, "Input",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->14560],
Cell[7242, 275, 139, 3, 70, "Output",
 CellTags->{"Array::plen", "StringReplacePart::plen"},
 CellID->81052761]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7420, 283, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

