(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9163,        349]
NotebookOptionsPosition[      5771,        234]
NotebookOutlinePosition[      7621,        292]
CellTagsIndexPosition[      7505,        286]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
BaseForm::basf
IntegerString::basf\
\>", "ObjectName",
 CellID->3520],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"basf\"\>"}], ":", 
  " ", "\<\"Requested base `1` should be an integer between 2 and \
`2`.\"\>"}]], "Message", "MSG",
 CellID->495716045],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " does not fall within the required range."
}], "Notes",
 CellID->13861],

Cell["\<\
The maximum value of the second argument is determined by the number of \
characters available to represent digits. Usually this maximum is 36. \
\>", "Notes",
 CellID->13693],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 " may be helpful for bases outside of this range."
}], "Notes",
 CellID->14522]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->293950856],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->363392015],

Cell[TextData[{
 "An error occurs in this example because the second argument in ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " is not an integer in the required range."
}], "ExampleText",
 CellID->24357303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"3.14159", ",", " ", "41"}], "]"}]], "Input",
 CellTags->"BaseForm::basf",
 CellLabel->"In[1]:=",
 CellID->4324],

Cell[BoxData[
 RowBox[{
  RowBox[{"BaseForm", "::", "\<\"basf\"\>"}], ":", 
  " ", "\<\"Requested base \\!\\(\\\"41\\\"\\) should be an integer between 2 \
and \\!\\(\\\"36\\\"\\).\"\>"}]], "Message", "MSG",
 CellTags->"BaseForm::basf",
 CellID->69846756],

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"3.14159`", ",", "41"}], "]"}]], "Output",
 CellTags->"BaseForm::basf",
 CellLabel->"Out[1]//BaseForm=",
 CellID->85593910]
}, Open  ]],

Cell[TextData[{
 "This shows a typical use of ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->187153503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3.14159", ",", " ", "1.414", ",", " ", "2.718"}], "}"}], ",", 
   "2"}], "]"}]], "Input",
 CellTags->"BaseForm::basf",
 CellLabel->"In[2]:=",
 CellID->3292],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     SubscriptBox["\<\"11.001001000011111101\"\>", "2"],
     3.14159,
     AutoDelete->True], ",", 
    InterpretationBox[
     SubscriptBox["\<\"1.0110100111111011111\"\>", "2"],
     1.414,
     AutoDelete->True], ",", 
    InterpretationBox[
     SubscriptBox["\<\"10.101101111100111011\"\>", "2"],
     2.718,
     AutoDelete->True]}], "}"}],
  BaseForm[#, 2]& ]], "Output",
 CellTags->"BaseForm::basf",
 CellLabel->"Out[2]//BaseForm=",
 CellID->6776038]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["RealDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealDigits"]], "InlineFormula"],
 " to get the digits in a base outside of the range used by ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->523178518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"3.14159", ",", "41"}], "]"}]], "Input",
 CellTags->"BaseForm::basf",
 CellLabel->"In[3]:=",
 CellID->27639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "3", ",", "5", ",", "33", ",", "0", ",", "21", ",", "20", ",", "20", ",", 
     "19", ",", "33", ",", "10"}], "}"}], ",", "1"}], "}"}]], "Output",
 CellTags->"BaseForm::basf",
 CellLabel->"Out[3]=",
 CellID->175231949]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BaseForm::basf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 42.2410844}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "BaseForm::basf IntegerString::basf", "synonyms" -> {}, 
    "title" -> "BaseForm::basf", "type" -> "Message", "uri" -> 
    "ref/message/basf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2359, 94, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->293950856]},
 "BaseForm::basf"->{
  Cell[3205, 127, 163, 5, 70, "Input",
   CellTags->"BaseForm::basf",
   CellID->4324],
  Cell[3371, 134, 255, 6, 70, "Message",
   CellTags->"BaseForm::basf",
   CellID->69846756],
  Cell[3629, 142, 174, 5, 70, "Output",
   CellTags->"BaseForm::basf",
   CellID->85593910],
  Cell[4054, 162, 238, 8, 70, "Input",
   CellTags->"BaseForm::basf",
   CellID->3292],
  Cell[4295, 172, 533, 19, 70, "Output",
   CellTags->"BaseForm::basf",
   CellID->6776038],
  Cell[5249, 211, 161, 5, 70, "Input",
   CellTags->"BaseForm::basf",
   CellID->27639],
  Cell[5413, 218, 292, 9, 70, "Output",
   CellTags->"BaseForm::basf",
   CellID->175231949]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6702, 257},
 {"BaseForm::basf", 6842, 261}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 79, 4, 70, "ObjectName",
 CellID->3520],
Cell[CellGroupData[{
Cell[807, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1285, 52, 215, 6, 70, "Message",
 CellID->495716045],
Cell[1503, 60, 251, 8, 70, "Notes",
 CellID->13861],
Cell[1757, 70, 185, 4, 70, "Notes",
 CellID->13693],
Cell[1945, 76, 377, 13, 70, "Notes",
 CellID->14522]
}, Closed]],
Cell[CellGroupData[{
Cell[2359, 94, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->293950856],
Cell[CellGroupData[{
Cell[2744, 108, 148, 5, 70, "ExampleSection",
 CellID->363392015],
Cell[2895, 115, 285, 8, 70, "ExampleText",
 CellID->24357303],
Cell[CellGroupData[{
Cell[3205, 127, 163, 5, 70, "Input",
 CellTags->"BaseForm::basf",
 CellID->4324],
Cell[3371, 134, 255, 6, 70, "Message",
 CellTags->"BaseForm::basf",
 CellID->69846756],
Cell[3629, 142, 174, 5, 70, "Output",
 CellTags->"BaseForm::basf",
 CellID->85593910]
}, Open  ]],
Cell[3818, 150, 211, 8, 70, "ExampleText",
 CellID->187153503],
Cell[CellGroupData[{
Cell[4054, 162, 238, 8, 70, "Input",
 CellTags->"BaseForm::basf",
 CellID->3292],
Cell[4295, 172, 533, 19, 70, "Output",
 CellTags->"BaseForm::basf",
 CellID->6776038]
}, Open  ]],
Cell[4843, 194, 381, 13, 70, "ExampleText",
 CellID->523178518],
Cell[CellGroupData[{
Cell[5249, 211, 161, 5, 70, "Input",
 CellTags->"BaseForm::basf",
 CellID->27639],
Cell[5413, 218, 292, 9, 70, "Output",
 CellTags->"BaseForm::basf",
 CellID->175231949]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5744, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

