(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8014,        282]
NotebookOptionsPosition[      4990,        185]
NotebookOutlinePosition[      6743,        237]
CellTagsIndexPosition[      6617,        231]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["CellularAutomaton::kspec", "ObjectName",
 CellID->24349],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"CellularAutomaton", "::", "\<\"kspec\"\>"}], ":", 
  " ", "\<\"Since position 1 of rule specification `1` is not a function or \
rule list, position 2 (if present) must be of the form k, {k, 1}, or {k, wts} \
where k is a machine integer > 1 and wts is a nonempty array of non-negative \
machine integers.\"\>"}]], "Message", "MSG",
 CellID->7832961],

Cell[TextData[{
 "Generated when the color specification in ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " does not have the indicated form."
}], "Notes",
 CellID->14479],

Cell[TextData[{
 "The color",
 " ",
 "specification is the second element in the first argument of ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20549]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->147502746],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->99330221],

Cell["\<\
An error is generated in this example because 0 is not a valid color \
specification.\
\>", "ExampleText",
 CellID->561484068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellTags->"CellularAutomaton::kspec",
 CellLabel->"In[1]:=",
 CellID->31086],

Cell[BoxData[
 RowBox[{
  RowBox[{"CellularAutomaton", "::", "\<\"kspec\"\>"}], ":", 
  " ", "\<\"Since position 1 of rule specification \\!\\({1, 0}\\) is not a \
function or rule list, position 2 (if present) must be of the form k, {k, 1}, \
or {k, wts} where k is a machine integer > 1 and wts is a nonempty array of \
non-negative machine integers.\"\>"}]], "Message", "MSG",
 CellTags->"CellularAutomaton::kspec",
 CellID->54585759],

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", "5"}], "]"}]], "Output",
 CellTags->"CellularAutomaton::kspec",
 CellLabel->"Out[1]=",
 CellID->105776559]
}, Open  ]],

Cell["This input shows a valid color specification.", "ExampleText",
 CellID->88290509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellTags->"CellularAutomaton::kspec",
 CellLabel->"In[2]:=",
 CellID->14055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 CellTags->"CellularAutomaton::kspec",
 CellLabel->"Out[2]=",
 CellID->392790094]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellularAutomaton::kspec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 58.6165036}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "CellularAutomaton::kspec", "synonyms" -> {}, "title" -> 
    "CellularAutomaton::kspec", "type" -> "Message", "uri" -> 
    "ref/message/kspec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2234, 83, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->147502746]},
 "CellularAutomaton::kspec"->{
  Cell[2930, 112, 289, 9, 70, "Input",
   CellTags->"CellularAutomaton::kspec",
   CellID->31086],
  Cell[3222, 123, 437, 8, 70, "Message",
   CellTags->"CellularAutomaton::kspec",
   CellID->54585759],
  Cell[3662, 133, 294, 9, 70, "Output",
   CellTags->"CellularAutomaton::kspec",
   CellID->105776559],
  Cell[4083, 150, 289, 9, 70, "Input",
   CellTags->"CellularAutomaton::kspec",
   CellID->14055],
  Cell[4375, 161, 549, 17, 70, "Output",
   CellTags->"CellularAutomaton::kspec",
   CellID->392790094]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5932, 208},
 {"CellularAutomaton::kspec", 6082, 212}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 62, 1, 70, "ObjectName",
 CellID->24349],
Cell[CellGroupData[{
Cell[790, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1268, 49, 385, 7, 70, "Message",
 CellID->7832961],
Cell[1656, 58, 266, 8, 70, "Notes",
 CellID->14479],
Cell[1925, 68, 272, 10, 70, "Notes",
 CellID->20549]
}, Closed]],
Cell[CellGroupData[{
Cell[2234, 83, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->147502746],
Cell[CellGroupData[{
Cell[2619, 97, 147, 5, 70, "ExampleSection",
 CellID->99330221],
Cell[2769, 104, 136, 4, 70, "ExampleText",
 CellID->561484068],
Cell[CellGroupData[{
Cell[2930, 112, 289, 9, 70, "Input",
 CellTags->"CellularAutomaton::kspec",
 CellID->31086],
Cell[3222, 123, 437, 8, 70, "Message",
 CellTags->"CellularAutomaton::kspec",
 CellID->54585759],
Cell[3662, 133, 294, 9, 70, "Output",
 CellTags->"CellularAutomaton::kspec",
 CellID->105776559]
}, Open  ]],
Cell[3971, 145, 87, 1, 70, "ExampleText",
 CellID->88290509],
Cell[CellGroupData[{
Cell[4083, 150, 289, 9, 70, "Input",
 CellTags->"CellularAutomaton::kspec",
 CellID->14055],
Cell[4375, 161, 549, 17, 70, "Output",
 CellTags->"CellularAutomaton::kspec",
 CellID->392790094]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4963, 183, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

