(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8653,        323]
NotebookOptionsPosition[      5119,        207]
NotebookOutlinePosition[      7095,        267]
CellTagsIndexPosition[      6975,        261]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["ClebschGordan::tri", "ObjectName",
 CellID->3678],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"tri\"\>"}], ":", 
  " ", "\<\"`1` is not triangular.\"\>"}]], "Message", "MSG",
 CellID->183126436],

Cell[TextData[{
 "Generated when the arguments in ",
 Cell[BoxData[
  ButtonBox["ClebschGordan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClebschGordan"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ThreeJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["SixJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SixJSymbol"]], "InlineFormula"],
 " fail to satisfy the required triangle inequality."
}], "Notes",
 CellID->9810]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15499809],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->614660473],

Cell["\<\
An error occurs in this example because the indicated decomposition is not \
possible.\
\>", "ExampleText",
 CellID->17910660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"ClebschGordan::tri",
 CellLabel->"In[1]:=",
 CellID->7399],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"tri\"\>"}], ":", 
  " ", "\<\"\\!\\(ThreeJSymbol[\\(\\(\\(\\({1, 0}\\)\\), \\(\\({2, 0}\\)\\), \
\\(\\({4, 0}\\)\\)\\)\\)]\\) is not triangular.\"\>"}]], "Message", "MSG",
 CellTags->"ClebschGordan::tri",
 CellID->6018811],

Cell[BoxData["0"], "Output",
 CellTags->"ClebschGordan::tri",
 CellLabel->"Out[1]=",
 CellID->404490042]
}, Open  ]],

Cell["This shows a physically valid Clebsch-Gordan coefficient.", \
"ExampleText",
 CellID->55479732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellTags->"ClebschGordan::tri",
 CellLabel->"In[2]:=",
 CellID->100214673],

Cell[BoxData[
 SqrtBox[
  FractionBox["3", "5"]]], "Output",
 CellTags->"ClebschGordan::tri",
 CellLabel->"Out[2]=",
 CellID->638290213]
}, Open  ]],

Cell[TextData[{
 "A similar error can also occur for ",
 Cell[BoxData[
  ButtonBox["ThreeJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["SixJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SixJSymbol"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->221785183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SixJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellTags->"ClebschGordan::tri",
 CellLabel->"In[3]:=",
 CellID->6700],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"tri\"\>"}], ":", 
  " ", "\<\"\\!\\(SixJSymbol[\\(\\(\\(\\({1, 1, 1}\\)\\), \\(\\({2, 5, \
5}\\)\\)\\)\\)]\\) is not triangular.\"\>"}]], "Message", "MSG",
 CellTags->"ClebschGordan::tri",
 CellID->96558911],

Cell[BoxData["0"], "Output",
 CellTags->"ClebschGordan::tri",
 CellLabel->"Out[3]=",
 CellID->995902935]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClebschGordan::tri - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 23.2265086}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "ClebschGordan::tri", "synonyms" -> {}, "title" -> 
    "ClebschGordan::tri", "type" -> "Message", "uri" -> "ref/message/tri"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1992, 78, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15499809]},
 "ClebschGordan::tri"->{
  Cell[2688, 107, 317, 11, 70, "Input",
   CellTags->"ClebschGordan::tri",
   CellID->7399],
  Cell[3008, 120, 284, 6, 70, "Message",
   CellTags->"ClebschGordan::tri",
   CellID->6018811],
  Cell[3295, 128, 104, 3, 70, "Output",
   CellTags->"ClebschGordan::tri",
   CellID->404490042],
  Cell[3540, 140, 322, 11, 70, "Input",
   CellTags->"ClebschGordan::tri",
   CellID->100214673],
  Cell[3865, 153, 136, 5, 70, "Output",
   CellTags->"ClebschGordan::tri",
   CellID->638290213],
  Cell[4399, 178, 275, 9, 70, "Input",
   CellTags->"ClebschGordan::tri",
   CellID->6700],
  Cell[4677, 189, 269, 6, 70, "Message",
   CellTags->"ClebschGordan::tri",
   CellID->96558911],
  Cell[4949, 197, 104, 3, 70, "Output",
   CellTags->"ClebschGordan::tri",
   CellID->995902935]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6036, 229},
 {"ClebschGordan::tri", 6179, 233}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 55, 1, 70, "ObjectName",
 CellID->3678],
Cell[CellGroupData[{
Cell[783, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1261, 49, 161, 4, 70, "Message",
 CellID->183126436],
Cell[1425, 55, 530, 18, 70, "Notes",
 CellID->9810]
}, Closed]],
Cell[CellGroupData[{
Cell[1992, 78, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15499809],
Cell[CellGroupData[{
Cell[2376, 92, 148, 5, 70, "ExampleSection",
 CellID->614660473],
Cell[2527, 99, 136, 4, 70, "ExampleText",
 CellID->17910660],
Cell[CellGroupData[{
Cell[2688, 107, 317, 11, 70, "Input",
 CellTags->"ClebschGordan::tri",
 CellID->7399],
Cell[3008, 120, 284, 6, 70, "Message",
 CellTags->"ClebschGordan::tri",
 CellID->6018811],
Cell[3295, 128, 104, 3, 70, "Output",
 CellTags->"ClebschGordan::tri",
 CellID->404490042]
}, Open  ]],
Cell[3414, 134, 101, 2, 70, "ExampleText",
 CellID->55479732],
Cell[CellGroupData[{
Cell[3540, 140, 322, 11, 70, "Input",
 CellTags->"ClebschGordan::tri",
 CellID->100214673],
Cell[3865, 153, 136, 5, 70, "Output",
 CellTags->"ClebschGordan::tri",
 CellID->638290213]
}, Open  ]],
Cell[4016, 161, 358, 13, 70, "ExampleText",
 CellID->221785183],
Cell[CellGroupData[{
Cell[4399, 178, 275, 9, 70, "Input",
 CellTags->"ClebschGordan::tri",
 CellID->6700],
Cell[4677, 189, 269, 6, 70, "Message",
 CellTags->"ClebschGordan::tri",
 CellID->96558911],
Cell[4949, 197, 104, 3, 70, "Output",
 CellTags->"ClebschGordan::tri",
 CellID->995902935]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5092, 205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

