(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9245,        327]
NotebookOptionsPosition[      5128,        204]
NotebookOutlinePosition[      7790,        279]
CellTagsIndexPosition[      7639,        272]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Coefficient::numv
Exponent::numv\
\>", "ObjectName",
 CellID->29825],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"numv\"\>"}], ":", 
  " ", "\<\"`1` takes exactly one variable.\"\>"}]], "Message", "MSG",
 CellID->189180766],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 " is used with more than one variable."
}], "Notes",
 CellID->31662],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["Coefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Coefficient"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 " have the ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " attribute by default, this message is typically seen only if the ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " attribute has been cleared or is not used."
}], "Notes",
 CellID->23409]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->157461347],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->224906315],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["Exponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exponent"]], "InlineFormula"],
 " is used with more than one variable."
}], "ExampleText",
 CellID->943119318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellLabel->"In[1]:=",
 CellID->14843],

Cell[BoxData[
 RowBox[{
  RowBox[{"Thread", "::", "\<\"tdlen\"\>"}], ":", 
  " ", "\<\"Objects of unequal length in \
\\!\\(Exponent[\\(\\(\\(\\({x}\\)\\), \\(\\({x, y}\\)\\)\\)\\)]\\) cannot be \
combined.\"\>"}]], "Message", "MSG",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellID->451893700],

Cell[BoxData[
 RowBox[{
  RowBox[{"Exponent", "::", "\<\"numv\"\>"}], ":", 
  " ", "\<\"\\!\\(Exponent\\) takes exactly one variable.\"\>"}]], "Message", \
"MSG",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellID->660971920],

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellLabel->"Out[1]=",
 CellID->88243356]
}, Open  ]],

Cell["\<\
If the arguments have the same length, they are threaded together, so only \
one variable is used at a time.\
\>", "ExampleText",
 CellID->737845565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Exponent", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellLabel->"In[2]:=",
 CellID->32556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellLabel->"Out[2]=",
 CellID->395112423]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Coefficient::numv - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 30.5235704}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Coefficient::numv Exponent::numv", "synonyms" -> {}, 
    "title" -> "Coefficient::numv", "type" -> "Message", "uri" -> 
    "ref/message/numv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2551, 102, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->157461347]},
 "Coefficient::numv"->{
  Cell[3371, 135, 248, 8, 70, "Input",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->14843],
  Cell[3622, 145, 305, 7, 70, "Message",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->451893700],
  Cell[3930, 154, 234, 6, 70, "Message",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->660971920],
  Cell[4167, 162, 252, 8, 70, "Output",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->88243356],
  Cell[4618, 181, 273, 9, 70, "Input",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->32556],
  Cell[4894, 192, 168, 5, 70, "Output",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->395112423]},
 "Exponent::numv"->{
  Cell[3371, 135, 248, 8, 70, "Input",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->14843],
  Cell[3622, 145, 305, 7, 70, "Message",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->451893700],
  Cell[3930, 154, 234, 6, 70, "Message",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->660971920],
  Cell[4167, 162, 252, 8, 70, "Output",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->88243356],
  Cell[4618, 181, 273, 9, 70, "Input",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->32556],
  Cell[4894, 192, 168, 5, 70, "Output",
   CellTags->{"Coefficient::numv", "Exponent::numv"},
   CellID->395112423]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6063, 227},
 {"Coefficient::numv", 6207, 231},
 {"Exponent::numv", 6922, 250}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 78, 4, 70, "ObjectName",
 CellID->29825],
Cell[CellGroupData[{
Cell[806, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1284, 52, 186, 5, 70, "Message",
 CellID->189180766],
Cell[1473, 59, 358, 13, 70, "Notes",
 CellID->31662],
Cell[1834, 74, 680, 23, 70, "Notes",
 CellID->23409]
}, Closed]],
Cell[CellGroupData[{
Cell[2551, 102, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->157461347],
Cell[CellGroupData[{
Cell[2936, 116, 148, 5, 70, "ExampleSection",
 CellID->224906315],
Cell[3087, 123, 259, 8, 70, "ExampleText",
 CellID->943119318],
Cell[CellGroupData[{
Cell[3371, 135, 248, 8, 70, "Input",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellID->14843],
Cell[3622, 145, 305, 7, 70, "Message",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellID->451893700],
Cell[3930, 154, 234, 6, 70, "Message",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellID->660971920],
Cell[4167, 162, 252, 8, 70, "Output",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellID->88243356]
}, Open  ]],
Cell[4434, 173, 159, 4, 70, "ExampleText",
 CellID->737845565],
Cell[CellGroupData[{
Cell[4618, 181, 273, 9, 70, "Input",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellID->32556],
Cell[4894, 192, 168, 5, 70, "Output",
 CellTags->{"Coefficient::numv", "Exponent::numv"},
 CellID->395112423]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5101, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

