(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6262,        228]
NotebookOptionsPosition[      3865,        148]
NotebookOutlinePosition[      5313,        193]
CellTagsIndexPosition[      5199,        187]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cif", "ObjectName",
 CellID->2171],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cif\"\>"}], ":", 
  " ", "\<\"The types of the two results in `1` are incompatible because \
their ranks are different. Evaluation will use the uncompiled \
function.\"\>"}]], "Message", "MSG",
 CellID->376795880],

Cell["\<\
Generated when the tensor rank of a result in an expression to be compiled \
could have two different values.\
\>", "Notes",
 CellID->28567],

Cell["\<\
An expression can be compiled only if the type of the result is known and is \
always the same.\
\>", "Notes",
 CellID->3293]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163947188],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->784074333],

Cell["\<\
An error occurs in this example because the tensor rank of the result can \
have two different values depending on the values of the arguments.\
\>", "ExampleText",
 CellID->248975674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "_Real", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "_Real", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"True", "|", "False"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"If", "[", 
    RowBox[{"t", ",", "x", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellTags->"Compile::cif",
 CellLabel->"In[1]:=",
 CellID->15247],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cif\"\>"}], ":", 
  " ", "\<\"The types of the two results in \\!\\(If[\\(\\(t, x, y\\)\\)]\\) \
are incompatible because their ranks are different. Evaluation will use the \
uncompiled function.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cif",
 CellID->292871259],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "t"}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{"t", ",", "x", ",", "y"}], "]"}], 
    ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cif",
 CellLabel->"Out[1]=",
 CellID->44394001]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cif - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 54.3991816}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cif", "synonyms" -> {}, "title" -> "Compile::cif", 
    "type" -> "Message", "uri" -> "ref/message/cif"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1852, 72, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->163947188]},
 "Compile::cif"->{
  Cell[2607, 101, 495, 16, 70, "Input",
   CellTags->"Compile::cif",
   CellID->15247],
  Cell[3105, 119, 325, 7, 70, "Message",
   CellTags->"Compile::cif",
   CellID->292871259],
  Cell[3433, 128, 366, 13, 70, "Output",
   CellTags->"Compile::cif",
   CellID->44394001]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4764, 170},
 {"Compile::cif", 4902, 174}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->2171],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 269, 6, 70, "Message",
 CellID->376795880],
Cell[1527, 57, 150, 4, 70, "Notes",
 CellID->28567],
Cell[1680, 63, 135, 4, 70, "Notes",
 CellID->3293]
}, Closed]],
Cell[CellGroupData[{
Cell[1852, 72, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->163947188],
Cell[CellGroupData[{
Cell[2237, 86, 148, 5, 70, "ExampleSection",
 CellID->784074333],
Cell[2388, 93, 194, 4, 70, "ExampleText",
 CellID->248975674],
Cell[CellGroupData[{
Cell[2607, 101, 495, 16, 70, "Input",
 CellTags->"Compile::cif",
 CellID->15247],
Cell[3105, 119, 325, 7, 70, "Message",
 CellTags->"Compile::cif",
 CellID->292871259],
Cell[3433, 128, 366, 13, 70, "Output",
 CellTags->"Compile::cif",
 CellID->44394001]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3838, 146, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

