(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8177,        299]
NotebookOptionsPosition[      5337,        205]
NotebookOutlinePosition[      6999,        256]
CellTagsIndexPosition[      6882,        250]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cpdsts", "ObjectName",
 CellID->15203],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cpdsts\"\>"}], ":", 
  " ", "\<\"Compile cannot determine the rank of the result of `1`; \
evaluation will use the uncompiled function.\"\>"}]], "Message", "MSG",
 CellID->153575971],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " is unable to determine the rank of a result from ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18075]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->256448593],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4691399],

Cell[TextData[{
 "An error occurs in this example because the rank of the result from ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " cannot be determined without knowing the length of the second argument."
}], "ExampleText",
 CellID->130384340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", "_Integer", ",", "1"}], "}"}], "}"}]}], "]"}]], "Input",\

 CellTags->"Compile::cpdsts",
 CellLabel->"In[1]:=",
 CellID->25269],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cpdsts\"\>"}], ":", 
  " ", "\<\"Compile cannot determine the rank of the result of \
\\!\\(Partition[\\(\\(\\(\\({1, 2, 3, 4}\\)\\), x\\)\\)]\\); evaluation will \
use the uncompiled function.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cpdsts",
 CellID->891597322],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "x"}], "]"}], 
    ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cpdsts",
 CellLabel->"Out[1]=",
 CellID->35391935]
}, Open  ]],

Cell[TextData[{
 "Compilation proceeds without error if the rank of the result from ",
 Cell[BoxData[
  ButtonBox["Partition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Partition"]], "InlineFormula"],
 " can be determined from the form of the arguments."
}], "ExampleText",
 CellID->595073117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n1", ",", "n2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n1", ",", "_Integer"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n2", ",", "_Integer"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellTags->"Compile::cpdsts",
 CellLabel->"In[2]:=",
 CellID->28226],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"n1", ",", "n2"}], "}"}]}], "]"}], 
    ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cpdsts",
 CellLabel->"Out[2]=",
 CellID->127812531]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cpdsts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 54.8679436}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cpdsts", "synonyms" -> {}, "title" -> 
    "Compile::cpdsts", "type" -> "Message", "uri" -> "ref/message/cpdsts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1899, 74, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->256448593]},
 "Compile::cpdsts"->{
  Cell[2782, 107, 414, 15, 70, "Input",
   CellTags->"Compile::cpdsts",
   CellID->25269],
  Cell[3199, 124, 326, 7, 70, "Message",
   CellTags->"Compile::cpdsts",
   CellID->891597322],
  Cell[3528, 133, 400, 14, 70, "Output",
   CellTags->"Compile::cpdsts",
   CellID->35391935],
  Cell[4268, 162, 542, 18, 70, "Input",
   CellTags->"Compile::cpdsts",
   CellID->28226],
  Cell[4813, 182, 458, 16, 70, "Output",
   CellTags->"Compile::cpdsts",
   CellID->127812531]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6248, 227},
 {"Compile::cpdsts", 6389, 231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->15203],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 238, 5, 70, "Message",
 CellID->153575971],
Cell[1500, 56, 362, 13, 70, "Notes",
 CellID->18075]
}, Closed]],
Cell[CellGroupData[{
Cell[1899, 74, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->256448593],
Cell[CellGroupData[{
Cell[2284, 88, 146, 5, 70, "ExampleSection",
 CellID->4691399],
Cell[2433, 95, 324, 8, 70, "ExampleText",
 CellID->130384340],
Cell[CellGroupData[{
Cell[2782, 107, 414, 15, 70, "Input",
 CellTags->"Compile::cpdsts",
 CellID->25269],
Cell[3199, 124, 326, 7, 70, "Message",
 CellTags->"Compile::cpdsts",
 CellID->891597322],
Cell[3528, 133, 400, 14, 70, "Output",
 CellTags->"Compile::cpdsts",
 CellID->35391935]
}, Open  ]],
Cell[3943, 150, 300, 8, 70, "ExampleText",
 CellID->595073117],
Cell[CellGroupData[{
Cell[4268, 162, 542, 18, 70, "Input",
 CellTags->"Compile::cpdsts",
 CellID->28226],
Cell[4813, 182, 458, 16, 70, "Output",
 CellTags->"Compile::cpdsts",
 CellID->127812531]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5310, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

