(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7319,        275]
NotebookOptionsPosition[      4430,        179]
NotebookOutlinePosition[      6090,        230]
CellTagsIndexPosition[      5973,        224]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cpiter", "ObjectName",
 CellID->21342],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cpiter\"\>"}], ":", 
  " ", "\<\"Iterator at position `1` of `2` cannot be compiled; evaluation \
will use the uncompiled function.\"\>"}]], "Message", "MSG",
 CellID->1238606],

Cell["\<\
Generated when the indicated expression does not have the form of an \
iterator.\
\>", "Notes",
 CellID->28714],

Cell[TextData[{
 "An iterator is a list that gives the number of iterations, or the iteration \
variable and the range of iteration, in functions such as ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20444]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->175143486],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->318342898],

Cell["\<\
An error occurs in this example because an integer is not a valid iteration \
specification.\
\>", "ExampleText",
 CellID->231858226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", "5"}], "]"}]}], "]"}]], "Input",
 CellTags->"Compile::cpiter",
 CellLabel->"In[1]:=",
 CellID->4365],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cpiter\"\>"}], ":", 
  " ", "\<\"Iterator at position \\!\\(2\\) of \\!\\(Table[\\(\\(0, \
5\\)\\)]\\) cannot be compiled; evaluation will use the uncompiled \
function.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cpiter",
 CellID->271043245],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", "5"}], "]"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cpiter",
 CellLabel->"Out[1]=",
 CellID->751719998]
}, Open  ]],

Cell["This shows a valid iteration specification.", "ExampleText",
 CellID->392083187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], "]"}]], "Input",
 CellTags->"Compile::cpiter",
 CellLabel->"In[2]:=",
 CellID->31108],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{"0", ",", 
      RowBox[{"{", "5", "}"}]}], "]"}], ",", "\<\"-CompiledCode-\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cpiter",
 CellLabel->"Out[2]=",
 CellID->143344883]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cpiter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 55.4148326}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cpiter", "synonyms" -> {}, "title" -> 
    "Compile::cpiter", "type" -> "Message", "uri" -> "ref/message/cpiter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2075, 81, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->175143486]},
 "Compile::cpiter"->{
  Cell[2779, 110, 228, 8, 70, "Input",
   CellTags->"Compile::cpiter",
   CellID->4365],
  Cell[3010, 120, 302, 7, 70, "Message",
   CellTags->"Compile::cpiter",
   CellID->271043245],
  Cell[3315, 129, 317, 11, 70, "Output",
   CellTags->"Compile::cpiter",
   CellID->751719998],
  Cell[3758, 148, 255, 9, 70, "Input",
   CellTags->"Compile::cpiter",
   CellID->31108],
  Cell[4016, 159, 348, 13, 70, "Output",
   CellTags->"Compile::cpiter",
   CellID->143344883]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5341, 201},
 {"Compile::cpiter", 5482, 205}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->21342],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 232, 5, 70, "Message",
 CellID->1238606],
Cell[1494, 56, 121, 4, 70, "Notes",
 CellID->28714],
Cell[1618, 62, 420, 14, 70, "Notes",
 CellID->20444]
}, Closed]],
Cell[CellGroupData[{
Cell[2075, 81, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->175143486],
Cell[CellGroupData[{
Cell[2460, 95, 148, 5, 70, "ExampleSection",
 CellID->318342898],
Cell[2611, 102, 143, 4, 70, "ExampleText",
 CellID->231858226],
Cell[CellGroupData[{
Cell[2779, 110, 228, 8, 70, "Input",
 CellTags->"Compile::cpiter",
 CellID->4365],
Cell[3010, 120, 302, 7, 70, "Message",
 CellTags->"Compile::cpiter",
 CellID->271043245],
Cell[3315, 129, 317, 11, 70, "Output",
 CellTags->"Compile::cpiter",
 CellID->751719998]
}, Open  ]],
Cell[3647, 143, 86, 1, 70, "ExampleText",
 CellID->392083187],
Cell[CellGroupData[{
Cell[3758, 148, 255, 9, 70, "Input",
 CellTags->"Compile::cpiter",
 CellID->31108],
Cell[4016, 159, 348, 13, 70, "Output",
 CellTags->"Compile::cpiter",
 CellID->143344883]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4403, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

