(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9115,        336]
NotebookOptionsPosition[      6174,        238]
NotebookOutlinePosition[      7833,        289]
CellTagsIndexPosition[      7716,        283]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cprank", "ObjectName",
 CellID->1273],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cprank\"\>"}], ":", 
  " ", "\<\"Compile cannot determine the rank of the result tensor. The \
length of `1` in `2` is unknown at compiling time; evaluation will use the \
uncompiled function.\"\>"}]], "Message", "MSG",
 CellID->394656620],

Cell["\<\
Generated when the rank of the indicated result cannot be determined.\
\>", "Notes",
 CellID->1614],

Cell["\<\
Compiled evaluation requires that the tensor rank of every expression be \
known.\
\>", "Notes",
 CellID->15044],

Cell[TextData[{
 "This message can be generated by compilation of ",
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32417]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14750075],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->501440158],

Cell[TextData[{
 "A warning is generated in this example because the rank of the result from \
",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " cannot be determined."
}], "ExampleText",
 CellID->71260055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Outer", "[", 
    RowBox[{"List", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "4", "}"}], ",", 
       RowBox[{"{", "5", "}"}]}], "}"}], ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"n", ",", "_Integer"}], "}"}], "}"}]}], "]"}]], "Input",
 CellTags->"Compile::cprank",
 CellLabel->"In[1]:=",
 CellID->17272],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cprank\"\>"}], ":", 
  " ", "\<\"Compile cannot determine the rank of the result tensor. The \
length of \\!\\(n\\) in \\!\\(Outer[\\(\\(List, \\(\\({\\(\\({1}\\)\\), \
\\(\\({2}\\)\\)}\\)\\), \\(\\({\\(\\({4}\\)\\), \\(\\({5}\\)\\)}\\)\\), \
n\\)\\)]\\) is unknown at compiling time; evaluation will use the uncompiled \
function.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cprank",
 CellID->167122026],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Outer", "[", 
     RowBox[{"List", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "4", "}"}], ",", 
        RowBox[{"{", "5", "}"}]}], "}"}], ",", "n"}], "]"}], 
    ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cprank",
 CellLabel->"Out[1]=",
 CellID->62675095]
}, Open  ]],

Cell[TextData[{
 "The warning is avoided if the arguments in ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " are given explicitly, so that the rank of the result can be determined."
}], "ExampleText",
 CellID->59961280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Outer", "[", 
    RowBox[{"List", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", "2", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "4", "}"}], ",", 
       RowBox[{"{", "5", "}"}]}], "}"}], ",", "1"}], "]"}]}], "]"}]], "Input",\

 CellTags->"Compile::cprank",
 CellLabel->"In[2]:=",
 CellID->1607],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Outer", "[", 
     RowBox[{"List", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", 
        RowBox[{"{", "2", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "4", "}"}], ",", 
        RowBox[{"{", "5", "}"}]}], "}"}], ",", "1"}], "]"}], 
    ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cprank",
 CellLabel->"Out[2]=",
 CellID->603927876]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cprank - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 2.6493928}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cprank", "synonyms" -> {}, "title" -> 
    "Compile::cprank", "type" -> "Message", "uri" -> "ref/message/cprank"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2297, 91, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14750075]},
 "Compile::cprank"->{
  Cell[3131, 125, 562, 19, 70, "Input",
   CellTags->"Compile::cprank",
   CellID->17272],
  Cell[3696, 146, 464, 9, 70, "Message",
   CellTags->"Compile::cprank",
   CellID->167122026],
  Cell[4163, 157, 570, 20, 70, "Output",
   CellTags->"Compile::cprank",
   CellID->62675095],
  Cell[5063, 192, 471, 17, 70, "Input",
   CellTags->"Compile::cprank",
   CellID->1607],
  Cell[5537, 211, 571, 20, 70, "Output",
   CellTags->"Compile::cprank",
   CellID->603927876]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7084, 260},
 {"Compile::cprank", 7224, 264}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->1273],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 295, 6, 70, "Message",
 CellID->394656620],
Cell[1556, 57, 109, 3, 70, "Notes",
 CellID->1614],
Cell[1668, 62, 122, 4, 70, "Notes",
 CellID->15044],
Cell[1793, 68, 467, 18, 70, "Notes",
 CellID->32417]
}, Closed]],
Cell[CellGroupData[{
Cell[2297, 91, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14750075],
Cell[CellGroupData[{
Cell[2681, 105, 148, 5, 70, "ExampleSection",
 CellID->501440158],
Cell[2832, 112, 274, 9, 70, "ExampleText",
 CellID->71260055],
Cell[CellGroupData[{
Cell[3131, 125, 562, 19, 70, "Input",
 CellTags->"Compile::cprank",
 CellID->17272],
Cell[3696, 146, 464, 9, 70, "Message",
 CellTags->"Compile::cprank",
 CellID->167122026],
Cell[4163, 157, 570, 20, 70, "Output",
 CellTags->"Compile::cprank",
 CellID->62675095]
}, Open  ]],
Cell[4748, 180, 290, 8, 70, "ExampleText",
 CellID->59961280],
Cell[CellGroupData[{
Cell[5063, 192, 471, 17, 70, "Input",
 CellTags->"Compile::cprank",
 CellID->1607],
Cell[5537, 211, 571, 20, 70, "Output",
 CellTags->"Compile::cprank",
 CellID->603927876]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6147, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

