(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7455,        276]
NotebookOptionsPosition[      4653,        182]
NotebookOutlinePosition[      6291,        233]
CellTagsIndexPosition[      6176,        227]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cret", "ObjectName",
 CellID->8801],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cret\"\>"}], ":", 
  " ", "\<\"The type of return values in `1` are different. Evaluation will \
use the uncompiled function.\"\>"}]], "Message", "MSG",
 CellID->4830518],

Cell["\<\
Generated when the possible return values for a compiled expression do not \
all have the same tensor rank.\
\>", "Notes",
 CellID->30090]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154331266],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->95697633],

Cell["\<\
A warning is generated in this example because the tensor rank of the return \
value will be different depending on the value of the argument.\
\>", "ExampleText",
 CellID->563114960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "p", "}"}], ",", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"p", ">", "0"}], ",", 
      RowBox[{"Return", "[", "1", "]"}]}], "]"}], ";", 
    RowBox[{"{", "2", "}"}]}]}], "]"}]], "Input",
 CellTags->"Compile::cret",
 CellLabel->"In[1]:=",
 CellID->19033],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cret\"\>"}], ":", 
  " ", "\<\"The type of return values in \\!\\(\\(\\(If[\\(\\(\\(\\(p > \
0\\)\\), \\(\\(Return[1]\\)\\)\\)\\)]\\)\\) ; \\(\\({2}\\)\\)\\) are \
different. Evaluation will use the uncompiled function.\"\>"}]], "Message", \
"MSG",
 CellTags->"Compile::cret",
 CellID->56550777],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"p", ">", "0"}], ",", 
       RowBox[{"Return", "[", "1", "]"}]}], "]"}], ";", 
     RowBox[{"{", "2", "}"}]}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cret",
 CellLabel->"Out[1]=",
 CellID->332007811]
}, Open  ]],

Cell["\<\
Compilation proceeds without difficulty if all of the return values have the \
same tensor rank.\
\>", "ExampleText",
 CellID->138339192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "p", "}"}], ",", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"p", ">", "0"}], ",", 
      RowBox[{"Return", "[", 
       RowBox[{"{", "1", "}"}], "]"}]}], "]"}], ";", 
    RowBox[{"{", "2", "}"}]}]}], "]"}]], "Input",
 CellTags->"Compile::cret",
 CellLabel->"In[2]:=",
 CellID->19633],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"p", ">", "0"}], ",", 
       RowBox[{"Return", "[", 
        RowBox[{"{", "1", "}"}], "]"}]}], "]"}], ";", 
     RowBox[{"{", "2", "}"}]}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cret",
 CellLabel->"Out[2]=",
 CellID->271687881]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cret - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 3.3212850}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cret", "synonyms" -> {}, "title" -> 
    "Compile::cret", "type" -> "Message", "uri" -> "ref/message/cret"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1670, 65, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->154331266]},
 "Compile::cret"->{
  Cell[2423, 94, 344, 12, 70, "Input",
   CellTags->"Compile::cret",
   CellID->19033],
  Cell[2770, 108, 351, 8, 70, "Message",
   CellTags->"Compile::cret",
   CellID->56550777],
  Cell[3124, 118, 436, 15, 70, "Output",
   CellTags->"Compile::cret",
   CellID->332007811],
  Cell[3747, 144, 372, 13, 70, "Input",
   CellTags->"Compile::cret",
   CellID->19633],
  Cell[4122, 159, 465, 16, 70, "Output",
   CellTags->"Compile::cret",
   CellID->271687881]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5555, 204},
 {"Compile::cret", 5694, 208}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->8801],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 226, 5, 70, "Message",
 CellID->4830518],
Cell[1485, 56, 148, 4, 70, "Notes",
 CellID->30090]
}, Closed]],
Cell[CellGroupData[{
Cell[1670, 65, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->154331266],
Cell[CellGroupData[{
Cell[2055, 79, 147, 5, 70, "ExampleSection",
 CellID->95697633],
Cell[2205, 86, 193, 4, 70, "ExampleText",
 CellID->563114960],
Cell[CellGroupData[{
Cell[2423, 94, 344, 12, 70, "Input",
 CellTags->"Compile::cret",
 CellID->19033],
Cell[2770, 108, 351, 8, 70, "Message",
 CellTags->"Compile::cret",
 CellID->56550777],
Cell[3124, 118, 436, 15, 70, "Output",
 CellTags->"Compile::cret",
 CellID->332007811]
}, Open  ]],
Cell[3575, 136, 147, 4, 70, "ExampleText",
 CellID->138339192],
Cell[CellGroupData[{
Cell[3747, 144, 372, 13, 70, "Input",
 CellTags->"Compile::cret",
 CellID->19633],
Cell[4122, 159, 465, 16, 70, "Output",
 CellTags->"Compile::cret",
 CellID->271687881]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4626, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

