(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8295,        323]
NotebookOptionsPosition[      5318,        223]
NotebookOutlinePosition[      6967,        274]
CellTagsIndexPosition[      6851,        268]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::ctyp2", "ObjectName",
 CellID->3871],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ctyp2\"\>"}], ":", 
  " ", "\<\"Invalid type or rank specification in `1`.\"\>"}]], "Message", \
"MSG",
 CellID->57247711],

Cell[TextData[{
 "Generated when the type specification for a parameter in ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " does not have the correct form."
}], "Notes",
 CellID->8805],

Cell[TextData[{
 "An explicit type specification should be a list of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 " giving the name ",
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 " and the type ",
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 " of the parameter, or a list of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 " which includes the tensor rank ",
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 " of the parameter if the parameter is a tensor."
}], "Notes",
 CellID->586],

Cell[TextData[{
 "The type of a parameter can be ",
 StyleBox["_Integer", "MR"],
 ", ",
 StyleBox["_Real", "MR"],
 ", ",
 StyleBox["_Complex", "MR"],
 ", or ",
 StyleBox["True|False", "MR"],
 "."
}], "Notes",
 CellID->23247],

Cell[TextData[{
 "Parameter type and rank specifications are listed in the first argument of \
",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5784]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->448591779],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->81563579],

Cell["\<\
An error occurs in this example because the parameter type specification does \
not match any of the required forms.\
\>", "ExampleText",
 CellID->464810971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"Length", "[", "p", "]"}]}], "]"}]], "Input",
 CellTags->"Compile::ctyp2",
 CellLabel->"In[1]:=",
 CellID->19227],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ctyp2\"\>"}], ":", 
  " ", "\<\"Invalid type or rank specification in \\!\\({p, 1}\\).\"\>"}]], \
"Message", "MSG",
 CellTags->"Compile::ctyp2",
 CellID->50687416],

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"Length", "[", "p", "]"}]}], "]"}]], "Output",
 CellTags->"Compile::ctyp2",
 CellLabel->"Out[1]=",
 CellID->331652325]
}, Open  ]],

Cell["\<\
If a parameter is a tensor, the type and the rank of the tensor must both be \
specified explicitly.\
\>", "ExampleText",
 CellID->65368758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"Length", "[", "p", "]"}]}], "]"}]], "Input",
 CellTags->"Compile::ctyp2",
 CellLabel->"In[2]:=",
 CellID->25069],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{"Length", "[", "p", "]"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  
  False,
  Editable->False]], "Output",
 CellTags->"Compile::ctyp2",
 CellLabel->"Out[2]=",
 CellID->427627308]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::ctyp2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 10.4152166}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::ctyp2", "synonyms" -> {}, "title" -> 
    "Compile::ctyp2", "type" -> "Message", "uri" -> "ref/message/ctyp2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3009, 126, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->448591779]},
 "Compile::ctyp2"->{
  Cell[3736, 155, 260, 9, 70, "Input",
   CellTags->"Compile::ctyp2",
   CellID->19227],
  Cell[3999, 166, 219, 6, 70, "Message",
   CellTags->"Compile::ctyp2",
   CellID->50687416],
  Cell[4221, 174, 265, 9, 70, "Output",
   CellTags->"Compile::ctyp2",
   CellID->331652325],
  Cell[4676, 194, 274, 9, 70, "Input",
   CellTags->"Compile::ctyp2",
   CellID->25069],
  Cell[4953, 205, 299, 11, 70, "Output",
   CellTags->"Compile::ctyp2",
   CellID->427627308]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6225, 245},
 {"Compile::ctyp2", 6366, 249}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->3871],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 178, 5, 70, "Message",
 CellID->57247711],
Cell[1438, 56, 258, 8, 70, "Notes",
 CellID->8805],
Cell[1699, 66, 796, 31, 70, "Notes",
 CellID->586],
Cell[2498, 99, 224, 11, 70, "Notes",
 CellID->23247],
Cell[2725, 112, 247, 9, 70, "Notes",
 CellID->5784]
}, Closed]],
Cell[CellGroupData[{
Cell[3009, 126, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->448591779],
Cell[CellGroupData[{
Cell[3394, 140, 147, 5, 70, "ExampleSection",
 CellID->81563579],
Cell[3544, 147, 167, 4, 70, "ExampleText",
 CellID->464810971],
Cell[CellGroupData[{
Cell[3736, 155, 260, 9, 70, "Input",
 CellTags->"Compile::ctyp2",
 CellID->19227],
Cell[3999, 166, 219, 6, 70, "Message",
 CellTags->"Compile::ctyp2",
 CellID->50687416],
Cell[4221, 174, 265, 9, 70, "Output",
 CellTags->"Compile::ctyp2",
 CellID->331652325]
}, Open  ]],
Cell[4501, 186, 150, 4, 70, "ExampleText",
 CellID->65368758],
Cell[CellGroupData[{
Cell[4676, 194, 274, 9, 70, "Input",
 CellTags->"Compile::ctyp2",
 CellID->25069],
Cell[4953, 205, 299, 11, 70, "Output",
 CellTags->"Compile::ctyp2",
 CellID->427627308]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5291, 221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

