(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8840,        340]
NotebookOptionsPosition[      5670,        234]
NotebookOutlinePosition[      7416,        288]
CellTagsIndexPosition[      7300,        282]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::ctyps", "ObjectName",
 CellID->26799],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ctyps\"\>"}], ":", 
  " ", "\<\"Invalid subexpression type specification `1`.\"\>"}]], "Message", \
"MSG",
 CellID->131079686],

Cell[TextData[{
 "Generated when the type or rank specification for a subexpression in ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " does not have a valid form."
}], "Notes",
 CellID->5707],

Cell[TextData[{
 "Type and rank specifications for subexpressions are listed in the third \
argument of ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21727],

Cell[TextData[{
 "A type specification for a subexpression should be a list of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 " giving the name ",
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 " and the type ",
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 " of the subexpression, or a list of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 " which includes the tensor rank ",
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 " of the subexpression if the subexpression is a tensor. "
}], "Notes",
 CellID->4669],

Cell[TextData[{
 "The type can be ",
 StyleBox["_Integer", "MR"],
 ", ",
 StyleBox["_Real", "MR"],
 ", ",
 StyleBox["_Complex", "MR"],
 ", or ",
 StyleBox["True|False", "MR"],
 "."
}], "Notes",
 CellID->13512]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->719776451],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->499067919],

Cell["\<\
An error occurs in this example because the subexpression type specification \
does not have a valid form.\
\>", "ExampleText",
 CellID->377934904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"p", " ", "q"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "_Real"}], "}"}]}], "]"}]], "Input",
 CellTags->"Compile::ctyps",
 CellLabel->"In[1]:=",
 CellID->3376],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ctyps\"\>"}], ":", 
  " ", "\<\"Invalid subexpression type specification \\!\\(q\\).\"\>"}]], \
"Message", "MSG",
 CellTags->"Compile::ctyps",
 CellID->175564486],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ctyps\"\>"}], ":", 
  " ", "\<\"Invalid subexpression type specification \\!\\(_Real\\).\"\>"}]], \
"Message", "MSG",
 CellTags->"Compile::ctyps",
 CellID->41834636],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{"p", " ", "q"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::ctyps",
 CellLabel->"Out[1]=",
 CellID->375520608]
}, Open  ]],

Cell["Subexpression type specifications should be given as lists.", \
"ExampleText",
 CellID->54306116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"p", " ", "q"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"q", ",", "_Real"}], "}"}], "}"}]}], "]"}]], "Input",
 CellTags->"Compile::ctyps",
 CellLabel->"In[2]:=",
 CellID->26441],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{"p", " ", "q"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::ctyps",
 CellLabel->"Out[2]=",
 CellID->210217371]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::ctyps - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 10.5558452}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::ctyps", "synonyms" -> {}, "title" -> 
    "Compile::ctyps", "type" -> "Message", "uri" -> "ref/message/ctyps"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3041, 126, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->719776451]},
 "Compile::ctyps"->{
  Cell[3759, 155, 326, 11, 70, "Input",
   CellTags->"Compile::ctyps",
   CellID->3376],
  Cell[4088, 168, 218, 6, 70, "Message",
   CellTags->"Compile::ctyps",
   CellID->175564486],
  Cell[4309, 176, 221, 6, 70, "Message",
   CellTags->"Compile::ctyps",
   CellID->41834636],
  Cell[4533, 184, 286, 10, 70, "Output",
   CellTags->"Compile::ctyps",
   CellID->375520608],
  Cell[4962, 203, 353, 12, 70, "Input",
   CellTags->"Compile::ctyps",
   CellID->26441],
  Cell[5318, 217, 286, 10, 70, "Output",
   CellTags->"Compile::ctyps",
   CellID->210217371]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6577, 256},
 {"Compile::ctyps", 6718, 260}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->26799],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 182, 5, 70, "Message",
 CellID->131079686],
Cell[1443, 56, 266, 8, 70, "Notes",
 CellID->5707],
Cell[1712, 66, 257, 9, 70, "Notes",
 CellID->21727],
Cell[1972, 77, 820, 31, 70, "Notes",
 CellID->4669],
Cell[2795, 110, 209, 11, 70, "Notes",
 CellID->13512]
}, Closed]],
Cell[CellGroupData[{
Cell[3041, 126, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->719776451],
Cell[CellGroupData[{
Cell[3426, 140, 148, 5, 70, "ExampleSection",
 CellID->499067919],
Cell[3577, 147, 157, 4, 70, "ExampleText",
 CellID->377934904],
Cell[CellGroupData[{
Cell[3759, 155, 326, 11, 70, "Input",
 CellTags->"Compile::ctyps",
 CellID->3376],
Cell[4088, 168, 218, 6, 70, "Message",
 CellTags->"Compile::ctyps",
 CellID->175564486],
Cell[4309, 176, 221, 6, 70, "Message",
 CellTags->"Compile::ctyps",
 CellID->41834636],
Cell[4533, 184, 286, 10, 70, "Output",
 CellTags->"Compile::ctyps",
 CellID->375520608]
}, Open  ]],
Cell[4834, 197, 103, 2, 70, "ExampleText",
 CellID->54306116],
Cell[CellGroupData[{
Cell[4962, 203, 353, 12, 70, "Input",
 CellTags->"Compile::ctyps",
 CellID->26441],
Cell[5318, 217, 286, 10, 70, "Output",
 CellTags->"Compile::ctyps",
 CellID->210217371]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5643, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

