(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7471,        272]
NotebookOptionsPosition[      4409,        171]
NotebookOutlinePosition[      6186,        226]
CellTagsIndexPosition[      6067,        220]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cxcoerce", "ObjectName",
 CellID->9439],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cxcoerce\"\>"}], ":", 
  " ", "\<\"Warning: compilation of `1` has coerced an exact number to an \
approximate complex number.\"\>"}]], "Message", "MSG",
 CellID->47572934],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " converts an exact number into an inexact complex number. "
}], "Notes",
 CellID->21242],

Cell["\<\
This message is used only if a special option for that purpose has been set.\
\>", "Notes",
 CellID->25687]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25983383],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->56903997],

Cell["\<\
A message about coercion is generated if the corresponding option has been \
set.\
\>", "ExampleText",
 CellID->15216239],

Cell[BoxData[
 RowBox[{
  RowBox[{"Developer`SetSystemOptions", "[", 
   RowBox[{"\"\<CompileOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<CompileReportCoercion\>\"", "\[Rule]", "True"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellTags->"Compile::cxcoerce",
 CellLabel->"In[1]:=",
 CellID->5915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"1", "+", "I"}]}], "]"}]], "Input",
 CellTags->"Compile::cxcoerce",
 CellLabel->"In[2]:=",
 CellID->17671],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"realcoerce\"\>"}], ":", 
  " ", "\<\"Warning: compilation of \\!\\(1 + \[ImaginaryI]\\) has coerced an \
exact number to an approximate real number.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cxcoerce",
 CellID->306580901],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cxcoerce\"\>"}], ":", 
  " ", "\<\"Warning: compilation of \\!\\(1 + \[ImaginaryI]\\) has coerced an \
exact number to an approximate complex number.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cxcoerce",
 CellID->11434659],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"1", "+", "\[ImaginaryI]"}], ",", "\<\"-CompiledCode-\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cxcoerce",
 CellLabel->"Out[2]=",
 CellID->409252382]
}, Open  ]],

Cell["Reset the option.", "ExampleText",
 CellID->30612295],

Cell[BoxData[
 RowBox[{
  RowBox[{"Developer`SetSystemOptions", "[", 
   RowBox[{"\"\<CompileOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<CompileReportCoercion\>\"", "\[Rule]", "False"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellTags->"Compile::cxcoerce",
 CellLabel->"In[3]:=",
 CellID->31048]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cxcoerce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 10.6808484}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cxcoerce", "synonyms" -> {}, "title" -> 
    "Compile::cxcoerce", "type" -> "Message", "uri" -> 
    "ref/message/cxcoerce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1891, 74, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25983383]},
 "Compile::cxcoerce"->{
  Cell[2559, 101, 310, 9, 70, "Input",
   CellTags->"Compile::cxcoerce",
   CellID->5915],
  Cell[2894, 114, 197, 7, 70, "Input",
   CellTags->"Compile::cxcoerce",
   CellID->17671],
  Cell[3094, 123, 283, 6, 70, "Message",
   CellTags->"Compile::cxcoerce",
   CellID->306580901],
  Cell[3380, 131, 283, 6, 70, "Message",
   CellTags->"Compile::cxcoerce",
   CellID->11434659],
  Cell[3666, 139, 300, 11, 70, "Output",
   CellTags->"Compile::cxcoerce",
   CellID->409252382],
  Cell[4043, 156, 312, 9, 70, "Input",
   CellTags->"Compile::cxcoerce",
   CellID->31048]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5333, 194},
 {"Compile::cxcoerce", 5475, 198}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 54, 1, 70, "ObjectName",
 CellID->9439],
Cell[CellGroupData[{
Cell[782, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1260, 49, 228, 5, 70, "Message",
 CellID->47572934],
Cell[1491, 56, 243, 8, 70, "Notes",
 CellID->21242],
Cell[1737, 66, 117, 3, 70, "Notes",
 CellID->25687]
}, Closed]],
Cell[CellGroupData[{
Cell[1891, 74, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25983383],
Cell[CellGroupData[{
Cell[2275, 88, 147, 5, 70, "ExampleSection",
 CellID->56903997],
Cell[2425, 95, 131, 4, 70, "ExampleText",
 CellID->15216239],
Cell[2559, 101, 310, 9, 70, "Input",
 CellTags->"Compile::cxcoerce",
 CellID->5915],
Cell[CellGroupData[{
Cell[2894, 114, 197, 7, 70, "Input",
 CellTags->"Compile::cxcoerce",
 CellID->17671],
Cell[3094, 123, 283, 6, 70, "Message",
 CellTags->"Compile::cxcoerce",
 CellID->306580901],
Cell[3380, 131, 283, 6, 70, "Message",
 CellTags->"Compile::cxcoerce",
 CellID->11434659],
Cell[3666, 139, 300, 11, 70, "Output",
 CellTags->"Compile::cxcoerce",
 CellID->409252382]
}, Open  ]],
Cell[3981, 153, 59, 1, 70, "ExampleText",
 CellID->30612295],
Cell[4043, 156, 312, 9, 70, "Input",
 CellTags->"Compile::cxcoerce",
 CellID->31048]
}, Open  ]]
}, Open  ]],
Cell[4382, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

