(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21025,        672]
NotebookOptionsPosition[     11126,        403]
NotebookOutlinePosition[     17641,        570]
CellTagsIndexPosition[     17433,        562]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
ConstrainedMax::cmcons
ConstrainedMin::cmcons\
\>", "ObjectName",
 CellID->27942],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"cmcons\"\>"}], ":", 
  " ", "\<\"`1` is not a list of valid equalities or inequalities.\"\>"}]], \
"Message", "MSG",
 CellID->297984621],

Cell[TextData[{
 "Generated when the indicated expression from the second argument in ",
 Cell[BoxData["ConstrainedMin"], "InlineFormula"],
 " or ",
 Cell[BoxData["ConstrainedMax"], "InlineFormula"],
 " is not an equation or inequality."
}], "Notes",
 CellID->12658],

Cell[TextData[{
 "Equations can be entered using the notation ",
 StyleBox["lhs", "TI"],
 StyleBox["==", "MR"],
 StyleBox["rhs", "TI"],
 ", and inequalities can be entered using ",
 StyleBox["lhs", "TI"],
 StyleBox["<", "MR"],
 StyleBox["rhs", "TI"],
 ", ",
 StyleBox["lhs", "TI"],
 StyleBox["<=", "MR"],
 StyleBox["rhs", "TI"],
 ", ",
 StyleBox["lhs", "TI"],
 StyleBox[">", "MR"],
 StyleBox["rhs", "TI"],
 ", and ",
 StyleBox["lhs", "TI"],
 StyleBox[">=", "MR"],
 StyleBox["rhs", "TI"],
 "."
}], "Notes",
 CellID->13927],

Cell[TextData[{
 "The notation ",
 StyleBox["lhs", "TI"],
 StyleBox["=", "MR"],
 StyleBox["rhs", "TI"],
 " is used for assignments rather than for equations. Evaluation of this \
input will attempt to assign a value to ",
 StyleBox["lhs", "TI"],
 "."
}], "Notes",
 CellID->5565]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85789216],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27327243],

Cell["\<\
An error occurs in this example because one of the elements in the second \
argument is not an equation or inequality.\
\>", "ExampleText",
 CellID->304627805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstrainedMax", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "<", "5"}], ",", " ", 
     RowBox[{"y", "===", "1"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"In[1]:=",
 CellID->26549],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstrainedMax", "::", "\<\"deprec\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"ConstrainedMax\\\"\\) is deprecated and will not be \
supported in future versions of Mathematica.  Use \\!\\(\\\"NMaximize or \
Maximize\\\"\\) instead.\"\>"}]], "Message", "MSG",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->3698280],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstrainedMax", "::", "\<\"cmcons\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(\\(x < 5\\)\\), False}\\) is not a list of valid \
equalities or inequalities.\"\>"}]], "Message", "MSG",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->180281223],

Cell[BoxData[
 RowBox[{"ConstrainedMax", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "<", "5"}], ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"Out[1]=",
 CellID->577288909]
}, Open  ]],

Cell[TextData[{
 "This shows valid input to ",
 Cell[BoxData["ConstrainedMax"], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->618955917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstrainedMax", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "<", "5"}], ",", " ", 
     RowBox[{"y", "==", "1"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"In[2]:=",
 CellID->1609],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstrainedMax", "::", "\<\"deprec\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"ConstrainedMax\\\"\\) is deprecated and will not be \
supported in future versions of Mathematica.  Use \\!\\(\\\"NMaximize or \
Maximize\\\"\\) instead.\"\>"}]], "Message", "MSG",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->118817002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "5"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"Out[2]=",
 CellID->160248115]
}, Open  ]],

Cell[TextData[{
 "The notation ",
 StyleBox["lhs", "MR",
  FontSlant->"Italic"],
 StyleBox["=", "MR"],
 StyleBox["rhs", "MR",
  FontSlant->"Italic"],
 " is used for assignments rather than for equations. After this error, the",
 " ",
 "right-hand side of the expression may have been assigned a value."
}], "ExampleText",
 CellID->358800586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstrainedMax", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"var", "[", "1", "]"}], "+", 
    RowBox[{"var", "[", "2", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"var", "[", "1", "]"}], "<", "5"}], ",", " ", 
     RowBox[{
      RowBox[{"var", "[", "2", "]"}], "=", "1"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"var", "[", "1", "]"}], ",", 
     RowBox[{"var", "[", "2", "]"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"In[3]:=",
 CellID->26265],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstrainedMax", "::", "\<\"deprec\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"ConstrainedMax\\\"\\) is deprecated and will not be \
supported in future versions of Mathematica.  Use \\!\\(\\\"NMaximize or \
Maximize\\\"\\) instead.\"\>"}]], "Message", "MSG",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->49784914],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstrainedMax", "::", "\<\"cmcons\"\>"}], ":", 
  " ", "\<\"\\!\\({\\(\\(\\(\\(var[1]\\)\\) < 5\\)\\), 1}\\) is not a list of \
valid equalities or inequalities.\"\>"}]], "Message", "MSG",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->562891257],

Cell[BoxData[
 RowBox[{"ConstrainedMax", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"var", "[", "1", "]"}], "+", 
    RowBox[{"var", "[", "2", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"var", "[", "1", "]"}], "<", "5"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"var", "[", "1", "]"}], ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"Out[3]=",
 CellID->480191415]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "var"}]], "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"In[4]:=",
 CellID->20478],

Cell[CellGroupData[{

Cell["Cell$$140242`var", "Print", "PrintUsage",
 CellTags->{
  "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
   "Info3381652559-8439340"},
 CellID->216649439],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"var", "[", "2", "]"}], "=", "1"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["var"],
  Editable->False]], "Print",
 CellTags->{
  "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
   "Info3381652559-8439340"},
 CellID->198792845]
}, Open  ]]
}, Open  ]],

Cell["\<\
The value that was assigned by mistake must be cleared before this input will \
behave as intended.\
\>", "ExampleText",
 CellID->70381011],

Cell[BoxData[
 RowBox[{"Clear", "[", "var", "]"}]], "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"In[5]:=",
 CellID->5548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstrainedMax", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"var", "[", "1", "]"}], "+", 
    RowBox[{"var", "[", "2", "]"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"var", "[", "1", "]"}], "<", "5"}], ",", " ", 
     RowBox[{
      RowBox[{"var", "[", "2", "]"}], "==", "1"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"var", "[", "1", "]"}], ",", 
     RowBox[{"var", "[", "2", "]"}]}], "}"}]}], "]"}]], "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"In[6]:=",
 CellID->6564],

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstrainedMax", "::", "\<\"deprec\"\>"}], ":", 
  " ", "\<\"\\!\\(\\\"ConstrainedMax\\\"\\) is deprecated and will not be \
supported in future versions of Mathematica.  Use \\!\\(\\\"NMaximize or \
Maximize\\\"\\) instead.\"\>"}]], "Message", "MSG",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->956741236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"var", "[", "1", "]"}], "\[Rule]", "5"}], ",", 
     RowBox[{
      RowBox[{"var", "[", "2", "]"}], "\[Rule]", "1"}]}], "}"}]}], 
  "}"}]], "Output",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellLabel->"Out[6]=",
 CellID->85845193]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConstrainedMax::cmcons - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 42.2910326}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "ConstrainedMax::cmcons ConstrainedMin::cmcons", 
    "synonyms" -> {}, "title" -> "ConstrainedMax::cmcons", "type" -> 
    "Message", "uri" -> "ref/message/cmcons"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2621, 109, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->85789216]},
 "ConstrainedMax::cmcons"->{
  Cell[3349, 138, 395, 12, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->26549],
  Cell[3747, 152, 369, 7, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->3698280],
  Cell[4119, 161, 296, 6, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->180281223],
  Cell[4418, 169, 361, 11, 70, "Output",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->577288909],
  Cell[4960, 192, 393, 12, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->1609],
  Cell[5356, 206, 371, 7, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->118817002],
  Cell[5730, 215, 294, 9, 70, "Output",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->160248115],
  Cell[6405, 242, 591, 18, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->26265],
  Cell[6999, 262, 370, 7, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->49784914],
  Cell[7372, 271, 309, 6, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->562891257],
  Cell[7684, 279, 488, 15, 70, "Output",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->480191415],
  Cell[8209, 299, 150, 4, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->20478],
  Cell[8384, 307, 165, 4, 70, "Print",
   CellTags->{
    "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
     "Info3381652559-8439340"},
   CellID->216649439],
  Cell[8552, 313, 809, 24, 70, "Print",
   CellTags->{
    "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
     "Info3381652559-8439340"},
   CellID->198792845],
  Cell[9540, 347, 163, 4, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->5548],
  Cell[9728, 355, 591, 18, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->6564],
  Cell[10322, 375, 371, 7, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->956741236],
  Cell[10696, 384, 364, 12, 70, "Output",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->85845193]},
 "ConstrainedMin::cmcons"->{
  Cell[3349, 138, 395, 12, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->26549],
  Cell[3747, 152, 369, 7, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->3698280],
  Cell[4119, 161, 296, 6, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->180281223],
  Cell[4418, 169, 361, 11, 70, "Output",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->577288909],
  Cell[4960, 192, 393, 12, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->1609],
  Cell[5356, 206, 371, 7, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->118817002],
  Cell[5730, 215, 294, 9, 70, "Output",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->160248115],
  Cell[6405, 242, 591, 18, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->26265],
  Cell[6999, 262, 370, 7, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->49784914],
  Cell[7372, 271, 309, 6, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->562891257],
  Cell[7684, 279, 488, 15, 70, "Output",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->480191415],
  Cell[8209, 299, 150, 4, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->20478],
  Cell[8384, 307, 165, 4, 70, "Print",
   CellTags->{
    "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
     "Info3381652559-8439340"},
   CellID->216649439],
  Cell[8552, 313, 809, 24, 70, "Print",
   CellTags->{
    "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
     "Info3381652559-8439340"},
   CellID->198792845],
  Cell[9540, 347, 163, 4, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->5548],
  Cell[9728, 355, 591, 18, 70, "Input",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->6564],
  Cell[10322, 375, 371, 7, 70, "Message",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->956741236],
  Cell[10696, 384, 364, 12, 70, "Output",
   CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
   CellID->85845193]},
 "Info3381652559-8439340"->{
  Cell[8384, 307, 165, 4, 70, "Print",
   CellTags->{
    "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
     "Info3381652559-8439340"},
   CellID->216649439],
  Cell[8552, 313, 809, 24, 70, "Print",
   CellTags->{
    "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
     "Info3381652559-8439340"},
   CellID->198792845]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12086, 426},
 {"ConstrainedMax::cmcons", 12234, 430},
 {"ConstrainedMin::cmcons", 14655, 489},
 {"Info3381652559-8439340", 17076, 548}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 91, 4, 70, "ObjectName",
 CellID->27942],
Cell[CellGroupData[{
Cell[819, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1297, 52, 213, 6, 70, "Message",
 CellID->297984621],
Cell[1513, 60, 266, 7, 70, "Notes",
 CellID->12658],
Cell[1782, 69, 521, 23, 70, "Notes",
 CellID->13927],
Cell[2306, 94, 278, 10, 70, "Notes",
 CellID->5565]
}, Closed]],
Cell[CellGroupData[{
Cell[2621, 109, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->85789216],
Cell[CellGroupData[{
Cell[3005, 123, 147, 5, 70, "ExampleSection",
 CellID->27327243],
Cell[3155, 130, 169, 4, 70, "ExampleText",
 CellID->304627805],
Cell[CellGroupData[{
Cell[3349, 138, 395, 12, 70, "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->26549],
Cell[3747, 152, 369, 7, 70, "Message",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->3698280],
Cell[4119, 161, 296, 6, 70, "Message",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->180281223],
Cell[4418, 169, 361, 11, 70, "Output",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->577288909]
}, Open  ]],
Cell[4794, 183, 141, 5, 70, "ExampleText",
 CellID->618955917],
Cell[CellGroupData[{
Cell[4960, 192, 393, 12, 70, "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->1609],
Cell[5356, 206, 371, 7, 70, "Message",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->118817002],
Cell[5730, 215, 294, 9, 70, "Output",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->160248115]
}, Open  ]],
Cell[6039, 227, 341, 11, 70, "ExampleText",
 CellID->358800586],
Cell[CellGroupData[{
Cell[6405, 242, 591, 18, 70, "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->26265],
Cell[6999, 262, 370, 7, 70, "Message",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->49784914],
Cell[7372, 271, 309, 6, 70, "Message",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->562891257],
Cell[7684, 279, 488, 15, 70, "Output",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->480191415]
}, Open  ]],
Cell[CellGroupData[{
Cell[8209, 299, 150, 4, 70, "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->20478],
Cell[CellGroupData[{
Cell[8384, 307, 165, 4, 70, "Print",
 CellTags->{
  "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
   "Info3381652559-8439340"},
 CellID->216649439],
Cell[8552, 313, 809, 24, 70, "Print",
 CellTags->{
  "ConstrainedMax::cmcons", "ConstrainedMin::cmcons", 
   "Info3381652559-8439340"},
 CellID->198792845]
}, Open  ]]
}, Open  ]],
Cell[9388, 341, 149, 4, 70, "ExampleText",
 CellID->70381011],
Cell[9540, 347, 163, 4, 70, "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->5548],
Cell[CellGroupData[{
Cell[9728, 355, 591, 18, 70, "Input",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->6564],
Cell[10322, 375, 371, 7, 70, "Message",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->956741236],
Cell[10696, 384, 364, 12, 70, "Output",
 CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"},
 CellID->85845193]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[11099, 401, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

