(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7368,        263]
NotebookOptionsPosition[      4317,        166]
NotebookOutlinePosition[      6089,        218]
CellTagsIndexPosition[      5961,        212]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["ContinuedFraction::noterms", "ObjectName",
 CellID->4455],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContinuedFraction", "::", "\<\"noterms\"\>"}], ":", 
  " ", "\<\"`` does not have a terminating or periodic continued fraction \
expansion; specify an explicit number of terms to generate.\"\>"}]], "Message",\
 "MSG",
 CellID->395498137],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 " is used with one argument and that argument is an exact number. "
}], "Notes",
 CellID->16044],

Cell[TextData[{
 "The number of terms to generate is specified in the second argument of ",
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11380]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145714642],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->727048458],

Cell[TextData[{
 "An error occurs in this example because ",
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 " will not automatically determine the number of terms if the argument is",
 " ",
 "exact."
}], "ExampleText",
 CellID->84437632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", "Pi", "]"}]], "Input",
 CellTags->"ContinuedFraction::noterms",
 CellLabel->"In[1]:=",
 CellID->13339],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContinuedFraction", "::", "\<\"noterms\"\>"}], ":", 
  " ", "\<\"\\!\\(\[Pi]\\) does not have a terminating or periodic continued \
fraction expansion; specify an explicit number of terms to generate.\"\>"}]], \
"Message", "MSG",
 CellTags->"ContinuedFraction::noterms",
 CellID->530140194],

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", "\[Pi]", "]"}]], "Output",
 CellTags->"ContinuedFraction::noterms",
 CellLabel->"Out[1]=",
 CellID->285073500]
}, Open  ]],

Cell["\<\
The continued fraction expansion is computed if the number of terms is \
specified explicitly.\
\>", "ExampleText",
 CellID->8715788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"Pi", ",", "10"}], "]"}]], "Input",
 CellTags->"ContinuedFraction::noterms",
 CellLabel->"In[2]:=",
 CellID->59],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "7", ",", "15", ",", "1", ",", "292", ",", "1", ",", "1", ",", 
   "1", ",", "2", ",", "1"}], "}"}]], "Output",
 CellTags->"ContinuedFraction::noterms",
 CellLabel->"Out[2]=",
 CellID->714810212]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ContinuedFraction::noterms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 50.5568692}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "ContinuedFraction::noterms", "synonyms" -> {}, "title" -> 
    "ContinuedFraction::noterms", "type" -> "Message", "uri" -> 
    "ref/message/noterms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2116, 80, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->145714642]},
 "ContinuedFraction::noterms"->{
  Cell[3005, 115, 151, 4, 70, "Input",
   CellTags->"ContinuedFraction::noterms",
   CellID->13339],
  Cell[3159, 121, 325, 7, 70, "Message",
   CellTags->"ContinuedFraction::noterms",
   CellID->530140194],
  Cell[3487, 130, 159, 4, 70, "Output",
   CellTags->"ContinuedFraction::noterms",
   CellID->285073500],
  Cell[3829, 145, 172, 5, 70, "Input",
   CellTags->"ContinuedFraction::noterms",
   CellID->59],
  Cell[4004, 152, 247, 7, 70, "Output",
   CellTags->"ContinuedFraction::noterms",
   CellID->714810212]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5267, 189},
 {"ContinuedFraction::noterms", 5419, 193}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 63, 1, 70, "ObjectName",
 CellID->4455],
Cell[CellGroupData[{
Cell[791, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1269, 49, 272, 6, 70, "Message",
 CellID->395498137],
Cell[1544, 57, 270, 8, 70, "Notes",
 CellID->16044],
Cell[1817, 67, 262, 8, 70, "Notes",
 CellID->11380]
}, Closed]],
Cell[CellGroupData[{
Cell[2116, 80, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145714642],
Cell[CellGroupData[{
Cell[2501, 94, 148, 5, 70, "ExampleSection",
 CellID->727048458],
Cell[2652, 101, 328, 10, 70, "ExampleText",
 CellID->84437632],
Cell[CellGroupData[{
Cell[3005, 115, 151, 4, 70, "Input",
 CellTags->"ContinuedFraction::noterms",
 CellID->13339],
Cell[3159, 121, 325, 7, 70, "Message",
 CellTags->"ContinuedFraction::noterms",
 CellID->530140194],
Cell[3487, 130, 159, 4, 70, "Output",
 CellTags->"ContinuedFraction::noterms",
 CellID->285073500]
}, Open  ]],
Cell[3661, 137, 143, 4, 70, "ExampleText",
 CellID->8715788],
Cell[CellGroupData[{
Cell[3829, 145, 172, 5, 70, "Input",
 CellTags->"ContinuedFraction::noterms",
 CellID->59],
Cell[4004, 152, 247, 7, 70, "Output",
 CellTags->"ContinuedFraction::noterms",
 CellID->714810212]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4290, 164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

