(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8237,        288]
NotebookOptionsPosition[      4860,        181]
NotebookOutlinePosition[      6822,        239]
CellTagsIndexPosition[      6696,        233]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["ContinuedFraction::start", "ObjectName",
 CellID->2271],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContinuedFraction", "::", "\<\"start\"\>"}], ":", 
  " ", "\<\"Warning: ContinuedFraction was unable to obtain at least one term \
using precision `1`.`2`\"\>"}]], "Message", "MSG",
 CellID->81773781],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["ContinuedFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuedFraction"]], "InlineFormula"],
 " is unable to compute enough terms to start the algorithm, or when an \
error",
 " ",
 "occurs while computing a numerical approximation for the first argument."
}], "Notes",
 CellID->21281]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14463046],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->135741274],

Cell["\<\
A warning message is generated in this example because the continued fraction \
expansion has only one term before the precision of the first argument is \
reached.\
\>", "ExampleText",
 CellID->333929230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"4.0", ",", "2"}], "]"}]], "Input",
 CellTags->"ContinuedFraction::start",
 CellLabel->"In[1]:=",
 CellID->32044],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContinuedFraction", "::", "\<\"start\"\>"}], ":", 
  " ", "\<\"Warning: ContinuedFraction was unable to obtain at least one term \
using precision \\!\\(15.954589770191005`\\).\\!\\(\\\"\\\"\\)\"\>"}]], \
"Message", "MSG",
 CellTags->"ContinuedFraction::start",
 CellID->751241904],

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{"4.`", ",", "2"}], "]"}]], "Output",
 CellTags->"ContinuedFraction::start",
 CellLabel->"Out[1]=",
 CellID->85450322]
}, Open  ]],

Cell["\<\
A warning message is generated in this example because numerical computation \
of the first argument generates an error.\
\>", "ExampleText",
 CellID->7860477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"Cos", "[", "1", "]"}], "^", "2"}], "-", 
    RowBox[{
     RowBox[{"Sin", "[", "1", "]"}], "^", "2"}]}], ",", "2"}], "]"}]], "Input",\

 CellTags->"ContinuedFraction::start",
 CellLabel->"In[2]:=",
 CellID->12952],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(1 - \\(Cos[1]\\)\\^2 - \
\\(Sin[1]\\)\\^2\\).\"\>"}]], "Message", "MSG",
 CellTags->"ContinuedFraction::start",
 CellID->833510517],

Cell[BoxData[
 RowBox[{
  RowBox[{"ContinuedFraction", "::", "\<\"fnumx\"\>"}], ":", 
  " ", "\<\"-- Message text not found -- (\\!\\(1 - \\(Cos[1]\\)\\^2 - \
\\(Sin[1]\\)\\^2\\))\"\>"}]], "Message", "MSG",
 CellTags->"ContinuedFraction::start",
 CellID->11458758],

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "1", "]"}], "2"], "-", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "1", "]"}], "2"]}], ",", "2"}], "]"}]], "Output",
 CellTags->"ContinuedFraction::start",
 CellLabel->"Out[2]=",
 CellID->380099178]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ContinuedFraction::start - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 50.7287486}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "ContinuedFraction::start", "synonyms" -> {}, "title" -> 
    "ContinuedFraction::start", "type" -> "Message", "uri" -> 
    "ref/message/start"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1907, 72, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14463046]},
 "ContinuedFraction::start"->{
  Cell[2682, 102, 173, 5, 70, "Input",
   CellTags->"ContinuedFraction::start",
   CellID->32044],
  Cell[2858, 109, 316, 7, 70, "Message",
   CellTags->"ContinuedFraction::start",
   CellID->751241904],
  Cell[3177, 118, 177, 5, 70, "Output",
   CellTags->"ContinuedFraction::start",
   CellID->85450322],
  Cell[3563, 134, 323, 11, 70, "Input",
   CellTags->"ContinuedFraction::start",
   CellID->12952],
  Cell[3889, 147, 307, 7, 70, "Message",
   CellTags->"ContinuedFraction::start",
   CellID->833510517],
  Cell[4199, 156, 264, 6, 70, "Message",
   CellTags->"ContinuedFraction::start",
   CellID->11458758],
  Cell[4466, 164, 328, 10, 70, "Output",
   CellTags->"ContinuedFraction::start",
   CellID->380099178]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5802, 204},
 {"ContinuedFraction::start", 5951, 208}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 61, 1, 70, "ObjectName",
 CellID->2271],
Cell[CellGroupData[{
Cell[789, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1267, 49, 235, 5, 70, "Message",
 CellID->81773781],
Cell[1505, 56, 365, 11, 70, "Notes",
 CellID->21281]
}, Closed]],
Cell[CellGroupData[{
Cell[1907, 72, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14463046],
Cell[CellGroupData[{
Cell[2291, 86, 148, 5, 70, "ExampleSection",
 CellID->135741274],
Cell[2442, 93, 215, 5, 70, "ExampleText",
 CellID->333929230],
Cell[CellGroupData[{
Cell[2682, 102, 173, 5, 70, "Input",
 CellTags->"ContinuedFraction::start",
 CellID->32044],
Cell[2858, 109, 316, 7, 70, "Message",
 CellTags->"ContinuedFraction::start",
 CellID->751241904],
Cell[3177, 118, 177, 5, 70, "Output",
 CellTags->"ContinuedFraction::start",
 CellID->85450322]
}, Open  ]],
Cell[3369, 126, 169, 4, 70, "ExampleText",
 CellID->7860477],
Cell[CellGroupData[{
Cell[3563, 134, 323, 11, 70, "Input",
 CellTags->"ContinuedFraction::start",
 CellID->12952],
Cell[3889, 147, 307, 7, 70, "Message",
 CellTags->"ContinuedFraction::start",
 CellID->833510517],
Cell[4199, 156, 264, 6, 70, "Message",
 CellTags->"ContinuedFraction::start",
 CellID->11458758],
Cell[4466, 164, 328, 10, 70, "Output",
 CellTags->"ContinuedFraction::start",
 CellID->380099178]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4833, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

