(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42156,       1081]
NotebookOptionsPosition[     18903,        477]
NotebookOutlinePosition[     38797,        990]
CellTagsIndexPosition[     38464,        978]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
ContourPlot::pllim
DensityPlot::pllim
ParametricPlot::pllim
Plot3D::pllim
Plot::pllim
ParametricPlot3D::pllim
Play::pllim\
\>", "ObjectName",
 CellID->7488],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"pllim\"\>"}], ":", 
  " ", "\<\"Range specification `1` is not of the form {x, xmin, \
xmax}.\"\>"}]], "Message", "MSG",
 CellID->47103030],

Cell["\<\
Generated when the indicated plot limits do not have the expected form.\
\>", "Notes",
 CellID->17169]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102699884],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->205736254],

Cell[TextData[{
 "An error occurs in this example because the second argument in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " is expected to be a list giving the variable and the range of the \
variable."
}], "ExampleText",
 CellID->115176422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellLabel->"In[1]:=",
 CellID->8727],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "::", "\<\"pllim\"\>"}], ":", 
  " ", "\<\"Range specification \\!\\(x\\) is not of the form {x, xmin, \
xmax}.\"\>"}]], "Message", "MSG",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->4916894],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellLabel->"Out[1]=",
 CellID->12516280]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->51940960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellLabel->"In[2]:=",
 CellID->22044],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1x20wFHgAx3HkqTRC08MSewpN2c4lR5F+rkhp8xBdzGyb5CE6iuiB67IS
8tDlpsneeYhsXaW1V5aro5S2GpKwirSs3bZ9lN0e6Cjc34t78Z3vfOyjDu6I
MdDT0wskzTwgRtl1X7Vzw/833GR9SExxw0hZZ8LM11xkl9VRfLG2OCV35tue
9d4qp4Qh4roPc+a7oj/f/Y0SDalx+YFi8gGX3E1FlFQ8YCydyCWvXBCUk0/J
huJga2QaOcu0bvkZynnkCSeL3cjDI6p4uvcc/JjWL0rWcWA2zWL42/Eg8bSa
E0nhwTFkRPmwgI9WKr/XLoePox3rwP50B5FjnGQP1R0s4lsO6us3IyYi/3DF
u3tokG5qf76+BWnBviMmq1rQklBuEzEsgMQi/3ZOjwCjTt7zuIlPILTxDNpA
fwKD8RoLG8c2hIznZV4ba4X7dGRDaG07qmf7Fc1Jbkd7tlvH45XP8cGzYmql
qAPUc5rxayOdyKma3+XX1AnNZ/Hgi++6EXTv34GoD13gqBvbzM8KsThpiVOu
jxDmtn9qZbIe1C4eV+zN6UFhfH1spcNL1LuseO/Gf4ExnxrZ/pO9kLSi33n8
JVJdBfyFD/tAZUtiljj1QVwrKOiy7wfb19f/ePwrfEnoKV2R/hrC9zcb53L6
4fyDyVRsowg2v7R6dTx+Df9L9nE3Fw1Cnldm/mlKhKO2e5ZKGGLQwwcLmNRB
0IZ3mvVuH4Ke0bk4mocY8+fpTAUTQ5CtunLn8uohGDaX8paVSfDl+8v/GDYN
4YBb46vZ26RI3RbAtwmWoGZrVOW9MSlo3Wx2rliCUY21hfzCG/i7nuo4sU+K
+lD/Wed9Zdi18arpOZ0UJ7ecvsiXy2Afljhra8ob2A8E9FWffgtq9qvCX7Vv
4OmRfZ7iKodjqHH5jjQZGHbPx/WFcqxRJsWZ6mQYbSuSHmIpEKgnZd5OeQu2
ITN1h4MSj2LpJSz1W8wfrL9kIFBiskdwtm23HEYnWGHrklWIFNOc9/bJoXeN
yZNaqVF1pMT14BYFUv7gFVm1qOEhOmK2oVmBu855ppZJGjhpBzd/u1oJy4AU
Wpb5MB5EnarW/10J0apO4fGmYeiWfeT0G6vwVwUcZMx3WJLO+NieoMJunrul
7RSxTttCb1Mh83QVS3R9BF/9ShQLXdTgKm1LzeladBfTyg/nqxFiab72yYQW
LhfctCy1GvlGBjYi4rIMI68iYsH46KSOmKVqy2ETu0sHHlp/0aKCucaOR2xd
xw1KIq7mptNFxNKw7XELvmpR3i+94q5RI5VdeGHfpBZXAymhGmJuYebxY8RN
6zLKx4jlmamMImLujS6F/rAa4fGMpX8TL1zJ+HkxsbcnrXbOlBYZWQqOH7Gx
6Omjm8Thl3s/XiRGZ/PVx8Qmc7O8a4iPCeoKXhNvmfgmt4FYfaM0xGhai/2J
662fEXecODAQTlzJVWGC2CRlz/1E4uDgtWeM3qnhExtanUWckJ7RbUF8K9Ar
/gbx02hx9HJizUYX+gNiU0e9WldiB49lLi+Jy35a8NmbmOm8yEpDnOVF9dlK
XEI1G50mbii2PRNG/B+/7YlA
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 1}, {0., 0.8414709737813186}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellLabel->"Out[2]=",
 CellID->902171648]
}, Open  ]],

Cell[TextData[{
 "This generates an error because the form of the arguments in ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " is checked before those arguments are evaluated."
}], "ExampleText",
 CellID->14033927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lims", ",", "x"}], "}"}], ",", 
   RowBox[{
    RowBox[{"lims", "=", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], ";", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"Pi", " ", "x"}], "]"}], ",", "lims"}], "]"}]}]}], 
  "]"}]], "Input",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellLabel->"In[3]:=",
 CellID->4460],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "::", "\<\"pllim\"\>"}], ":", 
  " ", "\<\"Range specification \\!\\(lims\\) is not of the form {x, xmin, \
xmax}.\"\>"}]], "Message", "MSG",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->60265023],

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "::", "\<\"pllim\"\>"}], ":", 
  " ", "\<\"Range specification \\!\\(lims\\) is not of the form {x, xmin, \
xmax}.\"\>"}]], "Message", "MSG",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->388571267],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"\[Pi]", " ", "x"}], "]"}], ",", "lims"}], "]"}]], "Output",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellLabel->"Out[3]=",
 CellID->79472093]
}, Open  ]],

Cell[TextData[{
 "If a value for the plot limits is defined outside of the ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", you can use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to cause that value to be used."
}], "ExampleText",
 CellID->462875439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"lims", ",", "x"}], "}"}], ",", 
   RowBox[{
    RowBox[{"lims", "=", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], ";", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"Pi", " ", "x"}], "]"}], ",", 
      RowBox[{"Evaluate", "[", "lims", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellLabel->"In[4]:=",
 CellID->26796],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV2Xc81d8bAHBEQyIzs0iKCg1RVI+QnVFI5StZGYWMaCqlZERIA4mW7GQl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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 2}, {-0.9999998592131705, 0.9999998782112116}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellLabel->"Out[4]=",
 CellID->645914850]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ContourPlot::pllim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 58.2914422}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "ContourPlot::pllim DensityPlot::pllim ParametricPlot::pllim \
Plot3D::pllim Plot::pllim ParametricPlot3D::pllim Play::pllim", 
    "synonyms" -> {}, "title" -> "ContourPlot::pllim", "type" -> "Message", 
    "uri" -> "ref/message/pllim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1740, 73, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->102699884]},
 "ContourPlot::pllim"->{
  Cell[2616, 107, 312, 8, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->8727],
  Cell[2931, 117, 361, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4916894],
  Cell[3295, 127, 317, 8, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->12516280],
  Cell[3856, 150, 372, 10, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->22044],
  Cell[4231, 162, 2162, 43, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->902171648],
  Cell[6716, 220, 577, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4460],
  Cell[7296, 240, 365, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->60265023],
  Cell[7664, 250, 366, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->388571267],
  Cell[8033, 260, 349, 9, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->79472093],
  Cell[8823, 289, 614, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->26796],
  Cell[9440, 309, 9397, 161, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->645914850]},
 "DensityPlot::pllim"->{
  Cell[2616, 107, 312, 8, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->8727],
  Cell[2931, 117, 361, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4916894],
  Cell[3295, 127, 317, 8, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->12516280],
  Cell[3856, 150, 372, 10, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->22044],
  Cell[4231, 162, 2162, 43, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->902171648],
  Cell[6716, 220, 577, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4460],
  Cell[7296, 240, 365, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->60265023],
  Cell[7664, 250, 366, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->388571267],
  Cell[8033, 260, 349, 9, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->79472093],
  Cell[8823, 289, 614, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->26796],
  Cell[9440, 309, 9397, 161, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->645914850]},
 "ParametricPlot::pllim"->{
  Cell[2616, 107, 312, 8, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->8727],
  Cell[2931, 117, 361, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4916894],
  Cell[3295, 127, 317, 8, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->12516280],
  Cell[3856, 150, 372, 10, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->22044],
  Cell[4231, 162, 2162, 43, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->902171648],
  Cell[6716, 220, 577, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4460],
  Cell[7296, 240, 365, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->60265023],
  Cell[7664, 250, 366, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->388571267],
  Cell[8033, 260, 349, 9, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->79472093],
  Cell[8823, 289, 614, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->26796],
  Cell[9440, 309, 9397, 161, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->645914850]},
 "Plot3D::pllim"->{
  Cell[2616, 107, 312, 8, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->8727],
  Cell[2931, 117, 361, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4916894],
  Cell[3295, 127, 317, 8, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->12516280],
  Cell[3856, 150, 372, 10, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->22044],
  Cell[4231, 162, 2162, 43, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->902171648],
  Cell[6716, 220, 577, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4460],
  Cell[7296, 240, 365, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->60265023],
  Cell[7664, 250, 366, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->388571267],
  Cell[8033, 260, 349, 9, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->79472093],
  Cell[8823, 289, 614, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->26796],
  Cell[9440, 309, 9397, 161, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->645914850]},
 "Plot::pllim"->{
  Cell[2616, 107, 312, 8, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->8727],
  Cell[2931, 117, 361, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4916894],
  Cell[3295, 127, 317, 8, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->12516280],
  Cell[3856, 150, 372, 10, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->22044],
  Cell[4231, 162, 2162, 43, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->902171648],
  Cell[6716, 220, 577, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4460],
  Cell[7296, 240, 365, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->60265023],
  Cell[7664, 250, 366, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->388571267],
  Cell[8033, 260, 349, 9, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->79472093],
  Cell[8823, 289, 614, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->26796],
  Cell[9440, 309, 9397, 161, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->645914850]},
 "ParametricPlot3D::pllim"->{
  Cell[2616, 107, 312, 8, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->8727],
  Cell[2931, 117, 361, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4916894],
  Cell[3295, 127, 317, 8, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->12516280],
  Cell[3856, 150, 372, 10, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->22044],
  Cell[4231, 162, 2162, 43, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->902171648],
  Cell[6716, 220, 577, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4460],
  Cell[7296, 240, 365, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->60265023],
  Cell[7664, 250, 366, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->388571267],
  Cell[8033, 260, 349, 9, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->79472093],
  Cell[8823, 289, 614, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->26796],
  Cell[9440, 309, 9397, 161, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->645914850]},
 "Play::pllim"->{
  Cell[2616, 107, 312, 8, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->8727],
  Cell[2931, 117, 361, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4916894],
  Cell[3295, 127, 317, 8, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->12516280],
  Cell[3856, 150, 372, 10, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->22044],
  Cell[4231, 162, 2162, 43, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->902171648],
  Cell[6716, 220, 577, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->4460],
  Cell[7296, 240, 365, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->60265023],
  Cell[7664, 250, 366, 8, 70, "Message",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->388571267],
  Cell[8033, 260, 349, 9, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->79472093],
  Cell[8823, 289, 614, 18, 70, "Input",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->26796],
  Cell[9440, 309, 9397, 161, 70, "Output",
   CellTags->{
    "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
     "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", 
     "Play::pllim"},
   CellID->645914850]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19937, 502},
 {"ContourPlot::pllim", 20081, 506},
 {"DensityPlot::pllim", 22709, 573},
 {"ParametricPlot::pllim", 25340, 640},
 {"Plot3D::pllim", 27963, 707},
 {"Plot::pllim", 30584, 774},
 {"ParametricPlot3D::pllim", 33217, 841},
 {"Play::pllim", 35838, 908}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 166, 9, 70, "ObjectName",
 CellID->7488],
Cell[CellGroupData[{
Cell[894, 40, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1372, 57, 216, 6, 70, "Message",
 CellID->47103030],
Cell[1591, 65, 112, 3, 70, "Notes",
 CellID->17169]
}, Closed]],
Cell[CellGroupData[{
Cell[1740, 73, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102699884],
Cell[CellGroupData[{
Cell[2125, 87, 148, 5, 70, "ExampleSection",
 CellID->205736254],
Cell[2276, 94, 315, 9, 70, "ExampleText",
 CellID->115176422],
Cell[CellGroupData[{
Cell[2616, 107, 312, 8, 70, "Input",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->8727],
Cell[2931, 117, 361, 8, 70, "Message",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->4916894],
Cell[3295, 127, 317, 8, 70, "Output",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->12516280]
}, Open  ]],
Cell[3627, 138, 204, 8, 70, "ExampleText",
 CellID->51940960],
Cell[CellGroupData[{
Cell[3856, 150, 372, 10, 70, "Input",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->22044],
Cell[4231, 162, 2162, 43, 70, "Output",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->902171648]
}, Open  ]],
Cell[6408, 208, 283, 8, 70, "ExampleText",
 CellID->14033927],
Cell[CellGroupData[{
Cell[6716, 220, 577, 18, 70, "Input",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->4460],
Cell[7296, 240, 365, 8, 70, "Message",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->60265023],
Cell[7664, 250, 366, 8, 70, "Message",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->388571267],
Cell[8033, 260, 349, 9, 70, "Output",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->79472093]
}, Open  ]],
Cell[8397, 272, 401, 13, 70, "ExampleText",
 CellID->462875439],
Cell[CellGroupData[{
Cell[8823, 289, 614, 18, 70, "Input",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->26796],
Cell[9440, 309, 9397, 161, 70, "Output",
 CellTags->{
  "ContourPlot::pllim", "DensityPlot::pllim", "ParametricPlot::pllim", 
   "Plot3D::pllim", "Plot::pllim", "ParametricPlot3D::pllim", "Play::pllim"},
 CellID->645914850]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[18876, 475, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

