(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7144,        274]
NotebookOptionsPosition[      4258,        176]
NotebookOutlinePosition[      5882,        227]
CellTagsIndexPosition[      5768,        221]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Cross::nonn1", "ObjectName",
 CellID->1739],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cross", "::", "\<\"nonn1\"\>"}], ":", 
  " ", "\<\"The arguments are expected to be vectors of equal length, and the \
number of arguments is expected to be 1 less than their length.\"\>"}]], \
"Message", "MSG",
 CellID->29389634],

Cell[TextData[{
 "Generated when the arguments in ",
 Cell[BoxData[
  ButtonBox["Cross",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cross"]], "InlineFormula"],
 " do not form a valid cross product."
}], "Notes",
 CellID->13627],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Cross",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cross"]], "InlineFormula"],
 " is used with ",
 StyleBox["n",
  FontSlant->"Italic"],
 " arguments, all of the arguments should be vectors of length ",
 StyleBox["n",
  FontSlant->"Italic"],
 "+1."
}], "Notes",
 CellID->6193],

Cell["\<\
An expression is a vector if the expression is a list and none of the \
elements of that list are lists.\
\>", "Notes",
 CellID->30653]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102866508],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->963441271],

Cell["\<\
An error occurs in this example because only one vector is given.\
\>", "ExampleText",
 CellID->363403140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellTags->"Cross::nonn1",
 CellLabel->"In[1]:=",
 CellID->23752],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cross", "::", "\<\"nonn1\"\>"}], ":", 
  " ", "\<\"The arguments are expected to be vectors of equal length, and the \
number of arguments is expected to be 1 less than their length.\"\>"}]], \
"Message", "MSG",
 CellTags->"Cross::nonn1",
 CellID->69767013],

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Output",
 CellTags->"Cross::nonn1",
 CellLabel->"Out[1]=",
 CellID->24400910]
}, Open  ]],

Cell["This shows a valid cross product.", "ExampleText",
 CellID->146634253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellTags->"Cross::nonn1",
 CellLabel->"In[2]:=",
 CellID->9050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3"}], ",", "6", ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 CellTags->"Cross::nonn1",
 CellLabel->"Out[2]=",
 CellID->43064051]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cross::nonn1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 59, 14.3074772}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Cross::nonn1", "synonyms" -> {}, "title" -> "Cross::nonn1", 
    "type" -> "Message", "uri" -> "ref/message/nonn1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2278, 92, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->102866508]},
 "Cross::nonn1"->{
  Cell[2955, 120, 181, 6, 70, "Input",
   CellTags->"Cross::nonn1",
   CellID->23752],
  Cell[3139, 128, 292, 7, 70, "Message",
   CellTags->"Cross::nonn1",
   CellID->69767013],
  Cell[3434, 137, 185, 6, 70, "Output",
   CellTags->"Cross::nonn1",
   CellID->24400910],
  Cell[3735, 151, 264, 9, 70, "Input",
   CellTags->"Cross::nonn1",
   CellID->9050],
  Cell[4002, 162, 190, 7, 70, "Output",
   CellTags->"Cross::nonn1",
   CellID->43064051]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5159, 198},
 {"Cross::nonn1", 5297, 202}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->1739],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 265, 6, 70, "Message",
 CellID->29389634],
Cell[1523, 57, 233, 8, 70, "Notes",
 CellID->13627],
Cell[1759, 67, 334, 14, 70, "Notes",
 CellID->6193],
Cell[2096, 83, 145, 4, 70, "Notes",
 CellID->30653]
}, Closed]],
Cell[CellGroupData[{
Cell[2278, 92, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102866508],
Cell[CellGroupData[{
Cell[2663, 106, 148, 5, 70, "ExampleSection",
 CellID->963441271],
Cell[2814, 113, 116, 3, 70, "ExampleText",
 CellID->363403140],
Cell[CellGroupData[{
Cell[2955, 120, 181, 6, 70, "Input",
 CellTags->"Cross::nonn1",
 CellID->23752],
Cell[3139, 128, 292, 7, 70, "Message",
 CellTags->"Cross::nonn1",
 CellID->69767013],
Cell[3434, 137, 185, 6, 70, "Output",
 CellTags->"Cross::nonn1",
 CellID->24400910]
}, Open  ]],
Cell[3634, 146, 76, 1, 70, "ExampleText",
 CellID->146634253],
Cell[CellGroupData[{
Cell[3735, 151, 264, 9, 70, "Input",
 CellTags->"Cross::nonn1",
 CellID->9050],
Cell[4002, 162, 190, 7, 70, "Output",
 CellTags->"Cross::nonn1",
 CellID->43064051]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4231, 174, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

