(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6495,        241]
NotebookOptionsPosition[      4420,        173]
NotebookOutlinePosition[      5565,        207]
CellTagsIndexPosition[      5481,        202]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::bvlim
RSolve::bvlim\
\>", "ObjectName",
 CellID->23135],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"bvlim\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, unable to compute the \
limit at the given points. Some of the solutions may be lost.\"\>"}]], \
"Message", "MSG",
 CellID->49828229],

Cell["\<\
Generated when it is not possible to compute a limit corresponding to one or \
more boundary conditions.\
\>", "Notes",
 CellID->16787]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1010741434],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->783541444],

Cell[TextData[{
 "An error occurs because the limits required to find the solution satisfying \
",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["z", "TI"], "[", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], "]"}], "==", "3"}]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["z", "TI"], "'"}], "[", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], "]"}], "==", "1"}]], 
  "InlineFormula"],
 " cannot be found."
}], "ExampleText",
 CellID->12959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"z", "''"}], "[", "x", "]"}], " ", "-", 
       RowBox[{"Sin", "[", 
        RowBox[{"z", "[", "x", "]"}], "]"}]}], ")"}], "\[Equal]", "0"}], "&&",
     
    RowBox[{
     RowBox[{"z", "[", "Infinity", "]"}], "\[Equal]", "3"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"z", "'"}], "[", "Infinity", "]"}], "\[Equal]", "1"}]}], ",", 
   " ", "z", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15251],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG",
 CellID->7465193],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvlim\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, unable to compute the \
limit at the given points. Some of the solutions may be lost.\"\>"}]], \
"Message", "MSG",
 CellID->218578894],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvlim\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, unable to compute the \
limit at the given points. Some of the solutions may be lost.\"\>"}]], \
"Message", "MSG",
 CellID->30589825],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->205640264]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::bvlim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 59, 55.2929014}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::bvlim RSolve::bvlim", "synonyms" -> {}, "title" -> 
    "DSolve::bvlim", "type" -> "Message", "uri" -> "ref/message/bvlim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1749, 70, 361, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1010741434]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5338, 195}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 73, 4, 70, "ObjectName",
 CellID->23135],
Cell[CellGroupData[{
Cell[801, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1279, 52, 285, 7, 70, "Message",
 CellID->49828229],
Cell[1567, 61, 145, 4, 70, "Notes",
 CellID->16787]
}, Closed]],
Cell[CellGroupData[{
Cell[1749, 70, 361, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1010741434],
Cell[CellGroupData[{
Cell[2135, 84, 148, 5, 70, "ExampleSection",
 CellID->783541444],
Cell[2286, 91, 589, 23, 70, "ExampleText",
 CellID->12959],
Cell[CellGroupData[{
Cell[2900, 118, 560, 19, 70, "Input",
 CellID->15251],
Cell[3463, 139, 267, 6, 70, "Message",
 CellID->7465193],
Cell[3733, 147, 264, 6, 70, "Message",
 CellID->218578894],
Cell[4000, 155, 263, 6, 70, "Message",
 CellID->30589825],
Cell[4266, 163, 88, 3, 70, "Output",
 CellID->205640264]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4393, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

