(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9269,        358]
NotebookOptionsPosition[      6646,        268]
NotebookOutlinePosition[      7785,        302]
CellTagsIndexPosition[      7701,        297]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::bvnr
RSolve::bvnr\
\>", "ObjectName",
 CellID->17783],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"bvnr\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, the given boundary \
conditions do not restrict the existing freedom in the general \
solution.\"\>"}]], "Message", "MSG",
 CellID->379208995],

Cell["\<\
Generated when the given boundary conditions cannot be used to fix the value \
of the arbitrary constants in the general solution.\
\>", "Notes",
 CellID->11721],

Cell["\<\
Typically, this indicates that the boundary value problem is not well-posed, \
that is, the solution is not unique.\
\>", "Notes",
 CellID->32657]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->153050832],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->336491624],

Cell[TextData[{
 "The general solution of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["y", "TI"], "'"}], "[", 
    StyleBox["x", "TI"], "]"}], "==", " ", 
   RowBox[{
    StyleBox["y", "TI"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 " satisfies the condition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["y", "TI"], "[", "0", "]"}], "==", " ", 
   RowBox[{
    RowBox[{
     StyleBox["y", "TI"], "'"}], "[", "0", "]"}]}]], "InlineFormula"],
 " for every value of the constant ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->2002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"y", "[", "x", "]"}]}], ",", " ", "y", ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10621],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], " ", 
       RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1019092312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
   RowBox[{
    RowBox[{"y", "'"}], "[", "0", "]"}]}], "/.", 
  RowBox[{"%", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31384],

Cell[BoxData["True"], "Output",
 CellLabel->"Out[2]=",
 CellID->5518114]
}, Open  ]],

Cell["\<\
Hence, an error occurs in the following boundary value problem. \
\>", "ExampleText",
 CellID->5357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
     RowBox[{"y", "[", "x", "]"}]}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
     RowBox[{
      RowBox[{"y", "'"}], "[", "0", "]"}]}]}], ",", " ", "y", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19819],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvnr\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, the given boundary \
conditions do not restrict the existing freedom in the general \
solution.\"\>"}]], "Message", "MSG",
 CellID->616780840],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvsing\"\>"}], ":", 
  " ", "\<\"Unable to resolve some of the arbitrary constants in the general \
solution using the given boundary conditions. It is possible that some of the \
conditions have been specified at a singular point for the equation.\"\>"}]], \
"Message", "MSG",
 CellID->256825517],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], " ", 
       RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->244418300]
}, Open  ]],

Cell[TextData[{
 "The example works fine using a boundary condition such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["y", "TI"], "[", "0", "]"}], "==", "1"}]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->30397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
     RowBox[{"y", "[", "x", "]"}]}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], ",", " ", "y", ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      SuperscriptBox["\[ExponentialE]", "x"]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->183529181]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::bvnr - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 59, 55.4179046}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::bvnr RSolve::bvnr", "synonyms" -> {}, "title" -> 
    "DSolve::bvnr", "type" -> "Message", "uri" -> "ref/message/bvnr"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1940, 76, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->153050832]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7559, 290}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 71, 4, 70, "ObjectName",
 CellID->17783],
Cell[CellGroupData[{
Cell[799, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1277, 52, 293, 7, 70, "Message",
 CellID->379208995],
Cell[1573, 61, 171, 4, 70, "Notes",
 CellID->11721],
Cell[1747, 67, 156, 4, 70, "Notes",
 CellID->32657]
}, Closed]],
Cell[CellGroupData[{
Cell[1940, 76, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->153050832],
Cell[CellGroupData[{
Cell[2325, 90, 148, 5, 70, "ExampleSection",
 CellID->336491624],
Cell[2476, 97, 705, 27, 70, "ExampleText",
 CellID->2002],
Cell[CellGroupData[{
Cell[3206, 128, 256, 9, 70, "Input",
 CellID->10621],
Cell[3465, 139, 340, 11, 70, "Output",
 CellID->1019092312]
}, Open  ]],
Cell[CellGroupData[{
Cell[3842, 155, 249, 9, 70, "Input",
 CellID->31384],
Cell[4094, 166, 72, 2, 70, "Output",
 CellID->5518114]
}, Open  ]],
Cell[4181, 171, 110, 3, 70, "ExampleText",
 CellID->5357],
Cell[CellGroupData[{
Cell[4316, 178, 396, 14, 70, "Input",
 CellID->19819],
Cell[4715, 194, 271, 6, 70, "Message",
 CellID->616780840],
Cell[4989, 202, 352, 7, 70, "Message",
 CellID->256825517],
Cell[5344, 211, 339, 11, 70, "Output",
 CellID->244418300]
}, Open  ]],
Cell[5698, 225, 230, 8, 70, "ExampleText",
 CellID->30397],
Cell[CellGroupData[{
Cell[5953, 237, 343, 12, 70, "Input",
 CellID->3736],
Cell[6299, 251, 281, 10, 70, "Output",
 CellID->183529181]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6619, 266, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

