(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15354,        508]
NotebookOptionsPosition[      7991,        305]
NotebookOutlinePosition[     13067,        436]
CellTagsIndexPosition[     12890,        428]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::deqn
NDSolve::deqn
RSolve::deqn\
\>", "ObjectName",
 CellID->15381],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"deqn\"\>"}], ":", 
  " ", "\<\"Equation or list of equations expected instead of `1` in the \
first argument `2`.\"\>"}]], "Message", "MSG",
 CellID->123234791],

Cell[TextData[{
 "Generated when the indicated expression from the first argument of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is not an equation."
}], "Notes",
 CellID->8640],

Cell[TextData[{
 "The first argument in ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is expected to be an equation or a list of equations. "
}], "Notes",
 CellID->7403],

Cell[TextData[{
 "Equations can be entered using the notation ",
 StyleBox["lhs", "MR",
  FontSlant->"Italic"],
 StyleBox["==", "MR"],
 StyleBox["rhs", "MR",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->20325],

Cell[TextData[{
 "The notation ",
 StyleBox["lhs", "MR",
  FontSlant->"Italic"],
 StyleBox["=", "MR"],
 StyleBox["rhs", "MR",
  FontSlant->"Italic"],
 " is used for assignments rather than for equations. Evaluation of an",
 " ",
 "expression of this form will attempt to assign a value to ",
 StyleBox["lhs", "MR",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->32700]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376771834],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->5925156],

Cell["\<\
An error occurs in this example because one of the elements listed in the \
first argument is not an equation.\
\>", "ExampleText",
 CellID->284300843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", "1"}], ",", 
     RowBox[{"1", "-", 
      RowBox[{"f", "[", "0", "]"}]}]}], "}"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellLabel->"In[1]:=",
 CellID->27407],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"deqn\"\>"}], ":", 
  " ", "\<\"Equation or list of equations expected instead of \\!\\(1 - \
\\(\\(f[0]\\)\\)\\) in the first argument \
\\!\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[x]\\)\\) \[Equal] 1\\)\\), \\(\\(1 - \\(\
\\(f[0]\\)\\)\\)\\)}\\).\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->257899229],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{"1", "-", 
      RowBox[{"f", "[", "0", "]"}]}]}], "}"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellLabel->"Out[1]=",
 CellID->42451778]
}, Open  ]],

Cell[TextData[{
 "This shows a valid specification of equations in ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->94738857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"f", "[", "0", "]"}]}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellLabel->"In[2]:=",
 CellID->12187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"1", "+", "x"}]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellLabel->"Out[2]=",
 CellID->234337811]
}, Open  ]],

Cell["\<\
An error occurs in this example because the first argument is not an equation \
or a list.\
\>", "ExampleText",
 CellID->520873729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellLabel->"In[3]:=",
 CellID->3268],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"deqn\"\>"}], ":", 
  " ", "\<\"Equation or list of equations expected instead of \\!\\(1 - \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[x]\\)\\)\\) in the first argument \
\\!\\(1 - \\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[x]\\)\\)\\).\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->273620624],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellLabel->"Out[3]=",
 CellID->105385928]
}, Open  ]],

Cell[TextData[{
 "This shows valid input for ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->370343537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"f", "'"}], "[", "x", "]"}]}], "==", "0"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellLabel->"In[4]:=",
 CellID->14602],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"x", "+", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellLabel->"Out[4]=",
 CellID->758823511]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::deqn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 2.7305918}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::deqn NDSolve::deqn RSolve::deqn", "synonyms" -> {}, 
    "title" -> "DSolve::deqn", "type" -> "Message", "uri" -> 
    "ref/message/deqn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2662, 111, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->376771834]},
 "DSolve::deqn"->{
  Cell[3382, 140, 411, 13, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->27407],
  Cell[3796, 155, 478, 9, 70, "Message",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->257899229],
  Cell[4277, 166, 467, 14, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->42451778],
  Cell[5011, 195, 440, 14, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->12187],
  Cell[5454, 211, 263, 8, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->234337811],
  Cell[5898, 230, 296, 9, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->3268],
  Cell[6197, 241, 511, 9, 70, "Message",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->273620624],
  Cell[6711, 252, 346, 10, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->105385928],
  Cell[7303, 277, 325, 10, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->14602],
  Cell[7631, 289, 294, 9, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->758823511]},
 "NDSolve::deqn"->{
  Cell[3382, 140, 411, 13, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->27407],
  Cell[3796, 155, 478, 9, 70, "Message",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->257899229],
  Cell[4277, 166, 467, 14, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->42451778],
  Cell[5011, 195, 440, 14, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->12187],
  Cell[5454, 211, 263, 8, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->234337811],
  Cell[5898, 230, 296, 9, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->3268],
  Cell[6197, 241, 511, 9, 70, "Message",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->273620624],
  Cell[6711, 252, 346, 10, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->105385928],
  Cell[7303, 277, 325, 10, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->14602],
  Cell[7631, 289, 294, 9, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->758823511]},
 "RSolve::deqn"->{
  Cell[3382, 140, 411, 13, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->27407],
  Cell[3796, 155, 478, 9, 70, "Message",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->257899229],
  Cell[4277, 166, 467, 14, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->42451778],
  Cell[5011, 195, 440, 14, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->12187],
  Cell[5454, 211, 263, 8, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->234337811],
  Cell[5898, 230, 296, 9, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->3268],
  Cell[6197, 241, 511, 9, 70, "Message",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->273620624],
  Cell[6711, 252, 346, 10, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->105385928],
  Cell[7303, 277, 325, 10, 70, "Input",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->14602],
  Cell[7631, 289, 294, 9, 70, "Output",
   CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
   CellID->758823511]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8921, 328},
 {"DSolve::deqn", 9060, 332},
 {"NDSolve::deqn", 10336, 363},
 {"RSolve::deqn", 11611, 394}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 85, 5, 70, "ObjectName",
 CellID->15381],
Cell[CellGroupData[{
Cell[813, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1291, 53, 237, 6, 70, "Message",
 CellID->123234791],
Cell[1531, 61, 254, 8, 70, "Notes",
 CellID->8640],
Cell[1788, 71, 244, 8, 70, "Notes",
 CellID->7403],
Cell[2035, 81, 215, 9, 70, "Notes",
 CellID->20325],
Cell[2253, 92, 372, 14, 70, "Notes",
 CellID->32700]
}, Closed]],
Cell[CellGroupData[{
Cell[2662, 111, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376771834],
Cell[CellGroupData[{
Cell[3047, 125, 146, 5, 70, "ExampleSection",
 CellID->5925156],
Cell[3196, 132, 161, 4, 70, "ExampleText",
 CellID->284300843],
Cell[CellGroupData[{
Cell[3382, 140, 411, 13, 70, "Input",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->27407],
Cell[3796, 155, 478, 9, 70, "Message",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->257899229],
Cell[4277, 166, 467, 14, 70, "Output",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->42451778]
}, Open  ]],
Cell[4759, 183, 227, 8, 70, "ExampleText",
 CellID->94738857],
Cell[CellGroupData[{
Cell[5011, 195, 440, 14, 70, "Input",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->12187],
Cell[5454, 211, 263, 8, 70, "Output",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->234337811]
}, Open  ]],
Cell[5732, 222, 141, 4, 70, "ExampleText",
 CellID->520873729],
Cell[CellGroupData[{
Cell[5898, 230, 296, 9, 70, "Input",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->3268],
Cell[6197, 241, 511, 9, 70, "Message",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->273620624],
Cell[6711, 252, 346, 10, 70, "Output",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->105385928]
}, Open  ]],
Cell[7072, 265, 206, 8, 70, "ExampleText",
 CellID->370343537],
Cell[CellGroupData[{
Cell[7303, 277, 325, 10, 70, "Input",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->14602],
Cell[7631, 289, 294, 9, 70, "Output",
 CellTags->{"DSolve::deqn", "NDSolve::deqn", "RSolve::deqn"},
 CellID->758823511]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7964, 303, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

