(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8710,        309]
NotebookOptionsPosition[      5034,        198]
NotebookOutlinePosition[      7432,        266]
CellTagsIndexPosition[      7283,        259]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::derarg
NDSolve::derarg\
\>", "ObjectName",
 CellID->7657],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"derarg\"\>"}], ":", 
  " ", "\<\"The derivative operator `1` in `2` should act on the pure \
function.\"\>"}]], "Message", "MSG",
 CellID->16382111],

Cell[TextData[{
 "Generated by an invalid ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " expression in the first argument of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6270]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->222492862],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->60574611],

Cell[TextData[{
 "An error occurs in this example because ",
 StyleBox["Derivative[1][f[x]]", "MR"],
 " indicates differentiation of a function named ",
 StyleBox["f[x]", "MR"],
 " rather than the derivative of ",
 StyleBox["f", "MR"],
 " evaluated at ",
 StyleBox["x", "MR"],
 "."
}], "ExampleText",
 CellID->468435893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", "1", "]"}], "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "\[Equal]", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellLabel->"In[1]:=",
 CellID->15021],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"derarg\"\>"}], ":", 
  " ", "\<\"The derivative operator \\!\\(Derivative[1]\\) in \
\\!\\(\\*SuperscriptBox[\\(f[x]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, \
None]]\\) should act on the pure function.\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellID->831995179],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"f", "[", "x", "]"}], "\[Prime]",
     MultilineFunction->None], "\[Equal]", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellLabel->"Out[1]=",
 CellID->379887919]
}, Open  ]],

Cell[TextData[{
 "This shows a valid input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->55878024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}], "[", "x", "]"}],
     "\[Equal]", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellLabel->"In[2]:=",
 CellID->26335],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellLabel->"Out[2]=",
 CellID->148714110]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::derarg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 3.1212268}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::derarg NDSolve::derarg", "synonyms" -> {}, "title" -> 
    "DSolve::derarg", "type" -> "Message", "uri" -> "ref/message/derarg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2029, 83, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->222492862]},
 "DSolve::derarg"->{
  Cell[2909, 119, 372, 11, 70, "Input",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->15021],
  Cell[3284, 132, 359, 7, 70, "Message",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->831995179],
  Cell[3646, 141, 370, 11, 70, "Output",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->379887919],
  Cell[4264, 167, 378, 12, 70, "Input",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->26335],
  Cell[4645, 181, 323, 10, 70, "Output",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->148714110]},
 "NDSolve::derarg"->{
  Cell[2909, 119, 372, 11, 70, "Input",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->15021],
  Cell[3284, 132, 359, 7, 70, "Message",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->831995179],
  Cell[3646, 141, 370, 11, 70, "Output",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->379887919],
  Cell[4264, 167, 378, 12, 70, "Input",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->26335],
  Cell[4645, 181, 323, 10, 70, "Output",
   CellTags->{"DSolve::derarg", "NDSolve::derarg"},
   CellID->148714110]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5956, 220},
 {"DSolve::derarg", 6096, 224},
 {"NDSolve::derarg", 6689, 240}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 75, 4, 70, "ObjectName",
 CellID->7657],
Cell[CellGroupData[{
Cell[803, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1281, 52, 225, 6, 70, "Message",
 CellID->16382111],
Cell[1509, 60, 483, 18, 70, "Notes",
 CellID->6270]
}, Closed]],
Cell[CellGroupData[{
Cell[2029, 83, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->222492862],
Cell[CellGroupData[{
Cell[2414, 97, 147, 5, 70, "ExampleSection",
 CellID->60574611],
Cell[2564, 104, 320, 11, 70, "ExampleText",
 CellID->468435893],
Cell[CellGroupData[{
Cell[2909, 119, 372, 11, 70, "Input",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellID->15021],
Cell[3284, 132, 359, 7, 70, "Message",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellID->831995179],
Cell[3646, 141, 370, 11, 70, "Output",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellID->379887919]
}, Open  ]],
Cell[4031, 155, 208, 8, 70, "ExampleText",
 CellID->55878024],
Cell[CellGroupData[{
Cell[4264, 167, 378, 12, 70, "Input",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellID->26335],
Cell[4645, 181, 323, 10, 70, "Output",
 CellTags->{"DSolve::derarg", "NDSolve::derarg"},
 CellID->148714110]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5007, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

