(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9399,        314]
NotebookOptionsPosition[      4795,        185]
NotebookOutlinePosition[      8048,        271]
CellTagsIndexPosition[      7870,        263]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::dvlen
NDSolve::dvlen
RSolve::dvlen\
\>", "ObjectName",
 CellID->1376],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"dvlen\"\>"}], ":", 
  " ", "\<\"The function `1` does not have the same number of arguments as \
independent variables (`2`).\"\>"}]], "Message", "MSG",
 CellID->88601713],

Cell["\<\
Generated when the dependent variable occurs with a number of arguments that \
is not equal to the number of independent variables.\
\>", "Notes",
 CellID->29936]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->379750930],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->398814459],

Cell[TextData[{
 "An error occurs in this example because ",
 StyleBox["f[0,x]", "MR"],
 " has two arguments and there is only one independent variable."
}], "ExampleText",
 CellID->56963824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"f", "[", 
     RowBox[{"0", ",", "x"}], "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellLabel->"In[1]:=",
 CellID->15921],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"dvlen\"\>"}], ":", 
  " ", "\<\"The function \\!\\(f[\\(\\(0, x\\)\\)]\\) does not have the same \
number of arguments as independent variables (\\!\\(1\\)).\"\>"}]], "Message",\
 "MSG",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellID->312734005],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"f", "[", 
     RowBox[{"0", ",", "x"}], "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellLabel->"Out[1]=",
 CellID->20334409]
}, Open  ]],

Cell[TextData[{
 "This shows a valid input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ". using ",
 StyleBox["f[0]", "MR"],
 " as the independent variable."
}], "ExampleText",
 CellID->13771288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"f", "[", "0", "]"}], "[", "x", "]"}]}], ",", 
   RowBox[{
    RowBox[{"f", "[", "0", "]"}], "[", "x", "]"}], ",", "x"}], "]"}]], "Input",\

 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellLabel->"In[2]:=",
 CellID->29373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "0", "]"}], "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellLabel->"Out[2]=",
 CellID->534755900]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::dvlen - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 10.4495394}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::dvlen NDSolve::dvlen RSolve::dvlen", 
    "synonyms" -> {}, "title" -> "DSolve::dvlen", "type" -> "Message", "uri" -> 
    "ref/message/dvlen"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1753, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->379750930]},
 "DSolve::dvlen"->{
  Cell[2505, 100, 363, 11, 70, "Input",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->15921],
  Cell[2871, 113, 326, 7, 70, "Message",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->312734005],
  Cell[3200, 122, 411, 12, 70, "Output",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->20334409],
  Cell[3925, 151, 432, 14, 70, "Input",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->29373],
  Cell[4360, 167, 369, 11, 70, "Output",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->534755900]},
 "NDSolve::dvlen"->{
  Cell[2505, 100, 363, 11, 70, "Input",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->15921],
  Cell[2871, 113, 326, 7, 70, "Message",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->312734005],
  Cell[3200, 122, 411, 12, 70, "Output",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->20334409],
  Cell[3925, 151, 432, 14, 70, "Input",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->29373],
  Cell[4360, 167, 369, 11, 70, "Output",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->534755900]},
 "RSolve::dvlen"->{
  Cell[2505, 100, 363, 11, 70, "Input",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->15921],
  Cell[2871, 113, 326, 7, 70, "Message",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->312734005],
  Cell[3200, 122, 411, 12, 70, "Output",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->20334409],
  Cell[3925, 151, 432, 14, 70, "Input",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->29373],
  Cell[4360, 167, 369, 11, 70, "Output",
   CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
   CellID->534755900]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5732, 208},
 {"DSolve::dvlen", 5871, 212},
 {"NDSolve::dvlen", 6537, 228},
 {"RSolve::dvlen", 7202, 244}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 87, 5, 70, "ObjectName",
 CellID->1376],
Cell[CellGroupData[{
Cell[815, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1293, 53, 248, 6, 70, "Message",
 CellID->88601713],
Cell[1544, 61, 172, 4, 70, "Notes",
 CellID->29936]
}, Closed]],
Cell[CellGroupData[{
Cell[1753, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->379750930],
Cell[CellGroupData[{
Cell[2138, 84, 148, 5, 70, "ExampleSection",
 CellID->398814459],
Cell[2289, 91, 191, 5, 70, "ExampleText",
 CellID->56963824],
Cell[CellGroupData[{
Cell[2505, 100, 363, 11, 70, "Input",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellID->15921],
Cell[2871, 113, 326, 7, 70, "Message",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellID->312734005],
Cell[3200, 122, 411, 12, 70, "Output",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellID->20334409]
}, Open  ]],
Cell[3626, 137, 274, 10, 70, "ExampleText",
 CellID->13771288],
Cell[CellGroupData[{
Cell[3925, 151, 432, 14, 70, "Input",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellID->29373],
Cell[4360, 167, 369, 11, 70, "Output",
 CellTags->{"DSolve::dvlen", "NDSolve::dvlen", "RSolve::dvlen"},
 CellID->534755900]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4768, 183, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

