(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14899,        474]
NotebookOptionsPosition[      8551,        305]
NotebookOutlinePosition[     13059,        418]
CellTagsIndexPosition[     12876,        410]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::litarg
NDSolve::litarg
RSolve::litarg\
\>", "ObjectName",
 CellID->3661],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"litarg\"\>"}], ":", 
  " ", "\<\"To avoid possible ambiguity, the arguments of the dependent \
variable in `1` should literally match the independent variables.\"\>"}]], \
"Message", "MSG",
 CellID->92506220],

Cell["\<\
Generated when the independent variables are not specified with consistent \
names and positions.\
\>", "Notes",
 CellID->24022]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44887044],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->14462329],

Cell["\<\
An error occurs in this example because not all of the equations for the \
unknown function are differential equations.\
\>", "ExampleText",
 CellID->217292470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}]}], "}"}], ",", "f", ",", "x"}], 
  "]"}]], "Input",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellLabel->"In[1]:=",
 CellID->22636],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"litarg\"\>"}], ":", 
  " ", "\<\"To avoid possible ambiguity, the arguments of the dependent \
variable in \\!\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \
\\\"\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[x]\\)\\) \[Equal] \
\\(\\(f[x]\\)\\)\\)\\), \\(\\(\\(\\(f[1]\\)\\) \[Equal] \
\\(\\(f[x]\\)\\)\\)\\)}\\) should literally match the independent \
variables.\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->15981656],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}]}], "}"}], ",", "f", ",", "x"}], 
  "]"}]], "Output",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellLabel->"Out[1]=",
 CellID->112622876]
}, Open  ]],

Cell["\<\
This shows a valid specification of the solution of a differential equation.\
\>", "ExampleText",
 CellID->279395618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   "x"}], "]"}]], "Input",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellLabel->"In[2]:=",
 CellID->18178],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}]]}], "]"}]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellLabel->"Out[2]=",
 CellID->19457162]
}, Open  ]],

Cell["\<\
An error occurs in this example because one of the boundary conditions is not \
given directly as a function of the variables.\
\>", "ExampleText",
 CellID->153301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"2", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "==", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", 
        RowBox[{"2", "t"}]}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellLabel->"In[3]:=",
 CellID->32727],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"litarg\"\>"}], ":", 
  " ", "\<\"To avoid possible ambiguity, the arguments of the dependent \
variable in \\!\\(\\(\\(f[\\(\\(0, \\(\\(2\\\\ t\\)\\)\\)\\)]\\)\\) \[Equal] \
0\\) should literally match the independent variables.\"\>"}]], "Message", \
"MSG",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->345615051],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "2"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"0", ",", "1"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", 
        RowBox[{"2", " ", "t"}]}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}], " ", "x"}]}]}], "}"}], ",", "f", ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellLabel->"Out[3]=",
 CellID->866668134]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::litarg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 10.8870506}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::litarg NDSolve::litarg RSolve::litarg", 
    "synonyms" -> {}, "title" -> "DSolve::litarg", "type" -> "Message", "uri" -> 
    "ref/message/litarg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1759, 71, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->44887044]},
 "DSolve::litarg"->{
  Cell[2488, 100, 456, 15, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->22636],
  Cell[2947, 117, 543, 10, 70, "Message",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->15981656],
  Cell[3493, 129, 519, 16, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->112622876],
  Cell[4179, 155, 425, 14, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->18178],
  Cell[4607, 171, 397, 12, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->19457162],
  Cell[5218, 194, 1323, 41, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->32727],
  Cell[6544, 237, 401, 8, 70, "Message",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->345615051],
  Cell[6948, 247, 1537, 51, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->866668134]},
 "NDSolve::litarg"->{
  Cell[2488, 100, 456, 15, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->22636],
  Cell[2947, 117, 543, 10, 70, "Message",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->15981656],
  Cell[3493, 129, 519, 16, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->112622876],
  Cell[4179, 155, 425, 14, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->18178],
  Cell[4607, 171, 397, 12, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->19457162],
  Cell[5218, 194, 1323, 41, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->32727],
  Cell[6544, 237, 401, 8, 70, "Message",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->345615051],
  Cell[6948, 247, 1537, 51, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->866668134]},
 "RSolve::litarg"->{
  Cell[2488, 100, 456, 15, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->22636],
  Cell[2947, 117, 543, 10, 70, "Message",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->15981656],
  Cell[3493, 129, 519, 16, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->112622876],
  Cell[4179, 155, 425, 14, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->18178],
  Cell[4607, 171, 397, 12, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->19457162],
  Cell[5218, 194, 1323, 41, 70, "Input",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->32727],
  Cell[6544, 237, 401, 8, 70, "Message",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->345615051],
  Cell[6948, 247, 1537, 51, 70, "Output",
   CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
   CellID->866668134]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9494, 328},
 {"DSolve::litarg", 9633, 332},
 {"NDSolve::litarg", 10714, 357},
 {"RSolve::litarg", 11794, 382}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 90, 5, 70, "ObjectName",
 CellID->3661],
Cell[CellGroupData[{
Cell[818, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1296, 53, 285, 7, 70, "Message",
 CellID->92506220],
Cell[1584, 62, 138, 4, 70, "Notes",
 CellID->24022]
}, Closed]],
Cell[CellGroupData[{
Cell[1759, 71, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->44887044],
Cell[CellGroupData[{
Cell[2143, 85, 147, 5, 70, "ExampleSection",
 CellID->14462329],
Cell[2293, 92, 170, 4, 70, "ExampleText",
 CellID->217292470],
Cell[CellGroupData[{
Cell[2488, 100, 456, 15, 70, "Input",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->22636],
Cell[2947, 117, 543, 10, 70, "Message",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->15981656],
Cell[3493, 129, 519, 16, 70, "Output",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->112622876]
}, Open  ]],
Cell[4027, 148, 127, 3, 70, "ExampleText",
 CellID->279395618],
Cell[CellGroupData[{
Cell[4179, 155, 425, 14, 70, "Input",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->18178],
Cell[4607, 171, 397, 12, 70, "Output",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->19457162]
}, Open  ]],
Cell[5019, 186, 174, 4, 70, "ExampleText",
 CellID->153301],
Cell[CellGroupData[{
Cell[5218, 194, 1323, 41, 70, "Input",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->32727],
Cell[6544, 237, 401, 8, 70, "Message",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->345615051],
Cell[6948, 247, 1537, 51, 70, "Output",
 CellTags->{"DSolve::litarg", "NDSolve::litarg", "RSolve::litarg"},
 CellID->866668134]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[8524, 303, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

