(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9217,        310]
NotebookOptionsPosition[      4536,        181]
NotebookOutlinePosition[      7849,        267]
CellTagsIndexPosition[      7668,        259]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::nestdv
NDSolve::nestdv
RSolve::nestdv\
\>", "ObjectName",
 CellID->21225],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"nestdv\"\>"}], ":", 
  " ", "\<\"The expression `1` has nested dependent variables.\"\>"}]], \
"Message", "MSG",
 CellID->78816881],

Cell["\<\
Generated when the dependent variable occurs in an argument of the dependent \
variable.\
\>", "Notes",
 CellID->27079]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->384341794],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->34477901],

Cell[TextData[{
 "An error occurs in this example because ",
 StyleBox["f[f[x]]", "MR"],
 " includes ",
 StyleBox["f[x]", "MR"],
 " as an argument of the dependent variable ",
 StyleBox["f", "MR"],
 "."
}], "ExampleText",
 CellID->269408400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellLabel->"In[1]:=",
 CellID->30924],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nestdv\"\>"}], ":", 
  " ", "\<\"The expression \\!\\(f[x]\\) has nested dependent \
variables.\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellID->507893704],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellLabel->"Out[1]=",
 CellID->665414118]
}, Open  ]],

Cell[TextData[{
 "This shows a valid input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->613537899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"f", "[", "x", "]"}]}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellLabel->"In[2]:=",
 CellID->14240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], " ", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellLabel->"Out[2]=",
 CellID->331141622]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::nestdv - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 11.1683078}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::nestdv NDSolve::nestdv RSolve::nestdv", 
    "synonyms" -> {}, "title" -> "DSolve::nestdv", "type" -> "Message", "uri" -> 
    "ref/message/nestdv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1674, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->384341794]},
 "DSolve::nestdv"->{
  Cell[2475, 104, 371, 11, 70, "Input",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->30924],
  Cell[2849, 117, 265, 6, 70, "Message",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->507893704],
  Cell[3117, 125, 420, 12, 70, "Output",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->665414118],
  Cell[3786, 152, 340, 10, 70, "Input",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->14240],
  Cell[4129, 164, 341, 10, 70, "Output",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->331141622]},
 "NDSolve::nestdv"->{
  Cell[2475, 104, 371, 11, 70, "Input",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->30924],
  Cell[2849, 117, 265, 6, 70, "Message",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->507893704],
  Cell[3117, 125, 420, 12, 70, "Output",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->665414118],
  Cell[3786, 152, 340, 10, 70, "Input",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->14240],
  Cell[4129, 164, 341, 10, 70, "Output",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->331141622]},
 "RSolve::nestdv"->{
  Cell[2475, 104, 371, 11, 70, "Input",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->30924],
  Cell[2849, 117, 265, 6, 70, "Message",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->507893704],
  Cell[3117, 125, 420, 12, 70, "Output",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->665414118],
  Cell[3786, 152, 340, 10, 70, "Input",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->14240],
  Cell[4129, 164, 341, 10, 70, "Output",
   CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
   CellID->331141622]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5479, 204},
 {"DSolve::nestdv", 5619, 208},
 {"NDSolve::nestdv", 6302, 224},
 {"RSolve::nestdv", 6984, 240}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 91, 5, 70, "ObjectName",
 CellID->21225],
Cell[CellGroupData[{
Cell[819, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1297, 53, 208, 6, 70, "Message",
 CellID->78816881],
Cell[1508, 61, 129, 4, 70, "Notes",
 CellID->27079]
}, Closed]],
Cell[CellGroupData[{
Cell[1674, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->384341794],
Cell[CellGroupData[{
Cell[2059, 84, 147, 5, 70, "ExampleSection",
 CellID->34477901],
Cell[2209, 91, 241, 9, 70, "ExampleText",
 CellID->269408400],
Cell[CellGroupData[{
Cell[2475, 104, 371, 11, 70, "Input",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellID->30924],
Cell[2849, 117, 265, 6, 70, "Message",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellID->507893704],
Cell[3117, 125, 420, 12, 70, "Output",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellID->665414118]
}, Open  ]],
Cell[3552, 140, 209, 8, 70, "ExampleText",
 CellID->613537899],
Cell[CellGroupData[{
Cell[3786, 152, 340, 10, 70, "Input",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellID->14240],
Cell[4129, 164, 341, 10, 70, "Output",
 CellTags->{"DSolve::nestdv", "NDSolve::nestdv", "RSolve::nestdv"},
 CellID->331141622]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4509, 179, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

