(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8056,        300]
NotebookOptionsPosition[      5127,        202]
NotebookOutlinePosition[      6777,        253]
CellTagsIndexPosition[      6661,        247]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["DSolve::nolist", "ObjectName",
 CellID->23125],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nolist\"\>"}], ":", 
  " ", "\<\"List encountered within `1`. There should be no lists on either \
side of the equations.\"\>"}]], "Message", "MSG",
 CellID->264097037],

Cell[TextData[{
 "Generated when within one of the equations in the first argument of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22878],

Cell[TextData[{
 "Lists are typically represented using curly braces ",
 StyleBox["{", "MR"],
 " and ",
 StyleBox["}", "MR"],
 "."
}], "Notes",
 CellID->31883],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " function is not currently designed to compute vector solutions."
}], "Notes",
 CellID->6660]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->241868302],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->11220730],

Cell["\<\
An error occurs in this example because the right side of the first equation \
is enclosed in curly braces.\
\>", "ExampleText",
 CellID->534022740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"{", 
       RowBox[{"f", "[", "x", "]"}], "}"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"DSolve::nolist",
 CellLabel->"In[1]:=",
 CellID->7793],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nolist\"\>"}], ":", 
  " ", "\<\"List encountered within \
\\!\\({\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]]\\)\\)[x]\\)\\) \[Equal] \
\\(\\({\\(f[x]\\)}\\)\\)}\\). There should be no lists on either side of the \
equations.\"\>"}]], "Message", "MSG",
 CellTags->"DSolve::nolist",
 CellID->561141985],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"{", 
       RowBox[{"f", "[", "x", "]"}], "}"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 CellTags->"DSolve::nolist",
 CellLabel->"Out[1]=",
 CellID->170522268]
}, Open  ]],

Cell["\<\
A solution is computed if the extra curly braces are removed.\
\>", "ExampleText",
 CellID->393081541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellTags->"DSolve::nolist",
 CellLabel->"In[2]:=",
 CellID->11418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", "x"]}], "}"}], "}"}]], "Output",
 CellTags->"DSolve::nolist",
 CellLabel->"Out[2]=",
 CellID->244306708]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::nolist - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 11.4339396}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::nolist", "synonyms" -> {}, "title" -> 
    "DSolve::nolist", "type" -> "Message", "uri" -> "ref/message/nolist"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2158, 88, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->241868302]},
 "DSolve::nolist"->{
  Cell[2876, 117, 450, 15, 70, "Input",
   CellTags->"DSolve::nolist",
   CellID->7793],
  Cell[3329, 134, 404, 9, 70, "Message",
   CellTags->"DSolve::nolist",
   CellID->561141985],
  Cell[3736, 145, 502, 16, 70, "Output",
   CellTags->"DSolve::nolist",
   CellID->170522268],
  Cell[4390, 171, 423, 14, 70, "Input",
   CellTags->"DSolve::nolist",
   CellID->11418],
  Cell[4816, 187, 245, 8, 70, "Output",
   CellTags->"DSolve::nolist",
   CellID->244306708]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6034, 224},
 {"DSolve::nolist", 6174, 228}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->23125],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 223, 5, 70, "Message",
 CellID->264097037],
Cell[1484, 56, 237, 8, 70, "Notes",
 CellID->22878],
Cell[1724, 66, 159, 7, 70, "Notes",
 CellID->31883],
Cell[1886, 75, 235, 8, 70, "Notes",
 CellID->6660]
}, Closed]],
Cell[CellGroupData[{
Cell[2158, 88, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->241868302],
Cell[CellGroupData[{
Cell[2543, 102, 147, 5, 70, "ExampleSection",
 CellID->11220730],
Cell[2693, 109, 158, 4, 70, "ExampleText",
 CellID->534022740],
Cell[CellGroupData[{
Cell[2876, 117, 450, 15, 70, "Input",
 CellTags->"DSolve::nolist",
 CellID->7793],
Cell[3329, 134, 404, 9, 70, "Message",
 CellTags->"DSolve::nolist",
 CellID->561141985],
Cell[3736, 145, 502, 16, 70, "Output",
 CellTags->"DSolve::nolist",
 CellID->170522268]
}, Open  ]],
Cell[4253, 164, 112, 3, 70, "ExampleText",
 CellID->393081541],
Cell[CellGroupData[{
Cell[4390, 171, 423, 14, 70, "Input",
 CellTags->"DSolve::nolist",
 CellID->11418],
Cell[4816, 187, 245, 8, 70, "Output",
 CellTags->"DSolve::nolist",
 CellID->244306708]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5100, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

