(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9556,        337]
NotebookOptionsPosition[      4814,        192]
NotebookOutlinePosition[      7796,        278]
CellTagsIndexPosition[      7650,        271]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Export::infer", "ObjectName"],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "::", "\<\"infer\"\>"}], ":", 
  " ", "\<\"Cannot infer format of file `1`.\"\>"}]], "Message", "MSG",
 CellID->448771408],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " is unable to determine the format based on the file extension of the \
indicated channel."
}], "Notes",
 CellID->16917],

Cell[TextData[{
 "The third argument in ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " can be used to specify the format explicitly."
}], "Notes",
 CellID->12397]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->83853979],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->49381036],

Cell["\<\
An error occurs in this example because the file name does not include an \
extension from which to determine the file format.\
\>", "ExampleText",
 CellID->52196337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<TESTFILE\>\"", ",", "\"\<123\>\""}], "]"}]], "Input",
 CellTags->{"Export::guess", "Import::guess"},
 CellLabel->"In[1]:=",
 CellID->19166],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "::", "\<\"infer\"\>"}], ":", 
  " ", "\<\"Cannot infer format of file \\!\\(\\\"TESTFILE\\\"\\).\"\>"}]], \
"Message", "MSG",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->372491899],

Cell[BoxData["$Failed"], "Output",
 CellTags->{"Export::guess", "Import::guess"},
 CellLabel->"Out[1]=",
 CellID->24117818]
}, Open  ]],

Cell["\<\
This example shows the use of a file name with a file extension that \
corresponds to text format.\
\>", "ExampleText",
 CellID->84175182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<TESTFILE.TXT\>\"", ",", "\"\<123\>\""}], "]"}]], "Input",
 CellTags->{"Export::guess", "Import::guess"},
 CellLabel->"In[2]:=",
 CellID->30234],

Cell[BoxData["\<\"TESTFILE.TXT\"\>"], "Output",
 CellTags->{"Export::guess", "Import::guess"},
 CellLabel->"Out[2]=",
 CellID->672937355]
}, Open  ]],

Cell[TextData[{
 "The same format is written if the format is specified explicitly using the \
third argument of ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->567332342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<TESTFILE\>\"", ",", "\"\<123\>\"", ",", "\"\<Text\>\""}], 
  "]"}]], "Input",
 CellTags->{"Export::guess", "Import::guess"},
 CellLabel->"In[3]:=",
 CellID->13662],

Cell[BoxData["\<\"TESTFILE\"\>"], "Output",
 CellTags->{"Export::guess", "Import::guess"},
 CellLabel->"Out[3]=",
 CellID->551696311]
}, Open  ]],

Cell["Remove the test files.", "ExampleText",
 CellID->136861839],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<TESTFILE\>\"", ",", "\"\<TESTFILE.TXT\>\""}], "}"}], 
  "]"}]], "Input",
 CellTags->{"Export::guess", "Import::guess"},
 CellLabel->"In[4]:=",
 CellID->6208]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Export::infer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 59.0601588}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Export::infer", "synonyms" -> {}, "title" -> 
    "Export::infer", "type" -> "Message", "uri" -> "ref/message/infer"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1959, 78, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->83853979]},
 "Export::guess"->{
  Cell[2694, 107, 193, 5, 70, "Input",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->19166],
  Cell[2890, 114, 237, 6, 70, "Message",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->372491899],
  Cell[3130, 122, 123, 3, 70, "Output",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->24117818],
  Cell[3441, 136, 197, 5, 70, "Input",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->30234],
  Cell[3641, 143, 137, 3, 70, "Output",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->672937355],
  Cell[4092, 162, 217, 6, 70, "Input",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->13662],
  Cell[4312, 170, 133, 3, 70, "Output",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->551696311],
  Cell[4528, 179, 232, 7, 70, "Input",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->6208]},
 "Import::guess"->{
  Cell[2694, 107, 193, 5, 70, "Input",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->19166],
  Cell[2890, 114, 237, 6, 70, "Message",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->372491899],
  Cell[3130, 122, 123, 3, 70, "Output",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->24117818],
  Cell[3441, 136, 197, 5, 70, "Input",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->30234],
  Cell[3641, 143, 137, 3, 70, "Output",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->672937355],
  Cell[4092, 162, 217, 6, 70, "Input",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->13662],
  Cell[4312, 170, 133, 3, 70, "Output",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->551696311],
  Cell[4528, 179, 232, 7, 70, "Input",
   CellTags->{"Export::guess", "Import::guess"},
   CellID->6208]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5717, 214},
 {"Export::guess", 5855, 218},
 {"Import::guess", 6751, 243}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 35, 0, 70, "ObjectName"],
Cell[CellGroupData[{
Cell[763, 31, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1241, 48, 166, 4, 70, "Message",
 CellID->448771408],
Cell[1410, 54, 273, 9, 70, "Notes",
 CellID->16917],
Cell[1686, 65, 236, 8, 70, "Notes",
 CellID->12397]
}, Closed]],
Cell[CellGroupData[{
Cell[1959, 78, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->83853979],
Cell[CellGroupData[{
Cell[2343, 92, 147, 5, 70, "ExampleSection",
 CellID->49381036],
Cell[2493, 99, 176, 4, 70, "ExampleText",
 CellID->52196337],
Cell[CellGroupData[{
Cell[2694, 107, 193, 5, 70, "Input",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->19166],
Cell[2890, 114, 237, 6, 70, "Message",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->372491899],
Cell[3130, 122, 123, 3, 70, "Output",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->24117818]
}, Open  ]],
Cell[3268, 128, 148, 4, 70, "ExampleText",
 CellID->84175182],
Cell[CellGroupData[{
Cell[3441, 136, 197, 5, 70, "Input",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->30234],
Cell[3641, 143, 137, 3, 70, "Output",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->672937355]
}, Open  ]],
Cell[3793, 149, 274, 9, 70, "ExampleText",
 CellID->567332342],
Cell[CellGroupData[{
Cell[4092, 162, 217, 6, 70, "Input",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->13662],
Cell[4312, 170, 133, 3, 70, "Output",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->551696311]
}, Open  ]],
Cell[4460, 176, 65, 1, 70, "ExampleText",
 CellID->136861839],
Cell[4528, 179, 232, 7, 70, "Input",
 CellTags->{"Export::guess", "Import::guess"},
 CellID->6208]
}, Open  ]]
}, Open  ]],
Cell[4787, 190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

