(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6727,        235]
NotebookOptionsPosition[      3736,        145]
NotebookOutlinePosition[      5741,        202]
CellTagsIndexPosition[      5585,        195]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Factor::facim
FactorSquareFree::facim\
\>", "ObjectName",
 CellID->10804],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"facim\"\>"}], ":", 
  " ", "\<\"Factoring non-integer polynomials with respect to a modulus is \
not implemented.\"\>"}]], "Message", "MSG",
 CellID->26079981],

Cell[TextData[{
 "Generated when a nonzero value for the ",
 Cell[BoxData[
  ButtonBox["Modulus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Modulus"]], "InlineFormula"],
 " option is used in ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FactorSquareFree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFormula"],
 ", and the polynomial to be factored includes coefficients that are not",
 " ",
 "integers."
}], "Notes",
 CellID->1083]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25068724],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->103122033],

Cell["\<\
An error occurs in this example because one of the coefficients in the \
polynomial to be factored is a complex number rather than an integer.\
\>", "ExampleText",
 CellID->903432288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"I", " ", "-", "x"}], ",", 
   RowBox[{"Modulus", "->", "2"}]}], "]"}]], "Input",
 CellTags->{"Factor::facim", "FactorSquareFree::facim"},
 CellLabel->"In[1]:=",
 CellID->12573],

Cell[BoxData[
 RowBox[{
  RowBox[{"Factor", "::", "\<\"facim\"\>"}], ":", 
  " ", "\<\"Factoring non-integer polynomials with respect to a modulus is \
not implemented.\"\>"}]], "Message", "MSG",
 CellTags->{"Factor::facim", "FactorSquareFree::facim"},
 CellID->115266762],

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"\[ImaginaryI]", "-", "x"}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Output",
 CellTags->{"Factor::facim", "FactorSquareFree::facim"},
 CellLabel->"Out[1]=",
 CellID->144923171]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Factor::facim - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 1, 22.8420176}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Factor::facim FactorSquareFree::facim", "synonyms" -> {}, 
    "title" -> "Factor::facim", "type" -> "Message", "uri" -> 
    "ref/message/facim"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2146, 85, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25068724]},
 "Factor::facim"->{
  Cell[2899, 114, 238, 7, 70, "Input",
   CellTags->{"Factor::facim", "FactorSquareFree::facim"},
   CellID->12573],
  Cell[3140, 123, 272, 6, 70, "Message",
   CellTags->{"Factor::facim", "FactorSquareFree::facim"},
   CellID->115266762],
  Cell[3415, 131, 255, 7, 70, "Output",
   CellTags->{"Factor::facim", "FactorSquareFree::facim"},
   CellID->144923171]},
 "FactorSquareFree::facim"->{
  Cell[2899, 114, 238, 7, 70, "Input",
   CellTags->{"Factor::facim", "FactorSquareFree::facim"},
   CellID->12573],
  Cell[3140, 123, 272, 6, 70, "Message",
   CellTags->{"Factor::facim", "FactorSquareFree::facim"},
   CellID->115266762],
  Cell[3415, 131, 255, 7, 70, "Output",
   CellTags->{"Factor::facim", "FactorSquareFree::facim"},
   CellID->144923171]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4668, 168},
 {"Factor::facim", 4806, 172},
 {"FactorSquareFree::facim", 5199, 182}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 83, 4, 70, "ObjectName",
 CellID->10804],
Cell[CellGroupData[{
Cell[811, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1289, 52, 236, 6, 70, "Message",
 CellID->26079981],
Cell[1528, 60, 581, 20, 70, "Notes",
 CellID->1083]
}, Closed]],
Cell[CellGroupData[{
Cell[2146, 85, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25068724],
Cell[CellGroupData[{
Cell[2530, 99, 148, 5, 70, "ExampleSection",
 CellID->103122033],
Cell[2681, 106, 193, 4, 70, "ExampleText",
 CellID->903432288],
Cell[CellGroupData[{
Cell[2899, 114, 238, 7, 70, "Input",
 CellTags->{"Factor::facim", "FactorSquareFree::facim"},
 CellID->12573],
Cell[3140, 123, 272, 6, 70, "Message",
 CellTags->{"Factor::facim", "FactorSquareFree::facim"},
 CellID->115266762],
Cell[3415, 131, 255, 7, 70, "Output",
 CellTags->{"Factor::facim", "FactorSquareFree::facim"},
 CellID->144923171]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3709, 143, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

